/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fortytwo.ripple.RippleException;
import org.apache.log4j.Logger;

public class URIMap {
    private static final Logger LOGGER = Logger.getLogger(URIMap.class);
    private final Map<String, String> map = new Hashtable<String, String>();
    private String[] fromUris;
    private String[] toUris;
    private boolean upToDate = true;

    public URIMap() {
        this.update();
    }

    private String getPrivate(String urlStr) throws RippleException {
        int i = urlStr.lastIndexOf(35);
        if (i >= 0) {
            urlStr = urlStr.substring(0, i);
        }
        return urlStr;
    }

    private void update() {
        Set<String> keySet = this.map.keySet();
        this.fromUris = new String[keySet.size()];
        Iterator<String> keySetIter = keySet.iterator();
        int j = 0;
        while (keySetIter.hasNext()) {
            this.fromUris[j++] = keySetIter.next();
        }
        Arrays.sort(this.fromUris);
        this.toUris = new String[this.fromUris.length];
        for (int i = 0; i < this.fromUris.length; ++i) {
            this.toUris[i] = this.map.get(this.fromUris[i]);
            LOGGER.debug((Object)("map " + this.fromUris[i] + " to " + this.toUris[i]));
        }
        this.upToDate = true;
    }

    public void put(String from, String to) {
        if (null == from) {
            throw new IllegalArgumentException("can't map from null");
        }
        if (null == to) {
            throw new IllegalArgumentException("can't map to null");
        }
        this.upToDate = false;
        this.map.put(from, to);
    }

    public String get(String uri) throws RippleException {
        if (!this.upToDate) {
            this.update();
        }
        int fromIndex = 0;
        int toIndex = this.fromUris.length - 1;
        int i = -1;
        while (fromIndex <= toIndex) {
            int mid = (fromIndex + toIndex) / 2;
            int cmp = uri.compareTo(this.fromUris[mid]);
            if (cmp > 0) {
                fromIndex = mid + 1;
                i = mid;
                continue;
            }
            if (cmp < 0) {
                toIndex = mid - 1;
                continue;
            }
            return this.getPrivate(this.toUris[mid]);
        }
        if (-1 < i && uri.startsWith(this.fromUris[i])) {
            return this.getPrivate(this.toUris[i] + uri.substring(this.fromUris[i].length()));
        }
        return this.getPrivate(uri);
    }
}

