/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.FetchHint;
import org.vertexium.GraphConfiguration;
import org.vertexium.GraphMetadataStore;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryEdge;
import org.vertexium.inmemory.InMemoryEdgeTable;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.InMemoryGraphConfiguration;
import org.vertexium.inmemory.InMemoryTableEdge;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.inmemory.InMemoryTableVertex;
import org.vertexium.inmemory.InMemoryVertex;
import org.vertexium.inmemory.InMemoryVertexTable;
import org.vertexium.mutation.SetPropertyMetadata;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.sql.SqlEdgeTable;
import org.vertexium.sql.SqlGraphConfiguration;
import org.vertexium.sql.SqlGraphMetadataStore;
import org.vertexium.sql.SqlStreamingPropertyTable;
import org.vertexium.sql.SqlTableEdge;
import org.vertexium.sql.SqlTableVertex;
import org.vertexium.sql.SqlVertexTable;
import org.vertexium.sql.collections.SqlMap;
import org.vertexium.sql.collections.Storable;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.LookAheadIterable;

public class SqlGraph
extends InMemoryGraph {
    private final SqlMap<InMemoryTableElement<InMemoryVertex>> vertexMap;
    private final SqlMap<InMemoryTableElement<InMemoryEdge>> edgeMap;
    private final SqlStreamingPropertyTable streamingPropertyTable;

    public SqlGraph(SqlGraphConfiguration configuration) {
        this(new ConfigHolder(configuration));
    }

    private SqlGraph(ConfigHolder configHolder) {
        super((InMemoryGraphConfiguration)configHolder.configuration, (InMemoryVertexTable)new SqlVertexTable(configHolder.vertexMap), (InMemoryEdgeTable)new SqlEdgeTable(configHolder.edgeMap));
        this.vertexMap = configHolder.vertexMap;
        this.edgeMap = configHolder.edgeMap;
        this.streamingPropertyTable = configHolder.streamingPropertyTable;
        this.vertexMap.setStorableContext((Object)this);
        this.edgeMap.setStorableContext((Object)this);
    }

    protected GraphMetadataStore newGraphMetadataStore(GraphConfiguration configuration) {
        return new SqlGraphMetadataStore(((SqlGraphConfiguration)configuration).newMetadataMap());
    }

    public static SqlGraph create(SqlGraphConfiguration config) {
        SqlGraph graph = new SqlGraph(config);
        graph.setup();
        return graph;
    }

    public static SqlGraph create(Map<String, Object> config) {
        return SqlGraph.create(new SqlGraphConfiguration(config));
    }

    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        this.validateAuthorizations(authorizations);
        InMemoryTableElement<InMemoryVertex> element = this.vertexMap.get(vertexId);
        if (element == null || !this.isIncludedInTimeSpan(element, fetchHints, endTime, authorizations)) {
            return null;
        }
        return (Vertex)element.createElement((InMemoryGraph)this, fetchHints.contains(FetchHint.INCLUDE_HIDDEN), endTime, authorizations);
    }

    public Iterable<Vertex> getVerticesWithPrefix(final String vertexIdPrefix, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        this.validateAuthorizations(authorizations);
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryTableVertex, Vertex>(){

            protected boolean isIncluded(InMemoryTableVertex element, Vertex vertex) {
                return vertex != null && SqlGraph.this.isIncluded((InMemoryTableElement)element, fetchHints, authorizations);
            }

            protected Vertex convert(InMemoryTableVertex element) {
                return (Vertex)element.createElement((InMemoryGraph)SqlGraph.this, includeHidden, endTime, authorizations);
            }

            protected Iterator<InMemoryTableVertex> createIterator() {
                Iterator elements = SqlGraph.this.vertexMap.query("id like ?", vertexIdPrefix + "%");
                return new ConvertingIterable<InMemoryTableElement<InMemoryVertex>, InMemoryTableVertex>(elements){

                    protected InMemoryTableVertex convert(InMemoryTableElement<InMemoryVertex> element) {
                        return ((SqlTableVertex)element).asInMemoryTableVertex();
                    }
                }.iterator();
            }
        };
    }

    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        InMemoryTableElement<InMemoryEdge> element = this.edgeMap.get(edgeId);
        if (element == null || !this.isIncluded(element, fetchHints, authorizations)) {
            return null;
        }
        return (Edge)element.createElement((InMemoryGraph)this, fetchHints.contains(FetchHint.INCLUDE_HIDDEN), endTime, authorizations);
    }

    public Iterable<Edge> getEdges(final Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryTableEdge, Edge>(){

            protected boolean isIncluded(InMemoryTableEdge element, Edge edge) {
                return edge != null && SqlGraph.this.isIncluded((InMemoryTableElement)element, fetchHints, authorizations);
            }

            protected Edge convert(InMemoryTableEdge element) {
                return (Edge)element.createElement((InMemoryGraph)SqlGraph.this, includeHidden, endTime, authorizations);
            }

            protected Iterator<InMemoryTableEdge> createIterator() {
                StringBuilder idWhere = new StringBuilder();
                boolean first = true;
                for (String id : ids) {
                    if (first) {
                        idWhere.append("id = ?");
                        first = false;
                        continue;
                    }
                    idWhere.append(" or id = ?");
                }
                if (first) {
                    return Collections.emptyIterator();
                }
                Iterator elements = SqlGraph.this.edgeMap.query(idWhere.toString(), Iterables.toArray((Iterable)ids, Object.class));
                return new ConvertingIterable<InMemoryTableElement<InMemoryEdge>, InMemoryTableEdge>(elements){

                    protected InMemoryTableEdge convert(InMemoryTableElement<InMemoryEdge> element) {
                        return ((SqlTableEdge)element).asInMemoryTableEdge();
                    }
                }.iterator();
            }
        };
    }

    public Iterable<Edge> getEdgesFromVertex(final String vertexId, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryTableEdge, Edge>(){

            protected boolean isIncluded(InMemoryTableEdge element, Edge edge) {
                return edge != null && SqlGraph.this.isIncluded((InMemoryTableElement)element, fetchHints, authorizations);
            }

            protected Edge convert(InMemoryTableEdge element) {
                return (Edge)element.createElement((InMemoryGraph)SqlGraph.this, includeHidden, endTime, authorizations);
            }

            protected Iterator<InMemoryTableEdge> createIterator() {
                Iterator elements = SqlGraph.this.edgeMap.query("in_vertex_id = ? or out_vertex_id = ?", vertexId, vertexId);
                return new ConvertingIterable<InMemoryTableElement<InMemoryEdge>, InMemoryTableEdge>(elements){

                    protected InMemoryTableEdge convert(InMemoryTableElement<InMemoryEdge> element) {
                        return ((SqlTableEdge)element).asInMemoryTableEdge();
                    }
                }.iterator();
            }
        };
    }

    protected void alterElementPropertyMetadata(InMemoryTableElement inMemoryTableElement, List<SetPropertyMetadata> setPropertyMetadatas, Authorizations authorizations) {
        super.alterElementPropertyMetadata(inMemoryTableElement, setPropertyMetadatas, authorizations);
        ((Storable)inMemoryTableElement).store();
    }

    protected SqlStreamingPropertyTable getStreamingPropertyTable() {
        return this.streamingPropertyTable;
    }

    protected StreamingPropertyValueRef saveStreamingPropertyValue(String elementId, String key, String name, Visibility visibility, long timestamp, StreamingPropertyValue value) {
        return this.streamingPropertyTable.put(elementId, key, name, visibility, timestamp, value);
    }

    private static class ConfigHolder {
        final SqlGraphConfiguration configuration;
        final SqlMap<InMemoryTableElement<InMemoryVertex>> vertexMap;
        final SqlMap<InMemoryTableElement<InMemoryEdge>> edgeMap;
        final SqlStreamingPropertyTable streamingPropertyTable;

        ConfigHolder(SqlGraphConfiguration configuration) {
            this.configuration = configuration;
            this.vertexMap = configuration.newVertexMap();
            this.edgeMap = configuration.newEdgeMap();
            this.streamingPropertyTable = configuration.newStreamingPropertyTable();
        }
    }
}

