/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.vertexium.Visibility;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.sql.SqlStreamingPropertyTable;
import org.vertexium.util.AutoDeleteFileInputStream;
import org.vertexium.util.StreamUtils;

public class SqlStreamingPropertyValue
extends StreamingPropertyValue {
    private static final int IN_MEMORY_STREAM_MAX_BYTES = 0x100000;
    private static final int DEFAULT_IN_MEMORY_INIT_CAPACITY = 1024;
    private final DBI dbi;
    private final String tableName;
    private final String elementId;
    private final String key;
    private final String name;
    private final Visibility visibility;
    private final long timestamp;

    public SqlStreamingPropertyValue(Class valueType, long length, DBI dbi, String tableName, String elementId, String key, String name, Visibility visibility, long timestamp) {
        super(null, valueType, length);
        this.dbi = dbi;
        this.tableName = tableName;
        this.elementId = elementId;
        this.key = key;
        this.name = name;
        this.visibility = visibility;
        this.timestamp = timestamp;
    }

    public InputStream getInputStream() {
        try (Handle handle = this.dbi.open();){
            SqlStreamingPropertyTable.Row row = (SqlStreamingPropertyTable.Row)((Query)handle.createQuery(String.format("select %s from %s where %s = ?", "data", this.tableName, "id")).bind(0, SqlStreamingPropertyTable.makeId(this.elementId, this.key, this.name, this.visibility, this.timestamp))).map((ResultSetMapper)new RowResultSetMapper()).first();
            InputStream inputStream = this.copyInputStream(row.inputStream);
            return inputStream;
        }
    }

    private InputStream copyInputStream(InputStream inputStream) {
        try {
            long length = this.getLength();
            if (length < 0L || length > 0x100000L) {
                return new AutoDeleteFileInputStream(inputStream);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)length);
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private static class RowResultSetMapper
    implements ResultSetMapper<SqlStreamingPropertyTable.Row> {
        private RowResultSetMapper() {
        }

        public SqlStreamingPropertyTable.Row map(int index, ResultSet rs, StatementContext ctx) throws SQLException {
            SqlStreamingPropertyTable.Row row = new SqlStreamingPropertyTable.Row();
            row.inputStream = rs.getBinaryStream("data");
            return row;
        }
    }
}

