/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.DefinePropertyBuilder;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.EdgeInfo;
import org.vertexium.ElementBuilder;
import org.vertexium.ElementFilter;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.GraphMetadataStore;
import org.vertexium.Metadata;
import org.vertexium.Path;
import org.vertexium.ProgressCallback;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.RelatedEdge;
import org.vertexium.RelatedEdgeImpl;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumTypeException;
import org.vertexium.Visibility;
import org.vertexium.event.GraphEvent;
import org.vertexium.event.GraphEventListener;
import org.vertexium.id.IdGenerator;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.LookAheadIterable;
import org.vertexium.util.Preconditions;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public abstract class GraphBase
implements Graph {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(GraphBase.class);
    protected static final VertexiumLogger QUERY_LOGGER = VertexiumLoggerFactory.getQueryLogger(Graph.class);
    public static final String METADATA_DEFINE_PROPERTY_PREFIX = "defineProperty.";
    private final List<GraphEventListener> graphEventListeners = new ArrayList<GraphEventListener>();
    private Map<String, PropertyDefinition> propertyDefinitionCache = new HashMap<String, PropertyDefinition>();
    private final boolean strictTyping;

    protected GraphBase(boolean strictTyping) {
        this.strictTyping = strictTyping;
    }

    @Override
    public Vertex addVertex(Visibility visibility, Authorizations authorizations) {
        return this.prepareVertex(visibility).save(authorizations);
    }

    @Override
    public Vertex addVertex(String vertexId, Visibility visibility, Authorizations authorizations) {
        return this.prepareVertex(vertexId, visibility).save(authorizations);
    }

    @Override
    public Iterable<Vertex> addVertices(Iterable<ElementBuilder<Vertex>> vertices, Authorizations authorizations) {
        ArrayList<Vertex> addedVertices = new ArrayList<Vertex>();
        for (ElementBuilder<Vertex> vertexBuilder : vertices) {
            addedVertices.add(vertexBuilder.save(authorizations));
        }
        return addedVertices;
    }

    @Override
    public VertexBuilder prepareVertex(Visibility visibility) {
        return this.prepareVertex(this.getIdGenerator().nextId(), null, visibility);
    }

    @Override
    public abstract VertexBuilder prepareVertex(String var1, Long var2, Visibility var3);

    @Override
    public VertexBuilder prepareVertex(Long timestamp, Visibility visibility) {
        return this.prepareVertex(this.getIdGenerator().nextId(), timestamp, visibility);
    }

    @Override
    public VertexBuilder prepareVertex(String vertexId, Visibility visibility) {
        return this.prepareVertex(vertexId, null, visibility);
    }

    @Override
    public boolean doesVertexExist(String vertexId, Authorizations authorizations) {
        return this.getVertex(vertexId, FetchHint.NONE, authorizations) != null;
    }

    @Override
    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertex(vertexId, fetchHints, null, authorizations);
    }

    @Override
    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        LOGGER.warn("Performing scan of all vertices! Override getVertex.", new Object[0]);
        for (Vertex vertex : this.getVertices(fetchHints, endTime, authorizations)) {
            if (!vertex.getId().equals(vertexId)) continue;
            return vertex;
        }
        return null;
    }

    @Override
    public Vertex getVertex(String vertexId, Authorizations authorizations) throws VertexiumException {
        return this.getVertex(vertexId, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, Authorizations authorizations) {
        return this.getVerticesWithPrefix(vertexIdPrefix, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVerticesWithPrefix(vertexIdPrefix, fetchHints, null, authorizations);
    }

    @Override
    public Iterable<Vertex> getVerticesWithPrefix(final String vertexIdPrefix, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        LOGGER.warn("Performing scan of all vertices! Override getVerticesWithPrefix.", new Object[0]);
        Iterable<Vertex> vertices = this.getVertices(fetchHints, endTime, authorizations);
        return new FilterIterable<Vertex>(vertices){

            @Override
            protected boolean isIncluded(Vertex v) {
                return v.getId().startsWith(vertexIdPrefix);
            }
        };
    }

    @Override
    public Iterable<Vertex> getVertices(Iterable<String> ids, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(ids, fetchHints, null, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(final Iterable<String> ids, EnumSet<FetchHint> fetchHints, Long endTime, final Authorizations authorizations) {
        LOGGER.warn("Getting each vertex one by one! Override getVertices(java.lang.Iterable<java.lang.String>, Authorizations)", new Object[0]);
        return new LookAheadIterable<String, Vertex>(){

            @Override
            protected boolean isIncluded(String src, Vertex vertex) {
                return vertex != null;
            }

            @Override
            protected Vertex convert(String id) {
                return GraphBase.this.getVertex(id, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return ids.iterator();
            }
        };
    }

    @Override
    public Map<String, Boolean> doVerticesExist(Iterable<String> ids, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Vertex vertex : this.getVertices(ids, FetchHint.NONE, authorizations)) {
            results.put(vertex.getId(), true);
        }
        return results;
    }

    @Override
    public Iterable<Vertex> getVertices(Iterable<String> ids, Authorizations authorizations) {
        return this.getVertices(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public List<Vertex> getVerticesInOrder(Iterable<String> ids, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        final List<String> vertexIds = IterableUtils.toList(ids);
        List<Vertex> vertices = IterableUtils.toList(this.getVertices(vertexIds, authorizations));
        Collections.sort(vertices, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex v1, Vertex v2) {
                Integer i1 = vertexIds.indexOf(v1.getId());
                Integer i2 = vertexIds.indexOf(v2.getId());
                return i1.compareTo(i2);
            }
        });
        return vertices;
    }

    @Override
    public List<Vertex> getVerticesInOrder(Iterable<String> ids, Authorizations authorizations) {
        return this.getVerticesInOrder(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(Authorizations authorizations) throws VertexiumException {
        return this.getVertices(FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(fetchHints, (Long)null, authorizations);
    }

    @Override
    public abstract Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    @Override
    public Edge addEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertex, inVertex, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    @Override
    public EdgeBuilderByVertexId prepareEdge(String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertexId, inVertexId, label, visibility);
    }

    @Override
    public EdgeBuilder prepareEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertex, inVertex, label, visibility);
    }

    @Override
    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility);
    }

    @Override
    public abstract EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Long var5, Visibility var6);

    @Override
    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, null, visibility);
    }

    @Override
    public abstract EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Long var5, Visibility var6);

    @Override
    public boolean doesEdgeExist(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, FetchHint.NONE, authorizations) != null;
    }

    @Override
    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdge(edgeId, fetchHints, null, authorizations);
    }

    @Override
    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        LOGGER.warn("Performing scan of all edges! Override getEdge.", new Object[0]);
        for (Edge edge : this.getEdges(fetchHints, endTime, authorizations)) {
            if (!edge.getId().equals(edgeId)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Edge getEdge(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, FetchHint.ALL, authorizations);
    }

    @Override
    public Map<String, Boolean> doEdgesExist(Iterable<String> ids, Authorizations authorizations) {
        return this.doEdgesExist(ids, null, authorizations);
    }

    @Override
    public Map<String, Boolean> doEdgesExist(Iterable<String> ids, Long endTime, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Edge edge : this.getEdges(ids, FetchHint.NONE, endTime, authorizations)) {
            results.put(edge.getId(), true);
        }
        return results;
    }

    @Override
    public void deleteVertex(String vertexId, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to delete with id: " + vertexId);
        this.deleteVertex(vertex, authorizations);
    }

    @Override
    public void deleteEdge(String edgeId, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to delete with id: " + edgeId);
        this.deleteEdge(edge, authorizations);
    }

    @Override
    public void softDeleteVertex(String vertexId, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to soft delete with id: " + vertexId);
        this.softDeleteVertex(vertex, null, authorizations);
    }

    @Override
    public void softDeleteVertex(String vertexId, Long timestamp, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to soft delete with id: " + vertexId);
        this.softDeleteVertex(vertex, timestamp, authorizations);
    }

    @Override
    public void softDeleteVertex(Vertex vertex, Authorizations authorizations) {
        this.softDeleteVertex(vertex, null, authorizations);
    }

    @Override
    public abstract void softDeleteVertex(Vertex var1, Long var2, Authorizations var3);

    @Override
    public void softDeleteEdge(String edgeId, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to soft delete with id: " + edgeId);
        this.softDeleteEdge(edge, null, authorizations);
    }

    @Override
    public void softDeleteEdge(String edgeId, Long timestamp, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to soft delete with id: " + edgeId);
        this.softDeleteEdge(edge, timestamp, authorizations);
    }

    @Override
    public void softDeleteEdge(Edge edge, Authorizations authorizations) {
        this.softDeleteEdge(edge, null, authorizations);
    }

    @Override
    public abstract void softDeleteEdge(Edge var1, Long var2, Authorizations var3);

    @Override
    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> edgeIds, final String authorizationToMatch, final EnumSet<ElementFilter> filters, Authorizations authorizations) {
        FilterIterable<Edge> edges = new FilterIterable<Edge>(this.getEdges(edgeIds, FetchHint.ALL_INCLUDING_HIDDEN, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                if (filters.contains((Object)ElementFilter.ELEMENT) && edge.getVisibility().hasAuthorization(authorizationToMatch)) {
                    return true;
                }
                if (filters.contains((Object)ElementFilter.PROPERTY) || filters.contains((Object)ElementFilter.PROPERTY_METADATA)) {
                    for (Property property : edge.getProperties()) {
                        if (filters.contains((Object)ElementFilter.PROPERTY) && property.getVisibility().hasAuthorization(authorizationToMatch)) {
                            return true;
                        }
                        if (!filters.contains((Object)ElementFilter.PROPERTY_METADATA)) continue;
                        for (Metadata.Entry entry : property.getMetadata().entrySet()) {
                            if (!entry.getVisibility().hasAuthorization(authorizationToMatch)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        return new ConvertingIterable<Edge, String>((Iterable)edges){

            @Override
            protected String convert(Edge edge) {
                return edge.getId();
            }
        };
    }

    @Override
    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> vertexIds, final String authorizationToMatch, final EnumSet<ElementFilter> filters, Authorizations authorizations) {
        FilterIterable<Vertex> vertices = new FilterIterable<Vertex>(this.getVertices(vertexIds, FetchHint.ALL_INCLUDING_HIDDEN, authorizations)){

            @Override
            protected boolean isIncluded(Vertex vertex) {
                if (filters.contains((Object)ElementFilter.ELEMENT) && vertex.getVisibility().hasAuthorization(authorizationToMatch)) {
                    return true;
                }
                if (filters.contains((Object)ElementFilter.PROPERTY) || filters.contains((Object)ElementFilter.PROPERTY_METADATA)) {
                    for (Property property : vertex.getProperties()) {
                        if (filters.contains((Object)ElementFilter.PROPERTY) && property.getVisibility().hasAuthorization(authorizationToMatch)) {
                            return true;
                        }
                        if (!filters.contains((Object)ElementFilter.PROPERTY_METADATA)) continue;
                        for (Metadata.Entry entry : property.getMetadata().entrySet()) {
                            if (!entry.getVisibility().hasAuthorization(authorizationToMatch)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        return new ConvertingIterable<Vertex, String>((Iterable)vertices){

            @Override
            protected String convert(Vertex vertex) {
                return vertex.getId();
            }
        };
    }

    @Override
    public Iterable<Edge> getEdges(Iterable<String> ids, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(ids, fetchHints, null, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(final Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        LOGGER.warn("Getting each edge one by one! Override getEdges(java.lang.Iterable<java.lang.String>, Authorizations)", new Object[0]);
        return new LookAheadIterable<String, Edge>(){

            @Override
            protected boolean isIncluded(String src, Edge edge) {
                return edge != null;
            }

            @Override
            protected Edge convert(String id) {
                return GraphBase.this.getEdge(id, fetchHints, endTime, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return ids.iterator();
            }
        };
    }

    @Override
    public Iterable<Edge> getEdges(Iterable<String> ids, Authorizations authorizations) {
        return this.getEdges(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Authorizations authorizations) {
        return this.getEdges(FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(fetchHints, (Long)null, authorizations);
    }

    @Override
    public abstract Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, Authorizations authorizations) {
        return this.findPaths(sourceVertexId, destVertexId, null, maxHops, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, String[] labels, int maxHops, Authorizations authorizations) {
        ProgressCallback progressCallback = new ProgressCallback(){

            @Override
            public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                LOGGER.debug("findPaths progress %d%%: %s", (int)(progressPercent * 100.0), step.formatMessage(edgeIndex, vertexCount));
            }
        };
        return this.findPaths(sourceVertexId, destVertexId, labels, maxHops, progressCallback, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        return this.findPaths(sourceVertexId, destVertexId, null, maxHops, progressCallback, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, String[] labels, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        EnumSet<FetchHint> fetchHints = FetchHint.EDGE_REFS;
        Vertex sourceVertex = this.getVertex(sourceVertexId, fetchHints, authorizations);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + sourceVertexId);
        }
        Vertex destVertex = this.getVertex(destVertexId, fetchHints, authorizations);
        if (destVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + destVertexId);
        }
        progressCallback.progress(0.0, ProgressCallback.Step.FINDING_PATH);
        HashSet<String> seenVertices = new HashSet<String>();
        seenVertices.add(sourceVertex.getId());
        Path startPath = new Path(sourceVertex.getId());
        ArrayList<Path> foundPaths = new ArrayList<Path>();
        if (maxHops == 2) {
            this.findPathsSetIntersection(foundPaths, sourceVertex, destVertex, labels, progressCallback, authorizations);
        } else {
            this.findPathsRecursive(foundPaths, sourceVertex, destVertex, labels, maxHops, maxHops, seenVertices, startPath, progressCallback, authorizations);
        }
        progressCallback.progress(1.0, ProgressCallback.Step.COMPLETE);
        return foundPaths;
    }

    protected void findPathsSetIntersection(List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, String[] labels, ProgressCallback progressCallback, Authorizations authorizations) {
        String sourceVertexId = sourceVertex.getId();
        String destVertexId = destVertex.getId();
        progressCallback.progress(0.1, ProgressCallback.Step.SEARCHING_SOURCE_VERTEX_EDGES);
        Set<String> sourceVertexConnectedVertexIds = IterableUtils.toSet(sourceVertex.getVertexIds(Direction.BOTH, labels, authorizations));
        progressCallback.progress(0.3, ProgressCallback.Step.SEARCHING_DESTINATION_VERTEX_EDGES);
        Set<String> destVertexConnectedVertexIds = IterableUtils.toSet(destVertex.getVertexIds(Direction.BOTH, labels, authorizations));
        progressCallback.progress(0.6, ProgressCallback.Step.MERGING_EDGES);
        sourceVertexConnectedVertexIds.retainAll(destVertexConnectedVertexIds);
        progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        for (String connectedVertexId : sourceVertexConnectedVertexIds) {
            foundPaths.add(new Path(sourceVertexId, connectedVertexId, destVertexId));
        }
    }

    protected void findPathsRecursive(List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, String[] labels, int hops, int totalHops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback, Authorizations authorizations) {
        boolean firstLevelRecursion = hops == totalHops;
        seenVertices.add(sourceVertex.getId());
        if (sourceVertex.getId().equals(destVertex.getId())) {
            foundPaths.add(currentPath);
        } else if (hops > 0) {
            Iterable<Vertex> vertices = sourceVertex.getVertices(Direction.BOTH, labels, authorizations);
            int vertexCount = 0;
            if (firstLevelRecursion) {
                vertices = IterableUtils.toList(vertices);
                vertexCount = ((List)vertices).size();
            }
            int i = 0;
            for (Vertex child : vertices) {
                if (firstLevelRecursion) {
                    double progressPercent = (double)i / (double)vertexCount;
                    progressCallback.progress(progressPercent, ProgressCallback.Step.SEARCHING_EDGES, i + 1, vertexCount);
                }
                if (!seenVertices.contains(child.getId())) {
                    this.findPathsRecursive(foundPaths, child, destVertex, labels, hops - 1, totalHops, seenVertices, new Path(currentPath, child.getId()), progressCallback, authorizations);
                }
                ++i;
            }
        }
        seenVertices.remove(sourceVertex.getId());
    }

    @Override
    @Deprecated
    public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, authorizations);
    }

    @Override
    @Deprecated
    public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, endTime, authorizations);
    }

    @Override
    public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, null, authorizations);
    }

    @Override
    public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        return this.findRelatedEdgeIdsForVertices(this.getVertices(vertexIds, EnumSet.of(FetchHint.OUT_EDGE_REFS), endTime, authorizations), authorizations);
    }

    @Override
    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeSummary(vertexIds, null, authorizations);
    }

    @Override
    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        return this.findRelatedEdgeSummaryForVertices(this.getVertices(vertexIds, EnumSet.of(FetchHint.OUT_EDGE_REFS), endTime, authorizations), authorizations);
    }

    @Override
    public Iterable<RelatedEdge> findRelatedEdgeSummaryForVertices(Iterable<Vertex> verticesIterable, Authorizations authorizations) {
        ArrayList<RelatedEdge> results = new ArrayList<RelatedEdge>();
        List<Vertex> vertices = IterableUtils.toList(verticesIterable);
        for (Vertex outVertex : vertices) {
            Iterable<EdgeInfo> edgeInfos = outVertex.getEdgeInfos(Direction.OUT, authorizations);
            for (EdgeInfo edgeInfo : edgeInfos) {
                for (Vertex inVertex : vertices) {
                    if (!edgeInfo.getVertexId().equals(inVertex.getId())) continue;
                    results.add(new RelatedEdgeImpl(edgeInfo.getEdgeId(), edgeInfo.getLabel(), outVertex.getId(), inVertex.getId()));
                }
            }
        }
        return results;
    }

    @Override
    public Iterable<String> findRelatedEdgeIdsForVertices(Iterable<Vertex> verticesIterable, Authorizations authorizations) {
        ArrayList<String> results = new ArrayList<String>();
        List<Vertex> vertices = IterableUtils.toList(verticesIterable);
        for (Vertex outVertex : vertices) {
            if (outVertex == null) {
                throw new VertexiumException("verticesIterable cannot have null values");
            }
            Iterable<EdgeInfo> edgeInfos = outVertex.getEdgeInfos(Direction.OUT, authorizations);
            for (EdgeInfo edgeInfo : edgeInfos) {
                for (Vertex inVertex : vertices) {
                    if (!edgeInfo.getVertexId().equals(inVertex.getId())) continue;
                    results.add(edgeInfo.getEdgeId());
                }
            }
        }
        return results;
    }

    protected abstract GraphMetadataStore getGraphMetadataStore();

    @Override
    public final Iterable<GraphMetadataEntry> getMetadata() {
        return this.getGraphMetadataStore().getMetadata();
    }

    @Override
    public final void setMetadata(String key, Object value) {
        this.getGraphMetadataStore().setMetadata(key, value);
    }

    @Override
    public final Object getMetadata(String key) {
        return this.getGraphMetadataStore().getMetadata(key);
    }

    @Override
    public final Iterable<GraphMetadataEntry> getMetadataWithPrefix(String prefix) {
        return this.getGraphMetadataStore().getMetadataWithPrefix(prefix);
    }

    @Override
    public abstract GraphQuery query(Authorizations var1);

    @Override
    public abstract GraphQuery query(String var1, Authorizations var2);

    @Override
    public abstract void reindex(Authorizations var1);

    @Override
    public abstract void flush();

    @Override
    public abstract void shutdown();

    @Override
    public abstract void drop();

    @Override
    public abstract boolean isFieldBoostSupported();

    @Override
    public abstract SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    @Override
    public void addGraphEventListener(GraphEventListener graphEventListener) {
        this.graphEventListeners.add(graphEventListener);
    }

    protected boolean hasEventListeners() {
        return this.graphEventListeners.size() > 0;
    }

    protected void fireGraphEvent(GraphEvent graphEvent) {
        for (GraphEventListener graphEventListener : this.graphEventListeners) {
            graphEventListener.onGraphEvent(graphEvent);
        }
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return false;
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        throw new VertexiumException("querySimilarTo not supported");
    }

    @Override
    public Authorizations createAuthorizations(Collection<String> auths) {
        Preconditions.checkNotNull(auths, "auths cannot be null");
        return this.createAuthorizations(auths.toArray(new String[auths.size()]));
    }

    @Override
    public Authorizations createAuthorizations(Authorizations auths, String ... additionalAuthorizations) {
        HashSet<String> newAuths = new HashSet<String>();
        Collections.addAll(newAuths, auths.getAuthorizations());
        Collections.addAll(newAuths, additionalAuthorizations);
        return this.createAuthorizations(newAuths);
    }

    @Override
    public Authorizations createAuthorizations(Authorizations auths, Collection<String> additionalAuthorizations) {
        return this.createAuthorizations(auths, additionalAuthorizations.toArray(new String[additionalAuthorizations.size()]));
    }

    @Override
    public Map<Object, Long> getVertexPropertyCountByValue(String propertyName, Authorizations authorizations) {
        HashMap<Object, Long> countsByValue = new HashMap<Object, Long>();
        for (Vertex v : this.getVertices(authorizations)) {
            for (Property p : v.getProperties()) {
                Long currentValue;
                if (!propertyName.equals(p.getName())) continue;
                Object mapKey = p.getValue();
                if (mapKey instanceof String) {
                    mapKey = ((String)mapKey).toLowerCase();
                }
                if ((currentValue = (Long)countsByValue.get(mapKey)) == null) {
                    countsByValue.put(mapKey, 1L);
                    continue;
                }
                countsByValue.put(mapKey, currentValue + 1L);
            }
        }
        return countsByValue;
    }

    @Override
    public long getVertexCount(Authorizations authorizations) {
        return IterableUtils.count(this.getVertices(authorizations));
    }

    @Override
    public long getEdgeCount(Authorizations authorizations) {
        return IterableUtils.count(this.getEdges(authorizations));
    }

    @Override
    public abstract void deleteVertex(Vertex var1, Authorizations var2);

    @Override
    public abstract void deleteEdge(Edge var1, Authorizations var2);

    @Override
    public abstract MultiVertexQuery query(String[] var1, String var2, Authorizations var3);

    @Override
    public abstract MultiVertexQuery query(String[] var1, Authorizations var2);

    @Override
    public abstract IdGenerator getIdGenerator();

    @Override
    public abstract boolean isVisibilityValid(Visibility var1, Authorizations var2);

    @Override
    public abstract void truncate();

    @Override
    public abstract void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract Authorizations createAuthorizations(String ... var1);

    @Override
    public DefinePropertyBuilder defineProperty(String propertyName) {
        return new DefinePropertyBuilder(propertyName){

            @Override
            public PropertyDefinition define() {
                PropertyDefinition propertyDefinition = super.define();
                GraphBase.this.savePropertyDefinition(propertyDefinition);
                return propertyDefinition;
            }
        };
    }

    protected void addToPropertyDefinitionCache(PropertyDefinition propertyDefinition) {
        this.propertyDefinitionCache.put(propertyDefinition.getPropertyName(), propertyDefinition);
    }

    @Override
    public void savePropertyDefinition(PropertyDefinition propertyDefinition) {
        this.addToPropertyDefinitionCache(propertyDefinition);
        this.setMetadata(this.getPropertyDefinitionKey(propertyDefinition.getPropertyName()), propertyDefinition);
    }

    private String getPropertyDefinitionKey(String propertyName) {
        return METADATA_DEFINE_PROPERTY_PREFIX + propertyName;
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propertyName) {
        PropertyDefinition propertyDefinition = this.propertyDefinitionCache.get(propertyName);
        if (propertyDefinition != null) {
            return propertyDefinition;
        }
        propertyDefinition = (PropertyDefinition)this.getMetadata(this.getPropertyDefinitionKey(propertyName));
        if (propertyDefinition != null) {
            this.propertyDefinitionCache.put(propertyName, propertyDefinition);
        }
        return propertyDefinition;
    }

    @Override
    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitionCache.values();
    }

    @Override
    public boolean isPropertyDefined(String propertyName) {
        return this.propertyDefinitionCache.containsKey(propertyName);
    }

    public void ensurePropertyDefined(String name, Object value) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(name);
        if (propertyDefinition != null) {
            return;
        }
        Class<?> valueClass = this.getValueType(value);
        if (this.strictTyping) {
            throw new VertexiumTypeException(name, valueClass);
        }
        LOGGER.warn("creating default property definition because a previous definition could not be found for property \"" + name + "\" of type " + valueClass, new Object[0]);
        propertyDefinition = new PropertyDefinition(name, valueClass, TextIndexHint.ALL);
        this.savePropertyDefinition(propertyDefinition);
    }

    protected Class<?> getValueType(Object value) {
        Class valueClass = value.getClass();
        if (value instanceof StreamingPropertyValue) {
            valueClass = ((StreamingPropertyValue)value).getValueType();
        } else if (value instanceof StreamingPropertyValueRef) {
            valueClass = ((StreamingPropertyValueRef)value).getValueType();
        }
        return valueClass;
    }
}

