/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.fortytwo.ripple.Ripple;
import net.fortytwo.ripple.RippleException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.openrdf.rio.RDFFormat;

public class HTTPUtils {
    public static final String ACCEPT = "Accept";
    public static final String BODY = "Body";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String SPARQL_QUERY = "application/sparql-query";
    public static final String USER_AGENT = "User-Agent";
    private static final Map<String, Date> LAST_REQUEST_BY_HOST = new HashMap<String, Date>();
    private static long courtesyInterval;
    private static long connectionTimeout;
    private static boolean initialized;

    private static void initialize() throws RippleException {
        courtesyInterval = Ripple.getConfiguration().getLong("net.fortytwo.ripple.io.httpConnectionCourtesyInterval");
        connectionTimeout = Ripple.getConfiguration().getLong("net.fortytwo.ripple.io.httpConnectionTimeout");
        initialized = true;
    }

    public static HttpClient createClient() throws RippleException {
        if (!initialized) {
            HTTPUtils.initialize();
        }
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        client.getParams().setParameter("http.connection.timeout", (Object)((int)connectionTimeout));
        client.getParams().setParameter("http.socket.timeout", (Object)((int)connectionTimeout));
        return client;
    }

    public static HttpMethod createGetMethod(String url) throws RippleException {
        GetMethod method;
        try {
            method = new GetMethod(url);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
        HTTPUtils.setAgent((HttpMethod)method);
        return method;
    }

    public static PostMethod createPostMethod(String url) throws RippleException {
        PostMethod method;
        try {
            method = new PostMethod(url);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
        HTTPUtils.setAgent((HttpMethod)method);
        return method;
    }

    public static HttpMethod createRdfGetMethod(String url) throws RippleException {
        HttpMethod method = HTTPUtils.createGetMethod(url);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (RDFFormat f : RDFFormat.values()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(f.getDefaultMIMEType());
        }
        HTTPUtils.setAcceptHeader(method, sb.toString());
        return method;
    }

    public static PostMethod createSparqlUpdateMethod(String url) throws RippleException {
        PostMethod method = HTTPUtils.createPostMethod(url);
        HTTPUtils.setContentTypeHeader((HttpMethod)method, SPARQL_QUERY);
        return method;
    }

    public static void setContentTypeHeader(HttpMethod method, String value) throws RippleException {
        try {
            method.setRequestHeader(CONTENT_TYPE, value);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
    }

    public static void setAcceptHeader(HttpMethod method, String value) throws RippleException {
        try {
            method.setRequestHeader(ACCEPT, value);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
    }

    public static void setAcceptHeader(HttpMethod method, String[] mimeTypes) throws RippleException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(mimeTypes[i]);
        }
        HTTPUtils.setAcceptHeader(method, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long throttleHttpRequest(HttpMethod method) throws RippleException {
        String host;
        if (!initialized) {
            HTTPUtils.initialize();
        }
        try {
            host = method.getURI().getHost();
        }
        catch (URIException e) {
            throw new RippleException((Throwable)e);
        }
        if (null != host && host.length() > 0) {
            Date now = new Date();
            long delay = courtesyInterval;
            long w = 0L;
            Map<String, Date> map = LAST_REQUEST_BY_HOST;
            synchronized (map) {
                Date lastRequest = LAST_REQUEST_BY_HOST.get(host);
                if (null != lastRequest && now.getTime() - lastRequest.getTime() < delay) {
                    w = lastRequest.getTime() + delay - now.getTime();
                }
                LAST_REQUEST_BY_HOST.put(host, new Date(w + now.getTime()));
            }
            if (w > 0L) {
                try {
                    Thread.sleep(w);
                }
                catch (InterruptedException e) {
                    throw new RippleException((Throwable)e);
                }
            }
            return System.currentTimeMillis() - now.getTime();
        }
        return 0L;
    }

    private static void setAgent(HttpMethod method) {
        method.setRequestHeader(USER_AGENT, Ripple.getName() + "/" + Ripple.getVersion());
    }

    static {
        initialized = false;
    }
}

