/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.diff;

import net.fortytwo.flow.NullSink;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.diff.DiffSink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.flow.rdf.diff.RDFDiffSink;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailConnectionRDFDiffSink
implements RDFDiffSink {
    private final RDFSink addSink;
    private final RDFSink subtractSink;
    private final DiffSink<Statement> stSink;
    private final DiffSink<Namespace> nsSink;
    private final DiffSink<String> cmtSink;

    public SailConnectionRDFDiffSink(final SailConnection sailConnection) {
        Sink<Statement> addStatementSink = new Sink<Statement>(){

            public void put(Statement statement) throws RippleException {
                try {
                    sailConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                }
                catch (SailException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        Sink<Statement> subtractStatementSink = new Sink<Statement>(){

            public void put(Statement statement) throws RippleException {
                try {
                    sailConnection.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                }
                catch (SailException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        Sink<Namespace> addNamespaceSink = new Sink<Namespace>(){

            public void put(Namespace namespace) throws RippleException {
                try {
                    sailConnection.setNamespace(namespace.getPrefix(), namespace.getName());
                }
                catch (SailException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        Sink<Namespace> subtractNamespaceSink = new Sink<Namespace>(){

            public void put(Namespace namespace) throws RippleException {
                String name = null;
                try {
                    name = sailConnection.getNamespace(namespace.getPrefix());
                    if (null != name && name.equals(namespace.getName())) {
                        sailConnection.removeNamespace(namespace.getPrefix());
                    }
                }
                catch (SailException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        NullSink addCommentSink = new NullSink();
        NullSink subtractCommentSink = new NullSink();
        this.addSink = new RDFSink((Sink)addStatementSink, (Sink)addNamespaceSink, (Sink)addCommentSink){
            final /* synthetic */ Sink val$addStatementSink;
            final /* synthetic */ Sink val$addNamespaceSink;
            final /* synthetic */ Sink val$addCommentSink;
            {
                this.val$addStatementSink = sink;
                this.val$addNamespaceSink = sink2;
                this.val$addCommentSink = sink3;
            }

            @Override
            public Sink<Statement> statementSink() {
                return this.val$addStatementSink;
            }

            @Override
            public Sink<Namespace> namespaceSink() {
                return this.val$addNamespaceSink;
            }

            @Override
            public Sink<String> commentSink() {
                return this.val$addCommentSink;
            }
        };
        this.subtractSink = new RDFSink((Sink)subtractStatementSink, (Sink)subtractNamespaceSink, (Sink)subtractCommentSink){
            final /* synthetic */ Sink val$subtractStatementSink;
            final /* synthetic */ Sink val$subtractNamespaceSink;
            final /* synthetic */ Sink val$subtractCommentSink;
            {
                this.val$subtractStatementSink = sink;
                this.val$subtractNamespaceSink = sink2;
                this.val$subtractCommentSink = sink3;
            }

            @Override
            public Sink<Statement> statementSink() {
                return this.val$subtractStatementSink;
            }

            @Override
            public Sink<Namespace> namespaceSink() {
                return this.val$subtractNamespaceSink;
            }

            @Override
            public Sink<String> commentSink() {
                return this.val$subtractCommentSink;
            }
        };
        this.stSink = new DiffSink<Statement>((Sink)addStatementSink, (Sink)subtractStatementSink){
            final /* synthetic */ Sink val$addStatementSink;
            final /* synthetic */ Sink val$subtractStatementSink;
            {
                this.val$addStatementSink = sink;
                this.val$subtractStatementSink = sink2;
            }

            public Sink<Statement> getPlus() {
                return this.val$addStatementSink;
            }

            public Sink<Statement> getMinus() {
                return this.val$subtractStatementSink;
            }
        };
        this.nsSink = new DiffSink<Namespace>((Sink)addNamespaceSink, (Sink)subtractNamespaceSink){
            final /* synthetic */ Sink val$addNamespaceSink;
            final /* synthetic */ Sink val$subtractNamespaceSink;
            {
                this.val$addNamespaceSink = sink;
                this.val$subtractNamespaceSink = sink2;
            }

            public Sink<Namespace> getPlus() {
                return this.val$addNamespaceSink;
            }

            public Sink<Namespace> getMinus() {
                return this.val$subtractNamespaceSink;
            }
        };
        this.cmtSink = new DiffSink<String>((Sink)addCommentSink, (Sink)subtractCommentSink){
            final /* synthetic */ Sink val$addCommentSink;
            final /* synthetic */ Sink val$subtractCommentSink;
            {
                this.val$addCommentSink = sink;
                this.val$subtractCommentSink = sink2;
            }

            public Sink<String> getPlus() {
                return this.val$addCommentSink;
            }

            public Sink<String> getMinus() {
                return this.val$subtractCommentSink;
            }
        };
    }

    @Override
    public RDFSink adderSink() {
        return this.addSink;
    }

    @Override
    public RDFSink subtractorSink() {
        return this.subtractSink;
    }

    @Override
    public DiffSink<Statement> statementSink() {
        return this.stSink;
    }

    @Override
    public DiffSink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    @Override
    public DiffSink<String> commentSink() {
        return this.cmtSink;
    }
}

