/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.ranking;

import info.aduna.iteration.CloseableIteration;
import java.util.Random;
import net.fortytwo.flow.rdf.ranking.Handler;
import net.fortytwo.flow.rdf.ranking.HandlerException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class Ranking {
    public static final URI INDEX = new URIImpl("http://example.org/index");
    private static final boolean INCLUDE_INFERRED = false;
    private static final int TOTAL_RESOURCES = 408422;
    private static final Random RANDOM = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getStatements(SailConnection sc, Handler<Statement, HandlerException> handler, Resource subject, URI predicate, Value object) throws HandlerException {
        try {
            CloseableIteration iter = sc.getStatements(subject, predicate, object, false, new Resource[0]);
            try {
                while (iter.hasNext()) {
                    handler.handle((Statement)iter.next());
                }
            }
            finally {
                iter.close();
            }
        }
        catch (SailException e) {
            throw new HandlerException(e);
        }
        return true;
    }

    public static boolean traverseForward(SailConnection sc, final Handler<Value, HandlerException> handler, Resource subject, URI ... predicates) throws HandlerException {
        Handler<Statement, HandlerException> objectGrabber = new Handler<Statement, HandlerException>(){

            @Override
            public boolean handle(Statement st) throws HandlerException {
                return handler.handle(st.getObject());
            }
        };
        for (URI p : predicates) {
            if (Ranking.getStatements(sc, objectGrabber, subject, p, null)) continue;
            return false;
        }
        return true;
    }

    public static boolean traverseBackward(SailConnection sc, final Handler<Value, HandlerException> handler, Resource object, URI ... predicates) throws HandlerException {
        Handler<Statement, HandlerException> subjectGrabber = new Handler<Statement, HandlerException>(){

            @Override
            public boolean handle(Statement st) throws HandlerException {
                return handler.handle(st.getSubject());
            }
        };
        for (URI p : predicates) {
            if (Ranking.getStatements(sc, subjectGrabber, null, p, (Value)object)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource randomResource(SailConnection sc) throws HandlerException {
        Resource r;
        int i = RANDOM.nextInt(408422) + 1;
        try {
            CloseableIteration iter = sc.getStatements(null, INDEX, (Value)new LiteralImpl("" + i), false, new Resource[0]);
            try {
                r = ((Statement)iter.next()).getSubject();
            }
            finally {
                iter.close();
            }
        }
        catch (SailException e) {
            throw new HandlerException(e);
        }
        return r;
    }
}

