/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

public class Order
extends UnaryTupleOperator {
    private List<OrderElem> elements = new ArrayList<OrderElem>();

    public Order() {
    }

    public Order(TupleExpr arg) {
        super(arg);
    }

    public Order(TupleExpr arg, OrderElem ... elements) {
        this(arg);
        this.addElements(elements);
    }

    public Order(TupleExpr arg, Iterable<OrderElem> elements) {
        this(arg);
        this.addElements(elements);
    }

    public List<OrderElem> getElements() {
        return this.elements;
    }

    public void setElements(List<OrderElem> elements) {
        this.elements = elements;
    }

    public void addElements(OrderElem ... elements) {
        for (OrderElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<OrderElem> elements) {
        for (OrderElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(OrderElem pe) {
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (OrderElem elem : this.elements) {
            elem.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.elements, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Order && super.equals(other)) {
            Order o = (Order)other;
            return this.elements.equals(o.getElements());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.elements.hashCode();
    }

    @Override
    public Order clone() {
        Order clone = (Order)super.clone();
        clone.elements = new ArrayList<OrderElem>(this.getElements().size());
        for (OrderElem elem : this.getElements()) {
            clone.addElement(elem.clone());
        }
        return clone;
    }
}

