/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.FBUtilities;

public class UserOptions {
    private final Map<IAuthenticator.Option, Object> options = new HashMap<IAuthenticator.Option, Object>();

    public void put(String name, Object value) {
        this.options.put(IAuthenticator.Option.valueOf(name.toUpperCase()), value);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public Map<IAuthenticator.Option, Object> getOptions() {
        return this.options;
    }

    public void validate() throws InvalidRequestException {
        for (IAuthenticator.Option option : this.options.keySet()) {
            if (DatabaseDescriptor.getAuthenticator().supportedOptions().contains((Object)option)) continue;
            throw new InvalidRequestException(String.format("%s doesn't support %s option", new Object[]{DatabaseDescriptor.getAuthenticator().getClass().getName(), option}));
        }
    }

    public String toString() {
        return FBUtilities.toString(this.options);
    }
}

