/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class BatchWriterConfig
implements Writable {
    private static final Long DEFAULT_MAX_MEMORY = 0x3200000L;
    private Long maxMemory = null;
    private static final Long DEFAULT_MAX_LATENCY = 120000L;
    private Long maxLatency = null;
    private static final Long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private Long timeout = null;
    private static final Integer DEFAULT_MAX_WRITE_THREADS = 3;
    private Integer maxWriteThreads = null;

    public BatchWriterConfig setMaxMemory(long maxMemory) {
        if (maxMemory < 0L) {
            throw new IllegalArgumentException("Max memory must be non-negative.");
        }
        this.maxMemory = maxMemory;
        return this;
    }

    public BatchWriterConfig setMaxLatency(long maxLatency, TimeUnit timeUnit) {
        if (maxLatency < 0L) {
            throw new IllegalArgumentException("Negative max latency not allowed " + maxLatency);
        }
        this.maxLatency = maxLatency == 0L ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Math.max(1L, timeUnit.toMillis(maxLatency)));
        return this;
    }

    public BatchWriterConfig setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout not allowed " + timeout);
        }
        this.timeout = timeout == 0L ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Math.max(1L, timeUnit.toMillis(timeout)));
        return this;
    }

    public BatchWriterConfig setMaxWriteThreads(int maxWriteThreads) {
        if (maxWriteThreads <= 0) {
            throw new IllegalArgumentException("Max threads must be positive " + maxWriteThreads);
        }
        this.maxWriteThreads = maxWriteThreads;
        return this;
    }

    public long getMaxMemory() {
        return this.maxMemory != null ? this.maxMemory : DEFAULT_MAX_MEMORY;
    }

    public long getMaxLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxLatency != null ? this.maxLatency : DEFAULT_MAX_LATENCY, TimeUnit.MILLISECONDS);
    }

    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeout != null ? this.timeout : DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public int getMaxWriteThreads() {
        return this.maxWriteThreads != null ? this.maxWriteThreads : DEFAULT_MAX_WRITE_THREADS;
    }

    public void write(DataOutput out) throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        if (this.maxMemory != null) {
            this.addField(fields, "maxMemory", this.maxMemory);
        }
        if (this.maxLatency != null) {
            this.addField(fields, "maxLatency", this.maxLatency);
        }
        if (this.maxWriteThreads != null) {
            this.addField(fields, "maxWriteThreads", this.maxWriteThreads);
        }
        if (this.timeout != null) {
            this.addField(fields, "timeout", this.timeout);
        }
        String output = StringUtils.join((CharSequence)",", fields);
        byte[] bytes = output.getBytes(Constants.UTF8);
        byte[] len = String.format("%6s#", Integer.toString(bytes.length, 36)).getBytes(Constants.UTF8);
        if (len.length != 7) {
            throw new IllegalStateException("encoded length does not match expected value");
        }
        out.write(len);
        out.write(bytes);
    }

    private void addField(List<String> fields, String name, Object value) {
        String key = StringUtils.escapeString((String)name, (char)'\\', (char[])new char[]{',', '='});
        String val = StringUtils.escapeString((String)String.valueOf(value), (char)'\\', (char[])new char[]{',', '='});
        fields.add(key + '=' + val);
    }

    public void readFields(DataInput in) throws IOException {
        String[] fields;
        byte[] len = new byte[7];
        in.readFully(len);
        String strLen = new String(len, Constants.UTF8);
        if (!strLen.endsWith("#")) {
            throw new IllegalStateException("length was not encoded correctly");
        }
        byte[] bytes = new byte[Integer.parseInt(strLen.substring(strLen.lastIndexOf(32) + 1, strLen.length() - 1), 36)];
        in.readFully(bytes);
        String strFields = new String(bytes, Constants.UTF8);
        for (String field : fields = StringUtils.split((String)strFields, (char)'\\', (char)',')) {
            String[] keyValue = StringUtils.split((String)field, (char)'\\', (char)'=');
            String key = keyValue[0];
            String value = keyValue[1];
            if ("maxMemory".equals(key)) {
                this.maxMemory = Long.valueOf(value);
                continue;
            }
            if ("maxLatency".equals(key)) {
                this.maxLatency = Long.valueOf(value);
                continue;
            }
            if ("maxWriteThreads".equals(key)) {
                this.maxWriteThreads = Integer.valueOf(value);
                continue;
            }
            if (!"timeout".equals(key)) continue;
            this.timeout = Long.valueOf(value);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BatchWriterConfig) {
            BatchWriterConfig other = (BatchWriterConfig)o;
            if (null != this.maxMemory ? !this.maxMemory.equals(other.maxMemory) : null != other.maxMemory) {
                return false;
            }
            if (null != this.maxLatency ? !this.maxLatency.equals(other.maxLatency) : null != other.maxLatency) {
                return false;
            }
            if (null != this.maxWriteThreads ? !this.maxWriteThreads.equals(other.maxWriteThreads) : null != other.maxWriteThreads) {
                return false;
            }
            return !(null != this.timeout ? !this.timeout.equals(other.timeout) : null != other.timeout);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.maxMemory).append((Object)this.maxLatency).append((Object)this.maxWriteThreads).append((Object)this.timeout);
        return hcb.toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[maxMemory=").append(this.getMaxMemory()).append(", maxLatency=").append(this.getMaxLatency(TimeUnit.MILLISECONDS)).append(", maxWriteThreads=").append(this.getMaxWriteThreads()).append(", timeout=").append(this.getTimeout(TimeUnit.MILLISECONDS)).append("]");
        return sb.toString();
    }
}

