/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import jline.internal.Preconditions;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.hadoop.conf.Configuration;

public class CredentialProviderToken
extends PasswordToken {
    public static final String NAME_PROPERTY = "name";
    public static final String CREDENTIAL_PROVIDERS_PROPERTY = "credentialProviders";

    public CredentialProviderToken() {
    }

    public CredentialProviderToken(String name, String credentialProviders) throws IOException {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)credentialProviders);
        this.setWithCredentialProviders(name, credentialProviders);
    }

    protected void setWithCredentialProviders(String name, String credentialProviders) throws IOException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.credential.provider.path", credentialProviders);
        char[] password = CredentialProviderFactoryShim.getValueFromCredentialProvider(conf, name);
        if (null == password) {
            throw new IOException("No password could be extracted from CredentialProvider(s) with " + name);
        }
        this.setPassword(CharBuffer.wrap(password));
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
        char[] nameCharArray = properties.get(NAME_PROPERTY);
        char[] credentialProvidersCharArray = properties.get(CREDENTIAL_PROVIDERS_PROPERTY);
        if (null != nameCharArray && null != credentialProvidersCharArray) {
            try {
                this.setWithCredentialProviders(new String(nameCharArray), new String(credentialProvidersCharArray));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not extract password from CredentialProvider", e);
            }
            return;
        }
        throw new IllegalArgumentException("Expected name and credentialProviders properties.");
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        LinkedHashSet<AuthenticationToken.TokenProperty> properties = new LinkedHashSet<AuthenticationToken.TokenProperty>();
        properties.add(new AuthenticationToken.TokenProperty(NAME_PROPERTY, "Alias to extract from CredentialProvider", false));
        properties.add(new AuthenticationToken.TokenProperty(CREDENTIAL_PROVIDERS_PROPERTY, "Comma separated list of URLs defining CredentialProvider(s)", false));
        return properties;
    }

    @Override
    public CredentialProviderToken clone() {
        CredentialProviderToken clone = new CredentialProviderToken();
        clone.setPassword(this.getPassword());
        return clone;
    }
}

