/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.log4j.Logger;

class ConfigurationDocGen {
    private static Logger log = Logger.getLogger(ConfigurationDocGen.class);
    private PrintStream doc;
    private final ArrayList<Property> prefixes;
    private final TreeMap<String, Property> sortedProps;

    ConfigurationDocGen(PrintStream doc) {
        this.doc = doc;
        this.prefixes = new ArrayList();
        this.sortedProps = new TreeMap();
        for (Property prop : Property.values()) {
            if (prop.isExperimental()) continue;
            if (prop.getType() == PropertyType.PREFIX) {
                this.prefixes.add(prop);
                continue;
            }
            this.sortedProps.put(prop.getKey(), prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResource(String resourceName) {
        InputStream data = ConfigurationDocGen.class.getResourceAsStream(resourceName);
        if (data != null) {
            byte[] buffer = new byte[1024];
            try {
                int n;
                while ((n = data.read(buffer)) > 0) {
                    this.doc.print(new String(buffer, 0, n, Constants.UTF8));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    private String isZooKeeperMutable(Property prop) {
        if (!Property.isValidZooPropertyKey(prop.getKey())) {
            return "no";
        }
        if (Property.isFixedZooPropertyKey(prop)) {
            return "yes but requires restart of the " + prop.getKey().split("[.]")[0];
        }
        return "yes";
    }

    void generateHtml() {
        new HTML().generate();
    }

    void generateLaTeX() {
        new LaTeX().generate();
    }

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        if (args.length == 2 && args[0].equals("--generate-html")) {
            new ConfigurationDocGen(new PrintStream(args[1], Constants.UTF8.name())).generateHtml();
        } else if (args.length == 2 && args[0].equals("--generate-latex")) {
            new ConfigurationDocGen(new PrintStream(args[1], Constants.UTF8.name())).generateLaTeX();
        } else {
            throw new IllegalArgumentException("Usage: " + ConfigurationDocGen.class.getName() + " --generate-html <filename> | --generate-latex <filename>");
        }
    }

    private class LaTeX
    extends Format {
        private LaTeX() {
        }

        @Override
        void beginSection(String section) {
            ConfigurationDocGen.this.doc.println("\\section{" + section + "}");
        }

        @Override
        String getExt() {
            return "tex";
        }

        @Override
        void prefixSection(Property prefix) {
            boolean depr = prefix.isDeprecated();
            ConfigurationDocGen.this.doc.println("\\subsection{" + prefix.getKey() + "*}" + (depr ? " (Deprecated)" : ""));
            ConfigurationDocGen.this.doc.println((depr ? "\\sout{\\textit{Deprecated.} " : "") + this.sanitize(prefix.getDescription()) + (depr ? "}" : ""));
            ConfigurationDocGen.this.doc.println();
        }

        @Override
        void property(Property prefix, Property prop) {
            boolean depr;
            boolean bl = depr = prefix.isDeprecated() || prop.isDeprecated();
            if (prop.getKey().startsWith(prefix.getKey())) {
                ConfigurationDocGen.this.doc.println("\\subsubsection{" + prop.getKey() + "}");
                ConfigurationDocGen.this.doc.println(this.strike((depr ? "\\textit{Deprecated.} " : "") + this.sanitize(prop.getDescription()), depr));
                ConfigurationDocGen.this.doc.println();
                ConfigurationDocGen.this.doc.println(this.strike("\\textit{Type:} " + prop.getType().name() + "\\\\", depr));
                ConfigurationDocGen.this.doc.println(this.strike("\\textit{ZooKeeper Mutable:} " + ConfigurationDocGen.this.isZooKeeperMutable(prop) + "\\\\", depr));
                ConfigurationDocGen.this.doc.println(this.strike("\\textit{Default Value:} " + this.sanitize(prop.getRawDefaultValue()), depr));
                ConfigurationDocGen.this.doc.println();
            }
        }

        private String strike(String s, boolean isDeprecated) {
            return (isDeprecated ? "\\sout{" : "") + s + (isDeprecated ? "}" : "");
        }

        @Override
        void propertyTypeDescriptions() {
            for (PropertyType type : PropertyType.values()) {
                if (type == PropertyType.PREFIX) continue;
                ConfigurationDocGen.this.doc.println("\\subsection{" + this.sanitize(type.toString()) + "}");
                ConfigurationDocGen.this.doc.println(this.sanitize(type.getFormatDescription()));
                ConfigurationDocGen.this.doc.println();
            }
        }

        @Override
        String sanitize(String str) {
            str = str.replace("\\", "\\textbackslash{}");
            str = str.replace("~", "\\textasciitilde{}");
            str = str.replace("^", "\\textasciicircum");
            str = str.replace("&", "\\&");
            str = str.replace("%", "\\%");
            str = str.replace("$", "\\$");
            str = str.replace("#", "\\#");
            str = str.replace("_", "\\_");
            str = str.replace("{", "\\{");
            str = str.replace("}", "\\}");
            str = str.replaceAll("(?:\r\n|\r|\n)", "\\\\\\\\\n");
            return str;
        }
    }

    private class HTML
    extends Format {
        private boolean highlight;

        private HTML() {
        }

        private void beginRow() {
            ConfigurationDocGen.this.doc.println(this.startTag("tr", this.highlight ? "class='highlight'" : null));
            this.highlight = !this.highlight;
        }

        @Override
        void beginSection(String section) {
            ConfigurationDocGen.this.doc.println(this.t("h1", section, null));
            this.highlight = true;
            ConfigurationDocGen.this.doc.println("<table>");
        }

        private String t(String tag, String cell, String options) {
            return this.startTag(tag, options) + cell + "</" + tag + ">";
        }

        private void cellData(String cell, String options) {
            ConfigurationDocGen.this.doc.println(this.t("td", cell, options));
        }

        private void columnNames(String ... names) {
            this.beginRow();
            for (String s : names) {
                ConfigurationDocGen.this.doc.println(this.t("th", s, null));
            }
            this.endRow();
        }

        private void endRow() {
            ConfigurationDocGen.this.doc.println("</tr>");
        }

        @Override
        void endSection() {
            ConfigurationDocGen.this.doc.println("</table>");
        }

        @Override
        String getExt() {
            return "html";
        }

        @Override
        void pageFooter() {
            ConfigurationDocGen.this.doc.println("</body>");
            ConfigurationDocGen.this.doc.println("</html>");
        }

        @Override
        void pageHeader() {
            super.pageHeader();
            ConfigurationDocGen.this.doc.println("<p>Jump to: ");
            String delimiter = "";
            for (Property prefix : ConfigurationDocGen.this.prefixes) {
                if (prefix.isExperimental()) continue;
                ConfigurationDocGen.this.doc.print(delimiter + "<a href='#" + prefix.name() + "'>" + prefix.getKey() + "*</a>");
                delimiter = "&nbsp;|&nbsp;";
            }
            ConfigurationDocGen.this.doc.println("</p>");
        }

        @Override
        void prefixSection(Property prefix) {
            this.beginRow();
            ConfigurationDocGen.this.doc.println(this.t("td", this.t("span", prefix.getKey() + '*', "id='" + prefix.name() + "' class='large'"), "colspan='5'" + (prefix.isDeprecated() ? " class='deprecated'" : "")));
            this.endRow();
            this.beginRow();
            ConfigurationDocGen.this.doc.println(this.t("td", (prefix.isDeprecated() ? this.t("b", this.t("i", "Deprecated. ", null), null) : "") + this.sanitize(prefix.getDescription()), "colspan='5'" + (prefix.isDeprecated() ? " class='deprecated'" : "")));
            this.endRow();
            switch (prefix) {
                case TABLE_CONSTRAINT_PREFIX: {
                    break;
                }
                case TABLE_ITERATOR_PREFIX: {
                    break;
                }
                case TABLE_LOCALITY_GROUP_PREFIX: {
                    break;
                }
                case TABLE_COMPACTION_STRATEGY_PREFIX: {
                    break;
                }
                default: {
                    this.columnNames("Property", "Type", "ZooKeeper Mutable", "Default Value", "Description");
                }
            }
        }

        @Override
        void property(Property prefix, Property prop) {
            boolean isDeprecated;
            boolean bl = isDeprecated = prefix.isDeprecated() || prop.isDeprecated();
            if (prop.getKey().startsWith(prefix.getKey())) {
                this.beginRow();
                this.cellData(prop.getKey(), isDeprecated ? "class='deprecated'" : null);
                this.cellData("<b><a href='#" + prop.getType().name() + "'>" + prop.getType().toString().replaceAll(" ", "&nbsp;") + "</a></b>", isDeprecated ? "class='deprecated'" : null);
                this.cellData(ConfigurationDocGen.this.isZooKeeperMutable(prop), isDeprecated ? "class='deprecated'" : null);
                this.cellData("<pre>" + (prop.getRawDefaultValue().isEmpty() ? "&nbsp;" : this.sanitize(prop.getRawDefaultValue().replaceAll(" ", "&nbsp;"))) + "</pre>", isDeprecated ? "class='deprecated'" : null);
                this.cellData((isDeprecated ? "<b><i>Deprecated.</i></b> " : "") + this.sanitize(prop.getDescription()), isDeprecated ? "class='deprecated'" : null);
                this.endRow();
            }
        }

        @Override
        void propertyTypeDescriptions() {
            this.columnNames("Property Type", "Description");
            for (PropertyType type : PropertyType.values()) {
                if (type == PropertyType.PREFIX) continue;
                this.beginRow();
                this.cellData("<h3 id='" + type.name() + "'>" + (Object)((Object)type) + "</h3>", null);
                this.cellData(type.getFormatDescription(), null);
                this.endRow();
            }
        }

        @Override
        String sanitize(String str) {
            return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replaceAll("(?:\r\n|\r|\n)", "<br />");
        }

        private String startTag(String tag, String options) {
            return "<" + tag + (options != null ? " " + options : "") + ">";
        }
    }

    private abstract class Format {
        private Format() {
        }

        abstract void beginSection(String var1);

        void endSection() {
        }

        void generate() {
            this.pageHeader();
            this.beginSection("Available Properties");
            for (Property prefix : ConfigurationDocGen.this.prefixes) {
                if (prefix.isExperimental()) continue;
                this.prefixSection(prefix);
                for (Property prop : ConfigurationDocGen.this.sortedProps.values()) {
                    if (prop.isExperimental()) continue;
                    this.property(prefix, prop);
                }
            }
            this.endSection();
            this.beginSection("Property Types");
            this.propertyTypeDescriptions();
            this.endSection();
            this.pageFooter();
            ConfigurationDocGen.this.doc.close();
        }

        abstract String getExt();

        void pageFooter() {
        }

        void pageHeader() {
            ConfigurationDocGen.this.appendResource("config-header." + this.getExt());
            ConfigurationDocGen.this.doc.println();
        }

        abstract void prefixSection(Property var1);

        abstract void property(Property var1, Property var2);

        abstract void propertyTypeDescriptions();

        abstract String sanitize(String var1);
    }
}

