/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.DefaultKeySizeConstraint;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.SynchronizedIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.tabletserver.thrift.IteratorConfig;
import org.apache.accumulo.core.tabletserver.thrift.TIteratorSetting;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class IteratorUtil {
    private static final Logger log = Logger.getLogger(IteratorUtil.class);

    public static Map<String, String> generateInitialTableProperties(boolean limitVersion) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        if (limitVersion) {
            for (IteratorScope iterScope : IteratorScope.values()) {
                props.put((Object)((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers", "20," + VersioningIterator.class.getName());
                props.put((Object)((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers.opt.maxVersions", "1");
            }
        }
        props.put(Property.TABLE_CONSTRAINT_PREFIX.toString() + "1", DefaultKeySizeConstraint.class.getName());
        return props;
    }

    public static int getMaxPriority(IteratorScope scope, AccumuloConfiguration conf) {
        ArrayList<IterInfo> iters = new ArrayList<IterInfo>();
        IteratorUtil.parseIterConf(scope, iters, new HashMap<String, Map<String, String>>(), conf);
        int max = 0;
        for (IterInfo iterInfo : iters) {
            if (iterInfo.priority <= max) continue;
            max = iterInfo.priority;
        }
        return max;
    }

    protected static void parseIterConf(IteratorScope scope, List<IterInfo> iters, Map<String, Map<String, String>> allOptions, AccumuloConfiguration conf) {
        Property scopeProperty = IteratorScope.getProperty(scope);
        String scopePropertyKey = scopeProperty.getKey();
        for (Map.Entry<String, String> entry : conf.getAllPropertiesWithPrefix(scopeProperty).entrySet()) {
            String suffix = entry.getKey().substring(scopePropertyKey.length());
            String[] suffixSplit = suffix.split("\\.", 3);
            if (suffixSplit.length == 1) {
                String[] sa = entry.getValue().split(",");
                int prio = Integer.parseInt(sa[0]);
                String className = sa[1];
                iters.add(new IterInfo(prio, className, suffixSplit[0]));
                continue;
            }
            if (suffixSplit.length == 3 && suffixSplit[1].equals("opt")) {
                String iterName = suffixSplit[0];
                String optName = suffixSplit[2];
                Map<String, String> options = allOptions.get(iterName);
                if (options == null) {
                    options = new HashMap<String, String>();
                    allOptions.put(iterName, options);
                }
                options.put(optName, entry.getValue());
                continue;
            }
            log.warn((Object)("Unrecognizable option: " + entry.getKey()));
        }
        Collections.sort(iters, new IterInfoComparator());
    }

    public static String findIterator(IteratorScope scope, String className, AccumuloConfiguration conf, Map<String, String> opts) {
        ArrayList<IterInfo> iters = new ArrayList<IterInfo>();
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        IteratorUtil.parseIterConf(scope, iters, allOptions, conf);
        for (IterInfo iterInfo : iters) {
            if (!iterInfo.className.equals(className)) continue;
            Map tmpOpts = (Map)allOptions.get(iterInfo.iterName);
            if (tmpOpts != null) {
                opts.putAll(tmpOpts);
            }
            return iterInfo.iterName;
        }
        return null;
    }

    public static <K extends WritableComparable<?>, V extends Writable> SortedKeyValueIterator<K, V> loadIterators(IteratorScope scope, SortedKeyValueIterator<K, V> source, KeyExtent extent, AccumuloConfiguration conf, IteratorEnvironment env) throws IOException {
        List<IterInfo> emptyList = Collections.emptyList();
        Map<String, Map<String, String>> emptyMap = Collections.emptyMap();
        return IteratorUtil.loadIterators(scope, source, extent, conf, emptyList, emptyMap, env);
    }

    public static <K extends WritableComparable<?>, V extends Writable> SortedKeyValueIterator<K, V> loadIterators(IteratorScope scope, SortedKeyValueIterator<K, V> source, KeyExtent extent, AccumuloConfiguration conf, List<IteratorSetting> iterators, IteratorEnvironment env) throws IOException {
        ArrayList<IterInfo> ssiList = new ArrayList<IterInfo>();
        HashMap<String, Map<String, String>> ssio = new HashMap<String, Map<String, String>>();
        for (IteratorSetting is : iterators) {
            ssiList.add(new IterInfo(is.getPriority(), is.getIteratorClass(), is.getName()));
            ssio.put(is.getName(), is.getOptions());
        }
        return IteratorUtil.loadIterators(scope, source, extent, conf, ssiList, ssio, env, true);
    }

    public static <K extends WritableComparable<?>, V extends Writable> SortedKeyValueIterator<K, V> loadIterators(IteratorScope scope, SortedKeyValueIterator<K, V> source, KeyExtent extent, AccumuloConfiguration conf, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, IteratorEnvironment env) throws IOException {
        return IteratorUtil.loadIterators(scope, source, extent, conf, ssiList, ssio, env, true);
    }

    public static <K extends WritableComparable<?>, V extends Writable> SortedKeyValueIterator<K, V> loadIterators(IteratorScope scope, SortedKeyValueIterator<K, V> source, KeyExtent extent, AccumuloConfiguration conf, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, IteratorEnvironment env, boolean useAccumuloClassLoader) throws IOException {
        ArrayList<IterInfo> iters = new ArrayList<IterInfo>(ssiList);
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        IteratorUtil.parseIterConf(scope, iters, allOptions, conf);
        for (Map.Entry<String, Map<String, String>> entry : ssio.entrySet()) {
            if (entry.getValue() == null) continue;
            Map options = (Map)allOptions.get(entry.getKey());
            if (options == null) {
                allOptions.put(entry.getKey(), entry.getValue());
                continue;
            }
            options.putAll(entry.getValue());
        }
        return IteratorUtil.loadIterators(source, iters, allOptions, env, useAccumuloClassLoader, conf.get(Property.TABLE_CLASSPATH));
    }

    public static <K extends WritableComparable<?>, V extends Writable> SortedKeyValueIterator<K, V> loadIterators(SortedKeyValueIterator<K, V> source, Collection<IterInfo> iters, Map<String, Map<String, String>> iterOpts, IteratorEnvironment env, boolean useAccumuloClassLoader, String context) throws IOException {
        SortedKeyValueIterator<K, V> prev = new SynchronizedIterator<K, V>(source);
        try {
            for (IterInfo iterInfo : iters) {
                Class clazz = useAccumuloClassLoader ? (context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().loadClass(context, iterInfo.className, SortedKeyValueIterator.class) : AccumuloVFSClassLoader.loadClass((String)iterInfo.className, SortedKeyValueIterator.class)) : Class.forName(iterInfo.className).asSubclass(SortedKeyValueIterator.class);
                SortedKeyValueIterator skvi = (SortedKeyValueIterator)clazz.newInstance();
                Map<String, String> options = iterOpts.get(iterInfo.iterName);
                if (options == null) {
                    options = Collections.emptyMap();
                }
                skvi.init(prev, options, env);
                prev = skvi;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.toString());
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.toString());
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.toString());
            throw new IOException(e);
        }
        return prev;
    }

    public static Range maximizeStartKeyTimeStamp(Range range) {
        Range seekRange = range;
        if (range.getStartKey() != null && range.getStartKey().getTimestamp() != Long.MAX_VALUE) {
            Key seekKey = new Key(seekRange.getStartKey());
            seekKey.setTimestamp(Long.MAX_VALUE);
            seekRange = new Range(seekKey, true, range.getEndKey(), range.isEndKeyInclusive());
        }
        return seekRange;
    }

    public static Range minimizeEndKeyTimeStamp(Range range) {
        Range seekRange = range;
        if (range.getEndKey() != null && range.getEndKey().getTimestamp() != Long.MIN_VALUE) {
            Key seekKey = new Key(seekRange.getEndKey());
            seekKey.setTimestamp(Long.MIN_VALUE);
            seekRange = new Range(range.getStartKey(), range.isStartKeyInclusive(), seekKey, true);
        }
        return seekRange;
    }

    public static TIteratorSetting toTIteratorSetting(IteratorSetting is) {
        return new TIteratorSetting(is.getPriority(), is.getName(), is.getIteratorClass(), is.getOptions());
    }

    public static IteratorSetting toIteratorSetting(TIteratorSetting tis) {
        return new IteratorSetting(tis.getPriority(), tis.getName(), tis.getIteratorClass(), tis.getProperties());
    }

    public static IteratorConfig toIteratorConfig(List<IteratorSetting> iterators) {
        ArrayList<TIteratorSetting> tisList = new ArrayList<TIteratorSetting>();
        for (IteratorSetting iteratorSetting : iterators) {
            tisList.add(IteratorUtil.toTIteratorSetting(iteratorSetting));
        }
        return new IteratorConfig(tisList);
    }

    public static List<IteratorSetting> toIteratorSettings(IteratorConfig ic) {
        ArrayList<IteratorSetting> ret = new ArrayList<IteratorSetting>();
        for (TIteratorSetting tIteratorSetting : ic.getIterators()) {
            ret.add(IteratorUtil.toIteratorSetting(tIteratorSetting));
        }
        return ret;
    }

    public static byte[] encodeIteratorSettings(IteratorConfig iterators) {
        TSerializer tser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return tser.serialize((TBase)iterators);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeIteratorSettings(List<IteratorSetting> iterators) {
        return IteratorUtil.encodeIteratorSettings(IteratorUtil.toIteratorConfig(iterators));
    }

    public static List<IteratorSetting> decodeIteratorSettings(byte[] enc) {
        TDeserializer tdser = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        IteratorConfig ic = new IteratorConfig();
        try {
            tdser.deserialize((TBase)ic, enc);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return IteratorUtil.toIteratorSettings(ic);
    }

    public static class IterInfoComparator
    implements Comparator<IterInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IterInfo o1, IterInfo o2) {
            return o1.priority < o2.priority ? -1 : (o1.priority == o2.priority ? 0 : 1);
        }
    }

    public static enum IteratorScope {
        majc,
        minc,
        scan;


        public static Property getProperty(IteratorScope scope) {
            Preconditions.checkNotNull((Object)((Object)scope));
            switch (scope) {
                case scan: {
                    return Property.TABLE_ITERATOR_SCAN_PREFIX;
                }
                case minc: {
                    return Property.TABLE_ITERATOR_MINC_PREFIX;
                }
                case majc: {
                    return Property.TABLE_ITERATOR_MAJC_PREFIX;
                }
            }
            throw new IllegalStateException("Could not find configuration property for IteratorScope");
        }
    }
}

