/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.conf;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iterators.conf.ColumnUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;

public class ColumnSet {
    private Set<ColumnUtil.ColFamHashKey> objectsCF;
    private Set<ColumnUtil.ColHashKey> objectsCol;
    private ColumnUtil.ColHashKey lookupCol = new ColumnUtil.ColHashKey();
    private ColumnUtil.ColFamHashKey lookupCF = new ColumnUtil.ColFamHashKey();

    public ColumnSet() {
        this.objectsCF = new HashSet<ColumnUtil.ColFamHashKey>();
        this.objectsCol = new HashSet<ColumnUtil.ColHashKey>();
    }

    public ColumnSet(Collection<String> objectStrings) {
        this();
        for (String column : objectStrings) {
            Pair<Text, Text> pcic = ColumnSet.decodeColumns(column);
            if (pcic.getSecond() == null) {
                this.add(pcic.getFirst());
                continue;
            }
            this.add(pcic.getFirst(), pcic.getSecond());
        }
    }

    protected void add(Text colf) {
        this.objectsCF.add(new ColumnUtil.ColFamHashKey(new Text(colf)));
    }

    protected void add(Text colf, Text colq) {
        this.objectsCol.add(new ColumnUtil.ColHashKey(colf, colq));
    }

    public boolean contains(Key key) {
        if (this.objectsCol.size() > 0) {
            this.lookupCol.set(key);
            if (this.objectsCol.contains(this.lookupCol)) {
                return true;
            }
        }
        if (this.objectsCF.size() > 0) {
            this.lookupCF.set(key);
            return this.objectsCF.contains(this.lookupCF);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.objectsCol.size() == 0 && this.objectsCF.size() == 0;
    }

    public static String encodeColumns(Text columnFamily, Text columnQualifier) {
        StringBuilder sb = new StringBuilder();
        ColumnSet.encode(sb, columnFamily);
        if (columnQualifier != null) {
            sb.append(':');
            ColumnSet.encode(sb, columnQualifier);
        }
        return sb.toString();
    }

    static void encode(StringBuilder sb, Text t) {
        for (int i = 0; i < t.getLength(); ++i) {
            int b = 0xFF & t.getBytes()[i];
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 95 || b == 45) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            sb.append(String.format("%02x", b));
        }
    }

    public static boolean isValidEncoding(String enc) {
        for (char c : enc.toCharArray()) {
            boolean validChar;
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == ':' || c == '%';
            if (validChar) continue;
            return false;
        }
        return true;
    }

    public static Pair<Text, Text> decodeColumns(String columns) {
        if (!ColumnSet.isValidEncoding(columns)) {
            throw new IllegalArgumentException("Invalid encoding " + columns);
        }
        String[] cols = columns.split(":");
        if (cols.length == 1) {
            return new Pair<Text, Object>(ColumnSet.decode(cols[0]), null);
        }
        if (cols.length == 2) {
            return new Pair<Text, Text>(ColumnSet.decode(cols[0]), ColumnSet.decode(cols[1]));
        }
        throw new IllegalArgumentException(columns);
    }

    static Text decode(String s) {
        Text t = new Text();
        byte[] sb = s.getBytes(Constants.UTF8);
        for (int i = 0; i < sb.length; ++i) {
            if (sb[i] != 37) {
                t.append(new byte[]{sb[i]}, 0, 1);
                continue;
            }
            byte[] hex = new byte[]{sb[++i], sb[++i]};
            String hs = new String(hex, Constants.UTF8);
            int b = Integer.parseInt(hs, 16);
            t.append(new byte[]{(byte)b}, 0, 1);
        }
        return t;
    }
}

