/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;

public abstract class RowEncodingIterator
implements SortedKeyValueIterator<Key, Value> {
    protected SortedKeyValueIterator<Key, Value> sourceIter;
    private Key topKey = null;
    private Value topValue = null;
    List<Key> keys = new ArrayList<Key>();
    List<Value> values = new ArrayList<Value>();

    public abstract SortedMap<Key, Value> rowDecoder(Key var1, Value var2) throws IOException;

    public abstract Value rowEncoder(List<Key> var1, List<Value> var2) throws IOException;

    @Override
    public abstract SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment var1);

    private void prepKeys() throws IOException {
        Text currentRow;
        if (this.topKey != null) {
            return;
        }
        do {
            if (!this.sourceIter.hasTop()) {
                return;
            }
            currentRow = new Text(this.sourceIter.getTopKey().getRow());
            this.keys.clear();
            this.values.clear();
            while (this.sourceIter.hasTop() && this.sourceIter.getTopKey().getRow().equals((Object)currentRow)) {
                this.keys.add(new Key(this.sourceIter.getTopKey()));
                this.values.add(new Value(this.sourceIter.getTopValue()));
                this.sourceIter.next();
            }
        } while (!this.filter(currentRow, this.keys, this.values));
        this.topKey = new Key(currentRow);
        this.topValue = this.rowEncoder(this.keys, this.values);
    }

    protected boolean filter(Text currentRow, List<Key> keys, List<Value> values) {
        return true;
    }

    @Override
    public Key getTopKey() {
        return this.topKey;
    }

    @Override
    public Value getTopValue() {
        return this.topValue;
    }

    @Override
    public boolean hasTop() {
        return this.topKey != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.sourceIter = source;
    }

    @Override
    public void next() throws IOException {
        this.topKey = null;
        this.topValue = null;
        this.prepKeys();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.topKey = null;
        this.topValue = null;
        Key sk = range.getStartKey();
        if (sk != null && sk.getColumnFamilyData().length() == 0 && sk.getColumnQualifierData().length() == 0 && sk.getColumnVisibilityData().length() == 0 && sk.getTimestamp() == Long.MAX_VALUE && !range.isStartKeyInclusive()) {
            Key followingRowKey = sk.followingKey(PartialKey.ROW);
            if (range.getEndKey() != null && followingRowKey.compareTo(range.getEndKey()) > 0) {
                return;
            }
            range = new Range(sk.followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
        }
        this.sourceIter.seek(range, columnFamilies, inclusive);
        this.prepKeys();
    }
}

