/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CreateUserCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException, IOException {
        String user = cl.getArgs()[0];
        String password = shellState.readMaskedLine("Enter new password for '" + user + "': ", Character.valueOf('*'));
        if (password == null) {
            shellState.getReader().println();
            return 0;
        }
        String passwordConfirm = shellState.readMaskedLine("Please confirm new password for '" + user + "': ", Character.valueOf('*'));
        if (passwordConfirm == null) {
            shellState.getReader().println();
            return 0;
        }
        if (!password.equals(passwordConfirm)) {
            throw new IllegalArgumentException("Passwords do not match");
        }
        shellState.getConnector().securityOperations().createLocalUser(user, new PasswordToken(password));
        Shell.log.debug((Object)("Created user " + user));
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <username>";
    }

    @Override
    public String description() {
        return "creates a new user";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

