/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class GetAuthsCommand
extends Shell.Command {
    private Option userOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getConnector().whoami());
        Authorizations auths = shellState.getConnector().securityOperations().getUserAuthorizations(user);
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (byte[] auth : auths) {
            set.add(new String(auth));
        }
        shellState.getReader().println((CharSequence)StringUtils.join(set, (char)','));
        return 0;
    }

    @Override
    public String description() {
        return "displays the maximum scan authorizations for a user";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

