/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.blueprints;

import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Vertex;
import org.vertexium.blueprints.VertexiumBlueprintsEdge;
import org.vertexium.blueprints.VertexiumBlueprintsGraph;
import org.vertexium.blueprints.VertexiumBlueprintsVertex;
import org.vertexium.util.ConvertingIterable;

public class VertexiumBlueprintsConvert {
    public static Vertex toVertexium(com.tinkerpop.blueprints.Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        if (vertex instanceof VertexiumBlueprintsVertex) {
            return ((VertexiumBlueprintsVertex)vertex).getVertexiumElement();
        }
        throw new IllegalArgumentException("Invalid vertex, cannot get Vertexium vertex. " + vertex.getClass().getName());
    }

    public static Edge toVertexium(com.tinkerpop.blueprints.Edge edge) {
        if (edge == null) {
            return null;
        }
        if (edge instanceof VertexiumBlueprintsEdge) {
            return ((VertexiumBlueprintsEdge)edge).getVertexiumElement();
        }
        throw new IllegalArgumentException("Invalid edge, cannot get Vertexium edge. " + edge.getClass().getName());
    }

    public static Direction toVertexium(com.tinkerpop.blueprints.Direction direction) {
        switch (direction) {
            case OUT: {
                return Direction.OUT;
            }
            case IN: {
                return Direction.IN;
            }
            case BOTH: {
                return Direction.BOTH;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + direction);
    }

    public static String idToString(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof String) {
            return (String)id;
        }
        return id.toString();
    }

    public static Iterable<com.tinkerpop.blueprints.Vertex> toBlueprintsVertices(final VertexiumBlueprintsGraph graph, Iterable<Vertex> vertices, final Authorizations authorizations) {
        return new ConvertingIterable<Vertex, com.tinkerpop.blueprints.Vertex>(vertices){

            protected com.tinkerpop.blueprints.Vertex convert(Vertex vertex) {
                return VertexiumBlueprintsVertex.create(graph, vertex, authorizations);
            }
        };
    }

    public static Iterable<com.tinkerpop.blueprints.Edge> toBlueprintsEdges(final VertexiumBlueprintsGraph graph, Iterable<Edge> edges, final Authorizations authorizations) {
        return new ConvertingIterable<Edge, com.tinkerpop.blueprints.Edge>(edges){

            protected com.tinkerpop.blueprints.Edge convert(Edge edge) {
                return VertexiumBlueprintsEdge.create(graph, edge, authorizations);
            }
        };
    }
}

