/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.blueprints;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.blueprints.VertexiumBlueprintsGraph;

public abstract class VertexiumBlueprintsElement
implements com.tinkerpop.blueprints.Element {
    private static final String DEFAULT_PROPERTY_ID = "";
    private final Element element;
    private final Authorizations authorizations;
    private final VertexiumBlueprintsGraph graph;

    protected VertexiumBlueprintsElement(VertexiumBlueprintsGraph graph, Element element, Authorizations authorizations) {
        this.graph = graph;
        this.element = element;
        this.authorizations = authorizations;
    }

    public <T> T getProperty(String key) {
        Iterator values = this.getVertexiumElement().getPropertyValues(key).iterator();
        if (values.hasNext()) {
            return values.next();
        }
        return null;
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> propertyKeys = new HashSet<String>();
        for (Property property : this.getVertexiumElement().getProperties()) {
            propertyKeys.add(property.getName());
        }
        return propertyKeys;
    }

    public void setProperty(String propertyName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Property Name cannot be null.");
        }
        if ("id".equals(propertyName)) {
            throw new IllegalArgumentException("Property Name cannot be \"id\"");
        }
        if (DEFAULT_PROPERTY_ID.equals(propertyName)) {
            throw new IllegalArgumentException("Property Name cannot be empty.");
        }
        Visibility visibility = this.getGraph().getVisibilityProvider().getVisibilityForProperty(propertyName, value);
        this.getVertexiumElement().setProperty(propertyName, value, visibility, this.authorizations);
    }

    public <T> T removeProperty(String key) {
        T old = this.getProperty(key);
        this.getVertexiumElement().deleteProperty(DEFAULT_PROPERTY_ID, key, this.authorizations);
        return old;
    }

    public abstract void remove();

    public Object getId() {
        return this.getVertexiumElement().getId();
    }

    public VertexiumBlueprintsGraph getGraph() {
        return this.graph;
    }

    public Element getVertexiumElement() {
        return this.element;
    }

    public int hashCode() {
        return this.getVertexiumElement().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VertexiumBlueprintsElement) {
            return this.getVertexiumElement().equals(((VertexiumBlueprintsElement)obj).getVertexiumElement());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getVertexiumElement().toString();
    }
}

