/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CLevel;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class CassandraTransactionTest {
    @Test
    public void testWriteConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.customOptions((Configuration)mc);
            b.timestampProvider((TimestampProvider)Timestamps.MICRO);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getWriteConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testReadConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.timestampProvider((TimestampProvider)Timestamps.MICRO);
            b.customOptions((Configuration)mc);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getReadConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testTimestampProvider() {
        StandardBaseTransactionConfig txcfg = StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.NANO);
        CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)Timestamps.NANO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.MICRO);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)Timestamps.MICRO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.MILLI);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)Timestamps.MILLI, (Object)ct.getConfiguration().getTimestampProvider());
    }
}

