/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.thinkaurelius.titan.CassandraStorageSetup;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphTest;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class CassandraGraphTest
extends TitanGraphTest {
    @BeforeClass
    public static void startCassandra() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    protected boolean isLockingOptimistic() {
        return true;
    }

    @Test
    public void testHasTTL() throws Exception {
        Assert.assertTrue((boolean)this.features.hasCellTTL());
    }

    @Test
    public void testGraphConfigUsedByThreadBoundTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"LOCAL_QUORUM");
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        StandardTitanTx tx = (StandardTitanTx)this.graph.getCurrentThreadTx();
        Assert.assertEquals((Object)"ALL", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"LOCAL_QUORUM", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
    }

    @Test
    public void testGraphConfigUsedByTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"TWO");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"THREE");
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        StandardTitanTx tx = (StandardTitanTx)this.graph.newTransaction();
        Assert.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"THREE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }

    @Test
    public void testCustomConfigUsedByTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        StandardTitanTx tx = (StandardTitanTx)this.graph.buildTransaction().setCustomOption(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ONE").setCustomOption(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"TWO").start();
        Assert.assertEquals((Object)"ONE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }
}

