/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.mapreduce;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.accumulo.AccumuloVertex;
import org.vertexium.accumulo.ElementMutationBuilder;
import org.vertexium.accumulo.mapreduce.ElementMapperGraph;
import org.vertexium.id.IdGenerator;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.util.IncreasingTime;

public abstract class ElementMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    public static final String GRAPH_CONFIG_PREFIX = "graphConfigPrefix";
    private ElementMutationBuilder elementMutationBuilder;
    private ElementMapperGraph graph;
    private NameSubstitutionStrategy nameSubstitutionStrategy;

    protected void setup(final Mapper.Context context) throws IOException, InterruptedException {
        FileSystem fileSystem;
        super.setup(context);
        String configPrefix = context.getConfiguration().get(GRAPH_CONFIG_PREFIX, "");
        AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration(context.getConfiguration(), configPrefix);
        String tableNamePrefix = accumuloGraphConfiguration.getTableNamePrefix();
        final Text edgesTableName = new Text(AccumuloGraph.getEdgesTableName(tableNamePrefix));
        final Text dataTableName = new Text(AccumuloGraph.getDataTableName(tableNamePrefix));
        final Text verticesTableName = new Text(AccumuloGraph.getVerticesTableName(tableNamePrefix));
        long maxStreamingPropertyValueTableDataSize = accumuloGraphConfiguration.getMaxStreamingPropertyValueTableDataSize();
        String dataDir = accumuloGraphConfiguration.getDataDir();
        try {
            fileSystem = accumuloGraphConfiguration.createFileSystem();
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not initialize", e);
        }
        this.graph = new ElementMapperGraph(this);
        VertexiumSerializer vertexiumSerializer = accumuloGraphConfiguration.createSerializer((Graph)this.graph);
        this.nameSubstitutionStrategy = accumuloGraphConfiguration.createSubstitutionStrategy((Graph)this.graph);
        this.elementMutationBuilder = new ElementMutationBuilder(fileSystem, vertexiumSerializer, maxStreamingPropertyValueTableDataSize, dataDir){

            @Override
            protected void saveVertexMutation(Mutation m) {
                try {
                    ElementMapper.this.saveVertexMutation(context, verticesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save vertex", e);
                }
            }

            @Override
            protected void saveEdgeMutation(Mutation m) {
                try {
                    ElementMapper.this.saveEdgeMutation(context, edgesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save edge", e);
                }
            }

            @Override
            protected NameSubstitutionStrategy getNameSubstitutionStrategy() {
                return ElementMapper.this.nameSubstitutionStrategy;
            }

            @Override
            protected void saveDataMutation(Mutation m) {
                try {
                    ElementMapper.this.saveDataMutation(context, dataTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save data", e);
                }
            }
        };
    }

    protected abstract void saveDataMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    protected abstract void saveEdgeMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    protected abstract void saveVertexMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    public VertexBuilder prepareVertex(Vertex vertex) {
        return this.prepareVertex(vertex.getId(), null, vertex.getVisibility());
    }

    public VertexBuilder prepareVertex(String vertexId, Visibility visibility) {
        return this.prepareVertex(vertexId, null, visibility);
    }

    public VertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new VertexBuilder(vertexId, visibility){

            public Vertex save(Authorizations authorizations) {
                AccumuloGraph graph = null;
                Iterable<Visibility> hiddenVisibilities = null;
                AccumuloVertex vertex = new AccumuloVertex(graph, this.getVertexId(), this.getVisibility(), (Iterable<Property>)this.getProperties(), (Iterable<PropertyDeleteMutation>)this.getPropertyDeletes(), (Iterable<PropertySoftDeleteMutation>)this.getPropertySoftDeletes(), hiddenVisibilities, timestampLong, authorizations);
                ElementMapper.this.elementMutationBuilder.saveVertex(vertex);
                return vertex;
            }
        };
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility).save(authorizations);
    }

    public EdgeBuilderByVertexId prepareEdge(Edge edge) {
        return this.prepareEdge(edge.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel(), (Long)edge.getTimestamp(), edge.getVisibility());
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, null, visibility);
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge edge = new AccumuloEdge(null, this.getEdgeId(), this.getOutVertexId(), this.getInVertexId(), this.getLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), null, timestampLong, authorizations);
                ElementMapper.this.elementMutationBuilder.saveEdge(edge);
                return edge;
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility);
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge edge = new AccumuloEdge(null, this.getEdgeId(), this.getOutVertex().getId(), this.getInVertex().getId(), this.getLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), null, timestampLong, authorizations);
                ElementMapper.this.elementMutationBuilder.saveEdge(edge);
                return edge;
            }
        };
    }

    public IdGenerator getIdGenerator() {
        throw new VertexiumException("not implemented");
    }

    public Graph getGraph() {
        return this.graph;
    }
}

