/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch.score;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionBuilder;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.Vertex;
import org.vertexium.elasticsearch.ElasticsearchSingleDocumentSearchIndex;
import org.vertexium.elasticsearch.IndexInfo;
import org.vertexium.elasticsearch.score.EdgeCountScoringStrategyConfiguration;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.elasticsearch.utils.GetResponseUtil;
import org.vertexium.search.SearchIndex;

public class EdgeCountScoringStrategy
extends ScoringStrategy {
    private final EdgeCountScoringStrategyConfiguration config;

    public EdgeCountScoringStrategy(GraphConfiguration config) {
        super(config);
        this.config = new EdgeCountScoringStrategyConfiguration(config);
    }

    public EdgeCountScoringStrategyConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void addElement(SearchIndex searchIndex, Graph graph, Element element, Authorizations authorizations) {
        Vertex vIn;
        if (!this.getConfig().isUpdateEdgeBoost()) {
            return;
        }
        if (!(element instanceof Edge)) {
            return;
        }
        Vertex vOut = ((Edge)element).getVertex(Direction.OUT, authorizations);
        if (vOut != null) {
            searchIndex.addElement(graph, (Element)vOut, authorizations);
        }
        if ((vIn = ((Edge)element).getVertex(Direction.IN, authorizations)) != null) {
            searchIndex.addElement(graph, (Element)vIn, authorizations);
        }
    }

    @Override
    public int addElement(ElasticsearchSingleDocumentSearchIndex searchIndex, Graph graph, BulkRequest bulkRequest, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        Vertex vIn;
        int totalCount = 0;
        if (!this.getConfig().isUpdateEdgeBoost()) {
            return totalCount;
        }
        if (!(element instanceof Edge)) {
            return totalCount;
        }
        Vertex vOut = ((Edge)element).getVertex(Direction.OUT, authorizations);
        if (vOut != null) {
            searchIndex.addElementToBulkRequest(graph, bulkRequest, indexInfo, (Element)vOut, authorizations);
            ++totalCount;
        }
        if ((vIn = ((Edge)element).getVertex(Direction.IN, authorizations)) != null) {
            searchIndex.addElementToBulkRequest(graph, bulkRequest, indexInfo, (Element)vIn, authorizations);
            ++totalCount;
        }
        return totalCount;
    }

    @Override
    public void addFieldsToElementType(XContentBuilder builder) throws IOException {
        builder.startObject("__inEdgeCount").field("type", "integer").field("store", "true").endObject().startObject("__outEdgeCount").field("type", "integer").field("store", "true").endObject();
    }

    @Override
    public List<String> getFieldNames() {
        List<String> fieldNames = super.getFieldNames();
        fieldNames.add("__inEdgeCount");
        fieldNames.add("__outEdgeCount");
        return fieldNames;
    }

    @Override
    public QueryBuilder updateQuery(QueryBuilder query) {
        if (!this.getConfig().isUseEdgeBoost()) {
            return query;
        }
        ScriptScoreFunctionBuilder scoreFunction = ScoreFunctionBuilders.scriptFunction((String)this.getConfig().getScoreFormula(), (String)"groovy").param("inEdgeMultiplier", (Object)this.getConfig().getInEdgeBoost()).param("outEdgeMultiplier", (Object)this.getConfig().getOutEdgeBoost());
        return QueryBuilders.functionScoreQuery((QueryBuilder)query, (ScoreFunctionBuilder)scoreFunction);
    }

    @Override
    public boolean addFieldsToVertexDocument(SearchIndex searchIndex, XContentBuilder jsonBuilder, Vertex vertex, GetResponse existingDocument, Authorizations authorizations) throws IOException {
        Long existingOutEdgeCount;
        Long existingInEdgeCount;
        if (existingDocument != null && !this.getConfig().isUpdateEdgeBoost()) {
            return false;
        }
        boolean changed = false;
        int inEdgeCount = vertex.getEdgeCount(Direction.IN, authorizations);
        Long l = existingInEdgeCount = existingDocument == null ? null : GetResponseUtil.getFieldValueLong(existingDocument, "__inEdgeCount");
        if (existingInEdgeCount == null || existingInEdgeCount.intValue() != inEdgeCount) {
            jsonBuilder.field("__inEdgeCount", inEdgeCount);
            changed = true;
        } else {
            jsonBuilder.field("__inEdgeCount", existingInEdgeCount.intValue());
        }
        int outEdgeCount = vertex.getEdgeCount(Direction.OUT, authorizations);
        Long l2 = existingOutEdgeCount = existingDocument == null ? null : GetResponseUtil.getFieldValueLong(existingDocument, "__outEdgeCount");
        if (existingOutEdgeCount == null || existingOutEdgeCount.intValue() != outEdgeCount) {
            jsonBuilder.field("__outEdgeCount", outEdgeCount);
            changed = true;
        } else {
            jsonBuilder.field("__outEdgeCount", existingOutEdgeCount.intValue());
        }
        return changed;
    }

    @Override
    public boolean addFieldsToEdgeDocument(SearchIndex searchIndex, XContentBuilder jsonBuilder, Edge edge, GetResponse existingDocument, Authorizations authorizations) throws IOException {
        return false;
    }
}

