/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.script;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.script.ScriptRecordReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class ScriptInputFormat
extends FileInputFormat<NullWritable, FaunusVertex>
implements Configurable {
    private VertexQueryFilter vertexQuery;
    private Configuration config;

    public RecordReader<NullWritable, FaunusVertex> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new ScriptRecordReader(this.vertexQuery, context);
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return null == new CompressionCodecFactory(HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration(context)).getCodec(file);
    }

    public void setConf(Configuration config) {
        this.config = config;
        this.vertexQuery = VertexQueryFilter.create(config);
    }

    public Configuration getConf() {
        return this.config;
    }
}

