/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util.input.current;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.graphdb.database.RelationReader;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.schema.SchemaContainer;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.input.SystemTypeInspector;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetupCommon;
import com.thinkaurelius.titan.hadoop.formats.util.input.VertexReader;
import com.tinkerpop.blueprints.Direction;
import org.apache.hadoop.conf.Configuration;

public class TitanHadoopSetupImpl
extends TitanHadoopSetupCommon {
    private final StandardTitanGraph graph;
    private final StandardTitanTx tx;

    public TitanHadoopSetupImpl(Configuration config) {
        ModifiableConfiguration bc = ModifiableHadoopConfiguration.of(config).getInputConf();
        this.graph = (StandardTitanGraph)TitanFactory.open((BasicConfiguration)bc);
        FaunusSchemaManager.getTypeManager(null).setSchemaProvider((SchemaProvider)new SchemaContainer((TitanGraph)this.graph));
        this.tx = (StandardTitanTx)this.graph.buildTransaction().readOnly().setVertexCacheSize(200).start();
    }

    @Override
    public TypeInspector getTypeInspector() {
        for (TitanSchemaCategory sc : TitanSchemaCategory.values()) {
            for (TitanVertex k : this.tx.getVertices((PropertyKey)BaseKey.SchemaCategory, (Object)sc)) {
                assert (k instanceof TitanSchemaVertex);
                TitanSchemaVertex s = (TitanSchemaVertex)k;
                if (sc.hasName()) {
                    String name = s.getName();
                    Preconditions.checkNotNull((Object)name);
                }
                TypeDefinitionMap dm = s.getDefinition();
                Preconditions.checkNotNull((Object)dm);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.IN);
            }
        }
        return this.tx;
    }

    @Override
    public SystemTypeInspector getSystemTypeInspector() {
        return new SystemTypeInspector(){

            @Override
            public boolean isSystemType(long typeid) {
                return IDManager.isSystemRelationTypeId((long)typeid);
            }

            @Override
            public boolean isVertexExistsSystemType(long typeid) {
                return typeid == BaseKey.VertexExists.getLongId();
            }

            @Override
            public boolean isVertexLabelSystemType(long typeid) {
                return typeid == BaseLabel.VertexLabelEdge.getLongId();
            }

            @Override
            public boolean isTypeSystemType(long typeid) {
                return typeid == BaseKey.SchemaCategory.getLongId() || typeid == BaseKey.SchemaDefinitionProperty.getLongId() || typeid == BaseKey.SchemaDefinitionDesc.getLongId() || typeid == BaseKey.SchemaName.getLongId() || typeid == BaseLabel.SchemaDefinitionEdge.getLongId();
            }
        };
    }

    @Override
    public VertexReader getVertexReader() {
        return new VertexReader(){

            @Override
            public long getVertexId(StaticBuffer key) {
                return TitanHadoopSetupImpl.this.graph.getIDManager().getKeyID(key);
            }
        };
    }

    @Override
    public RelationReader getRelationReader(long vertexid) {
        return this.graph.getEdgeSerializer();
    }

    @Override
    public void close() {
        this.tx.rollback();
        this.graph.shutdown();
    }
}

