/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.mapreduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mrunit.internal.io.Serialization;
import org.apache.hadoop.mrunit.types.KeyValueReuseList;
import org.apache.hadoop.mrunit.types.Pair;

public class ReduceFeeder<K, V> {
    private final Serialization serialization;
    private final Configuration conf;

    public ReduceFeeder(Configuration conf) {
        this.conf = conf;
        this.serialization = new Serialization(conf);
    }

    public List<KeyValueReuseList<K, V>> sortAndGroup(List<Pair<K, V>> mapOutputs, final Comparator<K> keyValueOrderComparator, Comparator<K> keyGroupComparator) {
        if (mapOutputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (keyValueOrderComparator != null) {
            Collections.sort(mapOutputs, new Comparator<Pair<K, V>>(){

                @Override
                public int compare(Pair<K, V> o1, Pair<K, V> o2) {
                    return keyValueOrderComparator.compare(o1.getFirst(), o2.getFirst());
                }
            });
        } else {
            Collections.sort(mapOutputs);
        }
        ArrayList<KeyValueReuseList<K, V>> groupedInputs = new ArrayList<KeyValueReuseList<K, V>>();
        Object currentKey = null;
        KeyValueReuseList<K, V> currentEntries = null;
        for (Pair<K, V> p : mapOutputs) {
            if (currentKey == null || keyGroupComparator != null && keyGroupComparator.compare(currentKey, p.getFirst()) != 0 || keyGroupComparator == null && ((Comparable)currentKey).compareTo(p.getFirst()) != 0) {
                currentKey = p.getFirst();
                currentEntries = new KeyValueReuseList<K, V>(this.serialization.copy(p.getFirst()), this.serialization.copy(p.getSecond()), this.conf);
                groupedInputs.add(currentEntries);
            }
            currentEntries.add(p);
        }
        return groupedInputs;
    }

    public List<KeyValueReuseList<K, V>> sortAndGroup(List<Pair<K, V>> mapOutputs, Comparator<K> keyOrderAndGroupComparator) {
        return this.sortAndGroup(mapOutputs, keyOrderAndGroupComparator, keyOrderAndGroupComparator);
    }

    public List<KeyValueReuseList<K, V>> sortAndGroup(List<Pair<K, V>> mapOutputs) {
        return this.sortAndGroup(mapOutputs, null, null);
    }

    public List<KeyValueReuseList<K, V>> updateAll(List<Pair<K, List<V>>> inputs) {
        ArrayList<KeyValueReuseList<K, V>> transformedInputs = new ArrayList<KeyValueReuseList<K, V>>();
        for (Pair<K, List<V>> keyValues : inputs) {
            if (keyValues.getSecond().isEmpty()) continue;
            transformedInputs.add(this.updateInput(keyValues));
        }
        return transformedInputs;
    }

    public KeyValueReuseList<K, V> updateInput(Pair<K, List<V>> input) {
        return this.updateInput(input.getFirst(), input.getSecond());
    }

    public KeyValueReuseList<K, V> updateInput(K key, List<V> values) {
        if (values.isEmpty()) {
            return new KeyValueReuseList<K, Object>(this.serialization.copy(key), null, this.conf);
        }
        KeyValueReuseList<K, V> entry = new KeyValueReuseList<K, V>(this.serialization.copy(key), this.serialization.copy(values.get(0)), this.conf);
        for (V value : values) {
            entry.add(new Pair<K, V>(this.serialization.copy(key), this.serialization.copy(value)));
        }
        return entry;
    }
}

