/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.util.Addressing;

public class HRegionLocation
implements Comparable<HRegionLocation> {
    private final HRegionInfo regionInfo;
    private final String hostname;
    private final int port;
    private String cachedString = null;
    private String cachedHostnamePort;

    public HRegionLocation(HRegionInfo regionInfo, String hostname, int port) {
        this.regionInfo = regionInfo;
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized String toString() {
        if (this.cachedString == null) {
            this.cachedString = "region=" + this.regionInfo.getRegionNameAsString() + ", hostname=" + this.hostname + ", port=" + this.port;
        }
        return this.cachedString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionLocation)) {
            return false;
        }
        return this.compareTo((HRegionLocation)o) == 0;
    }

    public int hashCode() {
        int result = this.hostname.hashCode();
        return result ^= this.port;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public HServerAddress getServerAddress() {
        return new HServerAddress(this.hostname, this.port);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized String getHostnamePort() {
        if (this.cachedHostnamePort == null) {
            this.cachedHostnamePort = Addressing.createHostAndPortStr(this.hostname, this.port);
        }
        return this.cachedHostnamePort;
    }

    @Override
    public int compareTo(HRegionLocation o) {
        int result = this.hostname.compareTo(o.getHostname());
        if (result != 0) {
            return result;
        }
        return this.port - o.getPort();
    }
}

