/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class CompoundConfiguration
extends Configuration {
    protected List<ImmutableConfigMap> configs = new ArrayList<ImmutableConfigMap>();

    public CompoundConfiguration add(final Configuration conf) {
        if (conf instanceof CompoundConfiguration) {
            this.configs.addAll(0, ((CompoundConfiguration)conf).configs);
            return this;
        }
        this.configs.add(0, new ImmutableConfigMap(){
            Configuration c;
            {
                this.c = conf;
            }

            @Override
            public String get(String key) {
                return this.c.get(key);
            }

            @Override
            public String getRaw(String key) {
                return this.c.getRaw(key);
            }

            @Override
            public Class<?> getClassByName(String name) throws ClassNotFoundException {
                return this.c.getClassByName(name);
            }

            @Override
            public int size() {
                return this.c.size();
            }

            public String toString() {
                return this.c.toString();
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return this.c.iterator();
            }
        });
        return this;
    }

    public CompoundConfiguration add(final Map<ImmutableBytesWritable, ImmutableBytesWritable> map) {
        this.configs.add(0, new ImmutableConfigMap(){
            Map<ImmutableBytesWritable, ImmutableBytesWritable> m;
            {
                this.m = map;
            }

            @Override
            public String get(String key) {
                ImmutableBytesWritable ibw = new ImmutableBytesWritable(Bytes.toBytes(key));
                if (!this.m.containsKey(ibw)) {
                    return null;
                }
                ImmutableBytesWritable value = this.m.get(ibw);
                if (value == null || value.get() == null) {
                    return null;
                }
                return Bytes.toString(value.get());
            }

            @Override
            public String getRaw(String key) {
                return this.get(key);
            }

            @Override
            public Class<?> getClassByName(String name) throws ClassNotFoundException {
                return null;
            }

            @Override
            public int size() {
                return this.m.size();
            }

            public String toString() {
                return this.m.toString();
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator<Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable>> entries = this.m.entrySet().iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry e = (Map.Entry)entries.next();
                        return new Map.Entry<String, String>(){

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException("Cannot set value on entry from a CompoundConfiguration!");
                            }

                            @Override
                            public String getValue() {
                                ImmutableBytesWritable bytes = (ImmutableBytesWritable)e.getValue();
                                if (bytes != null) {
                                    return Bytes.toString(bytes.get(), bytes.getOffset(), bytes.getLength());
                                }
                                return null;
                            }

                            @Override
                            public String getKey() {
                                ImmutableBytesWritable bytes = (ImmutableBytesWritable)e.getKey();
                                return Bytes.toString(bytes.get(), bytes.getOffset(), bytes.getLength());
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove an entry from a CompoundConfiguration iterator");
                    }
                };
            }
        });
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CompoundConfiguration: " + this.configs.size() + " configs");
        for (ImmutableConfigMap m : this.configs) {
            sb.append(this.configs);
        }
        return sb.toString();
    }

    public String get(String key) {
        for (ImmutableConfigMap m : this.configs) {
            String value = m.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getRaw(String key) {
        for (ImmutableConfigMap m : this.configs) {
            String value = m.getRaw(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        for (ImmutableConfigMap m : this.configs) {
            try {
                Class<?> value = m.getClassByName(name);
                if (value == null) continue;
                return value;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException();
    }

    public int size() {
        int ret = 0;
        for (ImmutableConfigMap m : this.configs) {
            ret += m.size();
        }
        return ret;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap ret = new HashMap();
        if (!this.configs.isEmpty()) {
            for (int i = this.configs.size() - 1; i >= 0; --i) {
                ImmutableConfigMap map = this.configs.get(i);
                for (Map.Entry entry : map) {
                    ret.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return UnmodifiableIterator.decorate(ret.entrySet().iterator());
    }

    public String get(String name, String defaultValue) {
        String ret = this.get(name);
        return ret == null ? defaultValue : ret;
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public Configuration.IntegerRanges getRange(String name, String defaultValue) {
        return new Configuration.IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection((String)valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings((String)valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings((String)valueString);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void set(String name, String value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setIfUnset(String name, String value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setInt(String name, int value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setLong(String name, long value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setFloat(String name, float value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setBoolean(String name, boolean value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setBooleanIfUnset(String name, boolean value) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setStrings(String name, String ... values) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void writeXml(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    private static interface ImmutableConfigMap
    extends Iterable<Map.Entry<String, String>> {
        public String get(String var1);

        public String getRaw(String var1);

        public Class<?> getClassByName(String var1) throws ClassNotFoundException;

        public int size();
    }
}

