/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.ClosableIterator;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.Entry;
import org.cache2k.impl.Hash;

public class ClosableConcurrentHashEntryIterator<E extends Entry>
implements ClosableIterator<E> {
    int iteratedCountLastRun;
    Entry lastEntry = null;
    Hash<E> hashCtl;
    Hash<E> hashCtl2;
    Entry[] hash;
    Entry[] hash2;
    Hash<E> hashCtlCopy;
    Hash<E> hashCtl2Copy;
    Entry[] hashCopy;
    Entry[] hash2Copy;
    Hash<Entry> iteratedCtl = new Hash();
    Entry[] iterated;
    boolean keepIterated = false;
    boolean stopOnClear = true;

    public ClosableConcurrentHashEntryIterator(Hash<E> _hashCtl, E[] _hash, Hash<E> _hashCtl2, E[] _hash2) {
        this.hash = _hash;
        this.hashCopy = _hash;
        this.hash2 = _hash2;
        this.hash2Copy = _hash2;
        this.hashCtl = _hashCtl;
        this.hashCtlCopy = this.hashCtl;
        this.hashCtl2 = _hashCtl2;
        this.hashCtl2Copy = this.hashCtl2;
        _hashCtl.incrementSuppressExpandCount();
        this.iterated = this.iteratedCtl.init(Entry.class);
    }

    private Entry nextEntry() {
        Entry e;
        if (this.hash == null) {
            return null;
        }
        if (this.hashCtl.shouldAbort()) {
            if (this.checkForClearAndAbort()) {
                return null;
            }
            if (this.stopOnClear && this.hashCtl.isCleared()) {
                throw new CacheClosedException();
            }
        }
        int idx = 0;
        if (this.lastEntry != null) {
            e = this.lastEntry.another;
            if (e != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            idx = Hash.index(this.hash, this.lastEntry.hashCode) + 1;
        }
        while (true) {
            if (idx >= this.hash.length) {
                if (this.switchAndCheckAbort()) {
                    return null;
                }
                idx = 0;
            }
            if ((e = this.hash[idx]) != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            ++idx;
        }
    }

    protected E checkIteratedOrNext(E e) {
        do {
            boolean _notYetIterated;
            boolean bl = _notYetIterated = !Hash.contains(this.iterated, ((Entry)e).key, ((Entry)e).hashCode);
            if (!_notYetIterated) continue;
            Entry _newEntryIterated = new Entry();
            _newEntryIterated.key = ((Entry)e).key;
            _newEntryIterated.hashCode = ((Entry)e).hashCode;
            this.iterated = this.iteratedCtl.insert(this.iterated, _newEntryIterated);
            return e;
        } while ((e = ((Entry)e).another) != null);
        return null;
    }

    protected boolean switchAndCheckAbort() {
        this.hashCtl.decrementSuppressExpandCount();
        this.hash = this.hash2;
        this.hashCtl = this.hashCtl2;
        this.hash2 = null;
        this.hashCtl2 = null;
        if (this.hash == null) {
            this.lastEntry = null;
            if (this.iteratedCountLastRun == this.iteratedCtl.size) {
                this.close();
                return true;
            }
            this.iteratedCountLastRun = this.iteratedCtl.size;
            this.hash = this.hashCopy;
            this.hash2 = this.hash2Copy;
            this.hashCtl = this.hashCtlCopy;
            this.hashCtl2 = this.hashCtl2Copy;
        }
        this.hashCtl.incrementSuppressExpandCount();
        return false;
    }

    protected boolean checkForClearAndAbort() {
        if (this.hashCtl.isCleared()) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.nextEntry() != null;
    }

    public E next() {
        return (E)this.lastEntry;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.hashCtl != null) {
            this.hashCtl.decrementSuppressExpandCount();
            this.hashCtl2 = null;
            this.hashCtl = null;
            this.hash2 = null;
            this.hash = null;
            this.hashCtl2Copy = null;
            this.hashCtlCopy = null;
            this.hash2Copy = null;
            this.hashCopy = null;
            this.lastEntry = null;
            if (!this.keepIterated) {
                this.iterated = null;
                this.iteratedCtl = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void setKeepIterated(boolean keepIterated) {
        this.keepIterated = keepIterated;
    }

    public void setStopOnClear(boolean stopOnClear) {
        this.stopOnClear = stopOnClear;
    }
}

