/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.Visibility;
import org.vertexium.elasticsearch.PropertyNameVisibilitiesStore;

public class MetadataTablePropertyNameVisibilitiesStore
extends PropertyNameVisibilitiesStore {
    public static final String METADATA_PREFIX = "propertyNameVisibility.";
    private static final Charset UTF8 = Charset.forName("utf8");
    private Map<String, Visibility> visibilityCache = new HashMap<String, Visibility>();

    @Override
    public Collection<String> getHashes(Graph graph, String propertyName, Authorizations authorizations) {
        ArrayList<String> results = new ArrayList<String>();
        String prefix = this.getMetadataPrefixWithPropertyName(propertyName);
        for (GraphMetadataEntry metadata : graph.getMetadataWithPrefix(prefix)) {
            String visibilityString = metadata.getKey().substring(prefix.length());
            Visibility visibility = this.getVisibility(visibilityString);
            if (!authorizations.canRead(visibility)) continue;
            String hash = (String)metadata.getValue();
            results.add(hash);
        }
        return results;
    }

    private Visibility getVisibility(String visibilityString) {
        Visibility visibility = this.visibilityCache.get(visibilityString);
        if (visibility == null) {
            visibility = new Visibility(visibilityString);
            this.visibilityCache.put(visibilityString, visibility);
        }
        return visibility;
    }

    @Override
    public String getHash(Graph graph, String propertyName, Visibility visibility) {
        String visibilityString = visibility.getVisibilityString();
        String metadataKey = this.getMetadataKey(propertyName, visibilityString);
        String hash = (String)graph.getMetadata(metadataKey);
        if (hash != null) {
            return hash;
        }
        hash = Hashing.murmur3_128().hashString((CharSequence)visibilityString, UTF8).toString();
        graph.setMetadata(metadataKey, (Object)hash);
        return hash;
    }

    private String getMetadataPrefixWithPropertyName(String propertyName) {
        return METADATA_PREFIX + propertyName + ".";
    }

    private String getMetadataKey(String propertyName, String visibilityString) {
        return this.getMetadataPrefixWithPropertyName(propertyName) + visibilityString;
    }
}

