/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Credentials;
import org.apache.hadoop.io.Text;

public class TimeoutTabletLocator
extends TabletLocator {
    private TabletLocator locator;
    private long timeout;
    private Long firstFailTime = null;

    private void failed() {
        if (this.firstFailTime == null) {
            this.firstFailTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.firstFailTime > this.timeout) {
            throw new TimedOutException("Failed to obtain metadata");
        }
    }

    private void succeeded() {
        this.firstFailTime = null;
    }

    public TimeoutTabletLocator(TabletLocator locator, long timeout) {
        this.locator = locator;
        this.timeout = timeout;
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(Credentials credentials, Text row, boolean skipRow, boolean retry) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            TabletLocator.TabletLocation ret = this.locator.locateTablet(credentials, row, skipRow, retry);
            if (ret == null) {
                this.failed();
            } else {
                this.succeeded();
            }
            return ret;
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }

    @Override
    public <T extends Mutation> void binMutations(Credentials credentials, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            this.locator.binMutations(credentials, mutations, binnedMutations, failures);
            if (failures.size() == mutations.size()) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }

    @Override
    public List<Range> binRanges(Credentials credentials, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            List<Range> ret = this.locator.binRanges(credentials, ranges, binnedRanges);
            if (ranges.size() == ret.size()) {
                this.failed();
            } else {
                this.succeeded();
            }
            return ret;
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
        this.locator.invalidateCache(failedExtent);
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
        this.locator.invalidateCache(keySet);
    }

    @Override
    public void invalidateCache() {
        this.locator.invalidateCache();
    }

    @Override
    public void invalidateCache(String server) {
        this.locator.invalidateCache(server);
    }
}

