/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TConstraintViolationSummary;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.format.BinaryFormatter;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterFactory;
import org.apache.accumulo.core.util.shell.ShellCompletor;
import org.apache.accumulo.core.util.shell.ShellOptions;
import org.apache.accumulo.core.util.shell.ShellOptionsJC;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.accumulo.core.util.shell.commands.AboutCommand;
import org.apache.accumulo.core.util.shell.commands.AddAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.AddSplitsCommand;
import org.apache.accumulo.core.util.shell.commands.AuthenticateCommand;
import org.apache.accumulo.core.util.shell.commands.ByeCommand;
import org.apache.accumulo.core.util.shell.commands.ClasspathCommand;
import org.apache.accumulo.core.util.shell.commands.ClearCommand;
import org.apache.accumulo.core.util.shell.commands.CloneTableCommand;
import org.apache.accumulo.core.util.shell.commands.ClsCommand;
import org.apache.accumulo.core.util.shell.commands.CompactCommand;
import org.apache.accumulo.core.util.shell.commands.ConfigCommand;
import org.apache.accumulo.core.util.shell.commands.ConstraintCommand;
import org.apache.accumulo.core.util.shell.commands.CreateNamespaceCommand;
import org.apache.accumulo.core.util.shell.commands.CreateTableCommand;
import org.apache.accumulo.core.util.shell.commands.CreateUserCommand;
import org.apache.accumulo.core.util.shell.commands.DUCommand;
import org.apache.accumulo.core.util.shell.commands.DebugCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteManyCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteNamespaceCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteRowsCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteScanIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteTableCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteUserCommand;
import org.apache.accumulo.core.util.shell.commands.DropTableCommand;
import org.apache.accumulo.core.util.shell.commands.DropUserCommand;
import org.apache.accumulo.core.util.shell.commands.EGrepCommand;
import org.apache.accumulo.core.util.shell.commands.ExecfileCommand;
import org.apache.accumulo.core.util.shell.commands.ExitCommand;
import org.apache.accumulo.core.util.shell.commands.ExportTableCommand;
import org.apache.accumulo.core.util.shell.commands.ExtensionCommand;
import org.apache.accumulo.core.util.shell.commands.FateCommand;
import org.apache.accumulo.core.util.shell.commands.FlushCommand;
import org.apache.accumulo.core.util.shell.commands.FormatterCommand;
import org.apache.accumulo.core.util.shell.commands.GetAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.GetGroupsCommand;
import org.apache.accumulo.core.util.shell.commands.GetSplitsCommand;
import org.apache.accumulo.core.util.shell.commands.GrantCommand;
import org.apache.accumulo.core.util.shell.commands.GrepCommand;
import org.apache.accumulo.core.util.shell.commands.HelpCommand;
import org.apache.accumulo.core.util.shell.commands.HiddenCommand;
import org.apache.accumulo.core.util.shell.commands.HistoryCommand;
import org.apache.accumulo.core.util.shell.commands.ImportDirectoryCommand;
import org.apache.accumulo.core.util.shell.commands.ImportTableCommand;
import org.apache.accumulo.core.util.shell.commands.InfoCommand;
import org.apache.accumulo.core.util.shell.commands.InsertCommand;
import org.apache.accumulo.core.util.shell.commands.InterpreterCommand;
import org.apache.accumulo.core.util.shell.commands.ListCompactionsCommand;
import org.apache.accumulo.core.util.shell.commands.ListIterCommand;
import org.apache.accumulo.core.util.shell.commands.ListScansCommand;
import org.apache.accumulo.core.util.shell.commands.ListShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.MaxRowCommand;
import org.apache.accumulo.core.util.shell.commands.MergeCommand;
import org.apache.accumulo.core.util.shell.commands.NamespacePermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.NamespacesCommand;
import org.apache.accumulo.core.util.shell.commands.NoTableCommand;
import org.apache.accumulo.core.util.shell.commands.OfflineCommand;
import org.apache.accumulo.core.util.shell.commands.OnlineCommand;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.core.util.shell.commands.PasswdCommand;
import org.apache.accumulo.core.util.shell.commands.PingCommand;
import org.apache.accumulo.core.util.shell.commands.QuestionCommand;
import org.apache.accumulo.core.util.shell.commands.QuitCommand;
import org.apache.accumulo.core.util.shell.commands.QuotedStringTokenizer;
import org.apache.accumulo.core.util.shell.commands.RenameNamespaceCommand;
import org.apache.accumulo.core.util.shell.commands.RenameTableCommand;
import org.apache.accumulo.core.util.shell.commands.RevokeCommand;
import org.apache.accumulo.core.util.shell.commands.ScanCommand;
import org.apache.accumulo.core.util.shell.commands.ScriptCommand;
import org.apache.accumulo.core.util.shell.commands.SetAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.SetGroupsCommand;
import org.apache.accumulo.core.util.shell.commands.SetIterCommand;
import org.apache.accumulo.core.util.shell.commands.SetScanIterCommand;
import org.apache.accumulo.core.util.shell.commands.SetShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.SleepCommand;
import org.apache.accumulo.core.util.shell.commands.SystemPermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.TableCommand;
import org.apache.accumulo.core.util.shell.commands.TablePermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.TablesCommand;
import org.apache.accumulo.core.util.shell.commands.TraceCommand;
import org.apache.accumulo.core.util.shell.commands.UserCommand;
import org.apache.accumulo.core.util.shell.commands.UserPermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.UsersCommand;
import org.apache.accumulo.core.util.shell.commands.WhoAmICommand;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Shell
extends ShellOptions {
    public static final Logger log = Logger.getLogger(Shell.class);
    private static final Logger audit = Logger.getLogger((String)(Shell.class.getName() + ".audit"));
    public static final String CHARSET = "ISO-8859-1";
    public static final int NO_FIXED_ARG_LENGTH_CHECK = -1;
    public static final String COMMENT_PREFIX = "#";
    public static final String HISTORY_DIR_NAME = ".accumulo";
    public static final String HISTORY_FILE_NAME = "shell_history.txt";
    private static final String SHELL_DESCRIPTION = "Shell - Apache Accumulo Interactive Shell";
    protected int exitCode = 0;
    private String tableName;
    protected Instance instance;
    private Connector connector;
    protected ConsoleReader reader;
    private String principal;
    private AuthenticationToken token;
    private final Class<? extends Formatter> defaultFormatterClass = DefaultFormatter.class;
    private final Class<? extends Formatter> binaryFormatterClass = BinaryFormatter.class;
    public Map<String, List<IteratorSetting>> scanIteratorOptions = new HashMap<String, List<IteratorSetting>>();
    public Map<String, List<IteratorSetting>> iteratorProfiles = new HashMap<String, List<IteratorSetting>>();
    private Token rootToken;
    public final Map<String, Command> commandFactory = new TreeMap<String, Command>();
    public final Map<String, Command[]> commandGrouping = new TreeMap<String, Command[]>();
    protected boolean configError = false;
    private boolean exit = false;
    protected File execFile = null;
    protected String execCommand = null;
    protected boolean verbose = true;
    private boolean tabCompletion;
    private boolean disableAuthTimeout;
    private long authTimeout;
    private long lastUserActivity = System.currentTimeMillis();
    private boolean logErrorsToConsole = false;
    private PrintWriter writer = null;
    private boolean masking = false;

    public Shell() throws IOException {
        this(new ConsoleReader(), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("jline.WindowsTerminal.output.encoding", System.getProperty("file.encoding")))));
    }

    public Shell(ConsoleReader reader, PrintWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public boolean config(String ... args) {
        ShellOptionsJC options = new ShellOptionsJC();
        JCommander jc = new JCommander();
        jc.setProgramName("accumulo shell");
        jc.addObject((Object)options);
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            this.configError = true;
        }
        if (options.isHelpEnabled()) {
            this.configError = true;
        }
        if (!this.configError && options.getUnrecognizedOptions() != null) {
            this.configError = true;
            this.logError("Unrecognized Options: " + options.getUnrecognizedOptions().toString());
        }
        if (this.configError) {
            jc.usage();
            return true;
        }
        Shell.setDebugging(options.isDebugEnabled());
        this.authTimeout = options.getAuthTimeout() * 60 * 1000;
        this.disableAuthTimeout = options.isAuthTimeoutDisabled();
        String user = options.getUsername();
        String password = options.getPassword();
        this.tabCompletion = !options.isTabCompletionDisabled();
        this.setInstance(options);
        this.token = options.getAuthenticationToken();
        Map<String, String> loginOptions = options.getTokenProperties();
        try {
            boolean hasTokenOptions;
            boolean hasToken = this.token != null;
            boolean bl = hasTokenOptions = !loginOptions.isEmpty();
            if (hasToken && password != null) {
                throw new ParameterException("Can not supply '--pass' option with '--tokenClass' option");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Shell.this.reader.getTerminal().setEchoEnabled(true);
                }
            });
            if (hasToken != hasTokenOptions) {
                throw new ParameterException("Must supply either both or neither of '--tokenClass' and '--tokenProperty'");
            }
            if (hasToken) {
                AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                props.putAllStrings(loginOptions);
                this.token.init(props);
            } else {
                if ("stdin".equals(password) || password == null) {
                    password = this.reader.readLine("Password: ", Character.valueOf('*'));
                }
                if (password == null) {
                    throw new ParameterException("No password or token option supplied");
                }
                this.token = new PasswordToken(password);
            }
            if (!options.isFake()) {
                ZooReader zr = new ZooReader(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut());
                DistributedTrace.enable(this.instance, zr, "shell", InetAddress.getLocalHost().getHostName());
            }
            this.setTableName("");
            this.principal = user;
            this.connector = this.instance.getConnector(this.principal, this.token);
        }
        catch (Exception e) {
            this.printException(e);
            this.configError = true;
        }
        if (options.getExecFile() != null) {
            this.execFile = options.getExecFile();
            this.verbose = false;
        } else if (options.getExecFileVerbose() != null) {
            this.execFile = options.getExecFileVerbose();
            this.verbose = true;
        }
        this.execCommand = options.getExecCommand();
        if (this.execCommand != null) {
            this.verbose = false;
        }
        this.rootToken = new Token();
        Command[] dataCommands = new Command[]{new DeleteCommand(), new DeleteManyCommand(), new DeleteRowsCommand(), new EGrepCommand(), new FormatterCommand(), new InterpreterCommand(), new GrepCommand(), new ImportDirectoryCommand(), new InsertCommand(), new MaxRowCommand(), new ScanCommand()};
        Command[] debuggingCommands = new Command[]{new ClasspathCommand(), new DebugCommand(), new ListScansCommand(), new ListCompactionsCommand(), new TraceCommand(), new PingCommand()};
        Command[] execCommands = new Command[]{new ExecfileCommand(), new HistoryCommand(), new ExtensionCommand(), new ScriptCommand()};
        Command[] exitCommands = new Command[]{new ByeCommand(), new ExitCommand(), new QuitCommand()};
        Command[] helpCommands = new Command[]{new AboutCommand(), new HelpCommand(), new InfoCommand(), new QuestionCommand()};
        Command[] iteratorCommands = new Command[]{new DeleteIterCommand(), new DeleteScanIterCommand(), new ListIterCommand(), new SetIterCommand(), new SetScanIterCommand(), new SetShellIterCommand(), new ListShellIterCommand(), new DeleteShellIterCommand()};
        Command[] otherCommands = new Command[]{new HiddenCommand()};
        Command[] permissionsCommands = new Command[]{new GrantCommand(), new RevokeCommand(), new SystemPermissionsCommand(), new TablePermissionsCommand(), new UserPermissionsCommand(), new NamespacePermissionsCommand()};
        Command[] stateCommands = new Command[]{new AuthenticateCommand(), new ClsCommand(), new ClearCommand(), new FateCommand(), new NoTableCommand(), new SleepCommand(), new TableCommand(), new UserCommand(), new WhoAmICommand()};
        Command[] tableCommands = new Command[]{new CloneTableCommand(), new ConfigCommand(), new CreateTableCommand(), new DeleteTableCommand(), new DropTableCommand(), new DUCommand(), new ExportTableCommand(), new ImportTableCommand(), new OfflineCommand(), new OnlineCommand(), new RenameTableCommand(), new TablesCommand(), new NamespacesCommand(), new CreateNamespaceCommand(), new DeleteNamespaceCommand(), new RenameNamespaceCommand()};
        Command[] tableControlCommands = new Command[]{new AddSplitsCommand(), new CompactCommand(), new ConstraintCommand(), new FlushCommand(), new GetGroupsCommand(), new GetSplitsCommand(), new MergeCommand(), new SetGroupsCommand()};
        Command[] userCommands = new Command[]{new AddAuthsCommand(), new CreateUserCommand(), new DeleteUserCommand(), new DropUserCommand(), new GetAuthsCommand(), new PasswdCommand(), new SetAuthsCommand(), new UsersCommand()};
        this.commandGrouping.put("-- Writing, Reading, and Removing Data --", dataCommands);
        this.commandGrouping.put("-- Debugging Commands -------------------", debuggingCommands);
        this.commandGrouping.put("-- Shell Execution Commands -------------", execCommands);
        this.commandGrouping.put("-- Exiting Commands ---------------------", exitCommands);
        this.commandGrouping.put("-- Help Commands ------------------------", helpCommands);
        this.commandGrouping.put("-- Iterator Configuration ---------------", iteratorCommands);
        this.commandGrouping.put("-- Permissions Administration Commands --", permissionsCommands);
        this.commandGrouping.put("-- Shell State Commands -----------------", stateCommands);
        this.commandGrouping.put("-- Table Administration Commands --------", tableCommands);
        this.commandGrouping.put("-- Table Control Commands ---------------", tableControlCommands);
        this.commandGrouping.put("-- User Administration Commands ---------", userCommands);
        for (Command[] cmds : this.commandGrouping.values()) {
            for (Command cmd : cmds) {
                this.commandFactory.put(cmd.getName(), cmd);
            }
        }
        for (Command cmd : otherCommands) {
            this.commandFactory.put(cmd.getName(), cmd);
        }
        return this.configError;
    }

    protected void setInstance(ShellOptionsJC options) {
        this.instance = null;
        if (options.isFake()) {
            this.instance = new MockInstance("fake");
        } else {
            String instanceName;
            String hosts;
            if (options.isHdfsZooInstance()) {
                hosts = null;
                instanceName = null;
            } else if (options.getZooKeeperInstance().size() > 0) {
                List<String> zkOpts = options.getZooKeeperInstance();
                instanceName = zkOpts.get(0);
                hosts = zkOpts.get(1);
            } else {
                instanceName = options.getZooKeeperInstanceName();
                hosts = options.getZooKeeperHosts();
            }
            try {
                this.instance = Shell.getZooInstance(instanceName, hosts, options.getClientConfiguration());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load client config from " + options.getClientConfigFile(), e);
            }
        }
    }

    private static Instance getZooInstance(String instanceName, String keepers, ClientConfiguration clientConfig) {
        UUID instanceId = null;
        if (instanceName == null) {
            instanceName = clientConfig.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        }
        if (instanceName == null || keepers == null) {
            SiteConfiguration conf = SiteConfiguration.getInstance(ServerConfigurationUtil.convertClientConfig(DefaultConfiguration.getInstance(), (Configuration)clientConfig));
            if (instanceName == null) {
                Path instanceDir = new Path(VolumeConfiguration.getVolumeUris(conf)[0], "instance_id");
                instanceId = UUID.fromString(ZooUtil.getInstanceIDFromHdfs(instanceDir, conf));
            }
            if (keepers == null) {
                keepers = ((AccumuloConfiguration)conf).get(Property.INSTANCE_ZK_HOST);
            }
        }
        if (instanceId != null) {
            return new ZooKeeperInstance((Configuration)clientConfig.withInstance(instanceId).withZkHosts(keepers));
        }
        return new ZooKeeperInstance((Configuration)clientConfig.withInstance(instanceName).withZkHosts(keepers));
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public ClassLoader getClassLoader(CommandLine cl, final Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException, IOException, FileSystemException {
        ClassLoader classloader;
        Iterable<Map.Entry<String, String>> tableProps;
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        String classpath = null;
        if (namespaces) {
            try {
                tableProps = shellState.getConnector().namespaceOperations().getProperties(OptUtil.getNamespaceOpt(cl, shellState));
            }
            catch (NamespaceNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (tables) {
            tableProps = shellState.getConnector().tableOperations().getProperties(OptUtil.getTableOpt(cl, shellState));
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        for (Map.Entry<String, String> entry : tableProps) {
            if (!entry.getKey().equals(Property.TABLE_CLASSPATH.getKey())) continue;
            classpath = entry.getValue();
        }
        if (classpath != null && !classpath.equals("")) {
            shellState.getConnector().instanceOperations().getSystemConfiguration().get(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + classpath);
            try {
                AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig((Iterable)new Iterable<Map.Entry<String, String>>(){

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        try {
                            return shellState.getConnector().instanceOperations().getSystemConfiguration().entrySet().iterator();
                        }
                        catch (AccumuloException e) {
                            throw new RuntimeException(e);
                        }
                        catch (AccumuloSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }));
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            classloader = AccumuloVFSClassLoader.getContextManager().getClassLoader(classpath);
        } else {
            classloader = AccumuloVFSClassLoader.getClassLoader();
        }
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Shell shell = new Shell();
        try {
            shell.config(args);
            System.exit(shell.start());
        }
        finally {
            shell.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        String home;
        if (this.configError) {
            return 1;
        }
        if (this.isVerbose()) {
            this.printInfo();
        }
        if ((home = System.getProperty("HOME")) == null) {
            home = System.getenv("HOME");
        }
        String configDir = home + "/" + HISTORY_DIR_NAME;
        String historyPath = configDir + "/" + HISTORY_FILE_NAME;
        File accumuloDir = new File(configDir);
        if (!accumuloDir.exists() && !accumuloDir.mkdirs()) {
            log.warn((Object)("Unable to make directory for history at " + accumuloDir));
        }
        try {
            final FileHistory history = new FileHistory(new File(historyPath));
            this.reader.setHistory((History)history);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        history.flush();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Could not flush history to file.");
                    }
                }
            });
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load history file at " + historyPath));
        }
        this.reader.setHandleUserInterrupt(true);
        ShellCompletor userCompletor = null;
        if (this.execFile != null) {
            Scanner scanner = new Scanner(this.execFile, Constants.UTF8.name());
            try {
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
            finally {
                scanner.close();
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split("\n")) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (true) {
            try {
                if (this.hasExited()) {
                    int arr$ = this.exitCode;
                    return arr$;
                }
                if (this.tabCompletion) {
                    if (userCompletor != null) {
                        this.reader.removeCompleter((Completer)userCompletor);
                    }
                    userCompletor = this.setupCompletion();
                    this.reader.addCompleter((Completer)userCompletor);
                }
                this.reader.setPrompt(this.getDefaultPrompt());
                String input = this.reader.readLine();
                if (input == null) {
                    this.reader.println();
                    int arr$ = this.exitCode;
                    return arr$;
                }
                this.execCommand(input, this.disableAuthTimeout, false);
                continue;
            }
            catch (UserInterruptException uie) {
                this.reader.println();
                String partialLine = uie.getPartialLine();
                if (partialLine != null && !"".equals(uie.getPartialLine().trim())) continue;
                int n = this.exitCode;
                return n;
            }
            finally {
                this.reader.flush();
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.reader != null) {
            this.reader.shutdown();
        }
    }

    public void printInfo() throws IOException {
        this.reader.print((CharSequence)("\nShell - Apache Accumulo Interactive Shell\n- \n- version: 1.6.1\n- instance name: " + this.connector.getInstance().getInstanceName() + "\n" + "- instance id: " + this.connector.getInstance().getInstanceID() + "\n" + "- \n" + "- type 'help' for a list of available commands\n" + "- \n"));
        this.reader.flush();
    }

    public void printVerboseInfo() throws IOException {
        StringBuilder sb = new StringBuilder("-\n");
        sb.append("- Current user: ").append(this.connector.whoami()).append("\n");
        if (this.execFile != null) {
            sb.append("- Executing commands from: ").append(this.execFile).append("\n");
        }
        if (this.disableAuthTimeout) {
            sb.append("- Authorization timeout: disabled\n");
        } else {
            sb.append("- Authorization timeout: ").append(String.format("%.2fs%n", (double)this.authTimeout / 1000.0));
        }
        sb.append("- Debug: ").append(Shell.isDebuggingEnabled() ? "on" : "off").append("\n");
        if (!this.scanIteratorOptions.isEmpty()) {
            for (Map.Entry<String, List<IteratorSetting>> entry : this.scanIteratorOptions.entrySet()) {
                sb.append("- Session scan iterators for table ").append(entry.getKey()).append(":\n");
                for (IteratorSetting setting : entry.getValue()) {
                    sb.append("-    Iterator ").append(setting.getName()).append(" options:\n");
                    sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                    sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                    for (Map.Entry<String, String> optEntry : setting.getOptions().entrySet()) {
                        sb.append("-        ").append(optEntry.getKey()).append(" = ").append(optEntry.getValue()).append("\n");
                    }
                }
            }
        }
        sb.append("-\n");
        this.reader.print((CharSequence)sb.toString());
    }

    public String getDefaultPrompt() {
        return this.connector.whoami() + "@" + this.connector.getInstance().getInstanceName() + (this.getTableName().isEmpty() ? "" : " ") + this.getTableName() + "> ";
    }

    public void execCommand(String input, boolean ignoreAuthTimeout, boolean echoPrompt) throws IOException {
        block24: {
            String[] fields;
            audit.log((Priority)Level.INFO, (Object)(this.getDefaultPrompt() + input));
            if (echoPrompt) {
                this.reader.print((CharSequence)this.getDefaultPrompt());
                this.reader.println((CharSequence)input);
            }
            if (input.startsWith(COMMENT_PREFIX)) {
                return;
            }
            try {
                fields = new QuotedStringTokenizer(input).getTokens();
            }
            catch (BadArgumentException e) {
                this.printException(e);
                ++this.exitCode;
                return;
            }
            if (fields.length == 0) {
                return;
            }
            String command = fields[0];
            fields = fields.length > 1 ? Arrays.copyOfRange(fields, 1, fields.length) : new String[]{};
            Command sc = null;
            if (command.length() > 0) {
                try {
                    sc = this.commandFactory.get(command);
                    if (sc == null) {
                        this.reader.println((CharSequence)String.format("Unknown command \"%s\".  Enter \"help\" for a list possible commands.", command));
                        this.reader.flush();
                        return;
                    }
                    if (!(sc instanceof ExitCommand) && !ignoreAuthTimeout && System.currentTimeMillis() - this.lastUserActivity > this.authTimeout) {
                        this.reader.println((CharSequence)"Shell has been idle for too long. Please re-authenticate.");
                        boolean authFailed = true;
                        do {
                            String pwd;
                            if ((pwd = this.readMaskedLine("Enter current password for '" + this.connector.whoami() + "': ", Character.valueOf('*'))) == null) {
                                this.reader.println();
                                return;
                            }
                            try {
                                authFailed = !this.connector.securityOperations().authenticateUser(this.connector.whoami(), new PasswordToken(pwd));
                            }
                            catch (Exception e) {
                                ++this.exitCode;
                                this.printException(e);
                            }
                            if (!authFailed) continue;
                            this.reader.print((CharSequence)"Invalid password. ");
                        } while (authFailed);
                        this.lastUserActivity = System.currentTimeMillis();
                    }
                    Options parseOpts = sc.getOptionsWithHelp();
                    CommandLine cl = new BasicParser().parse(parseOpts, fields);
                    int actualArgLen = cl.getArgs().length;
                    int expectedArgLen = sc.numArgs();
                    if (cl.hasOption("?")) {
                        sc.printHelp(this);
                        break block24;
                    }
                    if (expectedArgLen != -1 && actualArgLen != expectedArgLen) {
                        ++this.exitCode;
                        this.printException(new IllegalArgumentException(String.format("Expected %d argument%s. There %s %d.", expectedArgLen, expectedArgLen == 1 ? "" : "s", actualArgLen == 1 ? "was" : "were", actualArgLen)));
                        sc.printHelp(this);
                        break block24;
                    }
                    int tmpCode = sc.execute(input, cl, this);
                    this.exitCode += tmpCode;
                    this.reader.flush();
                }
                catch (ConstraintViolationException e) {
                    ++this.exitCode;
                    this.printConstraintViolationException(e);
                }
                catch (TableNotFoundException e) {
                    ++this.exitCode;
                    if (this.getTableName().equals(e.getTableName())) {
                        this.setTableName("");
                    }
                    this.printException(e);
                }
                catch (ParseException e) {
                    if (!(e instanceof MissingOptionException) || !Arrays.asList(fields).contains("-?") && !Arrays.asList(fields).contains("--help")) {
                        ++this.exitCode;
                        this.printException((Exception)((Object)e));
                    }
                    if (sc != null) {
                        sc.printHelp(this);
                    }
                }
                catch (UserInterruptException e) {
                    ++this.exitCode;
                }
                catch (Exception e) {
                    ++this.exitCode;
                    this.printException(e);
                }
            } else {
                ++this.exitCode;
                this.printException(new BadArgumentException("Unrecognized empty command", command, -1));
            }
        }
        this.reader.flush();
    }

    private ShellCompletor setupCompletion() {
        this.rootToken = new Token();
        Set<String> tableNames = null;
        try {
            tableNames = this.connector.tableOperations().list();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of tables", (Throwable)e);
            tableNames = Collections.emptySet();
        }
        Set<String> userlist = null;
        try {
            userlist = this.connector.securityOperations().listLocalUsers();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of users", (Throwable)e);
            userlist = Collections.emptySet();
        }
        Set<String> namespaces = null;
        try {
            namespaces = this.connector.namespaceOperations().list();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of namespaces", (Throwable)e);
            namespaces = Collections.emptySet();
        }
        HashMap<Command.CompletionSet, Set<String>> options = new HashMap<Command.CompletionSet, Set<String>>();
        HashSet<String> commands = new HashSet<String>();
        for (String a : this.commandFactory.keySet()) {
            commands.add(a);
        }
        HashSet<String> modifiedUserlist = new HashSet<String>();
        HashSet<String> modifiedTablenames = new HashSet<String>();
        HashSet<String> modifiedNamespaces = new HashSet<String>();
        for (String a : tableNames) {
            modifiedTablenames.add(a.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String a : userlist) {
            modifiedUserlist.add(a.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String a : namespaces) {
            String b = a.replaceAll("([\\s'\"])", "\\\\$1");
            modifiedNamespaces.add(b.isEmpty() ? "\"\"" : b);
        }
        options.put(Command.CompletionSet.USERNAMES, modifiedUserlist);
        options.put(Command.CompletionSet.TABLENAMES, modifiedTablenames);
        options.put(Command.CompletionSet.NAMESPACES, modifiedNamespaces);
        options.put(Command.CompletionSet.COMMANDS, commands);
        Iterator<String> i$ = this.commandGrouping.values().iterator();
        while (i$.hasNext()) {
            Command[] cmdGroup;
            for (Command c : cmdGroup = (Command[])i$.next()) {
                c.getOptionsWithHelp();
                c.registerCompletion(this.rootToken, options);
            }
        }
        return new ShellCompletor(this.rootToken, options);
    }

    public final void printLines(Iterator<String> lines, boolean paginate) throws IOException {
        this.printLines(lines, paginate, null);
    }

    public final void printLines(Iterator<String> lines, boolean paginate, PrintLine out) throws IOException {
        int linesPrinted = 0;
        String prompt = "-- hit any key to continue or 'q' to quit --";
        int lastPromptLength = prompt.length();
        int termWidth = this.reader.getTerminal().getWidth();
        int maxLines = this.reader.getTerminal().getHeight();
        String peek = null;
        while (lines.hasNext()) {
            String nextLine = lines.next();
            if (nextLine == null) continue;
            for (String line : nextLine.split("\\n")) {
                if (out == null) {
                    if (peek != null) {
                        this.reader.println((CharSequence)peek);
                        if (paginate && (double)(linesPrinted = (int)((double)linesPrinted + (peek.length() == 0 ? 0.0 : Math.ceil((double)peek.length() * 1.0 / (double)termWidth)))) + Math.ceil((double)lastPromptLength * 1.0 / (double)termWidth) + Math.ceil((double)prompt.length() * 1.0 / (double)termWidth) + Math.ceil((double)line.length() * 1.0 / (double)termWidth) > (double)maxLines) {
                            linesPrinted = 0;
                            int numdashes = (termWidth - prompt.length()) / 2;
                            String nextPrompt = Shell.repeat("-", numdashes) + prompt + Shell.repeat("-", numdashes);
                            lastPromptLength = nextPrompt.length();
                            this.reader.print((CharSequence)nextPrompt);
                            this.reader.flush();
                            if (Character.toUpperCase((char)this.reader.readCharacter()) == 'Q') {
                                this.reader.println();
                                return;
                            }
                            this.reader.println();
                            termWidth = this.reader.getTerminal().getWidth();
                            maxLines = this.reader.getTerminal().getHeight();
                        }
                    }
                    peek = line;
                    continue;
                }
                out.print(line);
            }
        }
        if (out == null && peek != null) {
            this.reader.println(peek);
        }
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, Class<? extends Formatter> formatterClass, PrintLine outFile) throws IOException {
        this.printLines(FormatterFactory.getFormatter(formatterClass, scanner, printTimestamps), paginate, outFile);
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, Class<? extends Formatter> formatterClass) throws IOException {
        this.printLines(FormatterFactory.getFormatter(formatterClass, scanner, printTimestamps), paginate);
    }

    public final void printBinaryRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, PrintLine outFile) throws IOException {
        this.printLines(FormatterFactory.getFormatter(this.binaryFormatterClass, scanner, printTimestamps), paginate, outFile);
    }

    public final void printBinaryRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate) throws IOException {
        this.printLines(FormatterFactory.getFormatter(this.binaryFormatterClass, scanner, printTimestamps), paginate);
    }

    public static String repeat(String s, int c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public void checkTableState() {
        if (this.getTableName().isEmpty()) {
            throw new IllegalStateException("Not in a table context. Please use 'table <tableName>' to switch to a table, or use '-t' to specify a table if option is available.");
        }
    }

    private final void printConstraintViolationException(ConstraintViolationException cve) {
        this.printException((Exception)((Object)cve), "");
        int COL1 = 50;
        int COL2 = 14;
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.reader.getTerminal().getWidth() - COL1 - COL2 - 6));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "s | %-" + col3 + "s%n", "Constraint class", "Violation code", "Violation Description"));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        for (TConstraintViolationSummary cvs : cve.violationSummaries) {
            this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "d | %-" + col3 + "s%n", cvs.constrainClass, cvs.violationCode, cvs.violationDescription));
        }
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
    }

    public final void printException(Exception e) {
        this.printException(e, e.getMessage());
    }

    private final void printException(Exception e, String msg) {
        this.logError(e.getClass().getName() + (msg != null ? ": " + msg : ""));
        log.debug((Object)(e.getClass().getName() + (msg != null ? ": " + msg : "")), (Throwable)e);
    }

    public static final void setDebugging(boolean debuggingEnabled) {
        Logger.getLogger((String)"org.apache.accumulo.core").setLevel(debuggingEnabled ? Level.TRACE : Level.INFO);
    }

    public static final boolean isDebuggingEnabled() {
        return Logger.getLogger((String)"org.apache.accumulo.core").isTraceEnabled();
    }

    private final void printHelp(String usage, String description, Options opts) {
        this.printHelp(usage, description, opts, Integer.MAX_VALUE);
    }

    private final void printHelp(String usage, String description, Options opts, int width) {
        new HelpFormatter().printHelp(this.writer, width, usage, description, opts, 2, 5, null, true);
        this.writer.flush();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void resetExitCode() {
        this.exitCode = 0;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    public boolean getExit() {
        return this.exit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName == null || tableName.isEmpty() ? "" : Tables.qualified(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void updateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        this.connector = this.instance.getConnector(principal, token);
        this.principal = principal;
        this.token = token;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public AuthenticationToken getToken() {
        return this.token;
    }

    public Class<? extends Formatter> getFormatter() {
        return this.getFormatter(this.tableName);
    }

    public Class<? extends Formatter> getFormatter(String tableName) {
        Class<? extends Formatter> formatter = FormatterCommand.getCurrentFormatter(tableName, this);
        if (null == formatter) {
            this.logError("Could not load the specified formatter. Using the DefaultFormatter");
            return this.defaultFormatterClass;
        }
        return formatter;
    }

    public void setLogErrorsToConsole() {
        this.logErrorsToConsole = true;
    }

    private void logError(String s) {
        log.error((Object)s);
        if (this.logErrorsToConsole) {
            try {
                this.reader.println((CharSequence)("ERROR: " + s));
                this.reader.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String readMaskedLine(String prompt, Character mask) throws IOException {
        this.masking = true;
        String s = this.reader.readLine(prompt, mask);
        this.masking = false;
        return s;
    }

    public boolean isMasking() {
        return this.masking;
    }

    public boolean hasExited() {
        return this.exit;
    }

    public boolean isTabCompletion() {
        return this.tabCompletion;
    }

    public static class PrintFile
    implements PrintLine {
        PrintWriter writer;

        public PrintFile(String filename) throws FileNotFoundException {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), Constants.UTF8)));
        }

        @Override
        public void print(String s) {
            this.writer.println(s);
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }

    public static class PrintShell
    implements PrintLine {
        ConsoleReader reader;

        public PrintShell(ConsoleReader reader) {
            this.reader = reader;
        }

        @Override
        public void print(String s) {
            try {
                this.reader.println((CharSequence)s);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
        }
    }

    public static interface PrintLine {
        public void print(String var1);

        public void close();
    }

    public static abstract class Command {
        static Set<String> getCommandNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.COMMANDS);
        }

        static Set<String> getTableNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.TABLENAMES);
        }

        static Set<String> getUserNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.USERNAMES);
        }

        static Set<String> getNamespaces(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.NAMESPACES);
        }

        public void registerCompletionGeneral(Token root, Set<String> args, boolean caseSens) {
            Token t = new Token(args);
            t.setCaseSensitive(caseSens);
            Token command = new Token(this.getName());
            command.addSubcommand(t);
            root.addSubcommand(command);
        }

        public void registerCompletionForTables(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.TABLENAMES), true);
        }

        public void registerCompletionForUsers(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.USERNAMES), true);
        }

        public void registerCompletionForCommands(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.COMMANDS), false);
        }

        public void registerCompletionForNamespaces(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.NAMESPACES), true);
        }

        public abstract int execute(String var1, CommandLine var2, Shell var3) throws Exception;

        public abstract String description();

        public abstract int numArgs();

        public String getName() {
            String s = this.getClass().getName();
            int st = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
            int i = s.indexOf("Command");
            return i > 0 ? s.substring(st + 1, i).toLowerCase(Locale.ENGLISH) : null;
        }

        public void registerCompletion(Token root, Map<CompletionSet, Set<String>> completion_set) {
            root.addSubcommand(new Token(this.getName()));
        }

        public final void printHelp(Shell shellState) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp());
        }

        public final void printHelp(Shell shellState, int width) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp(), width);
        }

        public final Options getOptionsWithHelp() {
            Options opts = this.getOptions();
            opts.addOption(new Option("?", "help", false, "display this help"));
            return opts;
        }

        public String usage() {
            return this.getName();
        }

        public Options getOptions() {
            return new Options();
        }

        public static enum CompletionSet {
            TABLENAMES,
            USERNAMES,
            COMMANDS,
            NAMESPACES;

        }
    }
}

