/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.hppc.AbstractDoubleCollection;
import org.elasticsearch.common.hppc.AbstractIterator;
import org.elasticsearch.common.hppc.ArraySizingStrategy;
import org.elasticsearch.common.hppc.BoundedProportionalArraySizingStrategy;
import org.elasticsearch.common.hppc.DoubleContainer;
import org.elasticsearch.common.hppc.DoubleIndexedContainer;
import org.elasticsearch.common.hppc.Internals;
import org.elasticsearch.common.hppc.cursors.DoubleCursor;
import org.elasticsearch.common.hppc.predicates.DoublePredicate;
import org.elasticsearch.common.hppc.procedures.DoubleProcedure;

public class DoubleArrayList
extends AbstractDoubleCollection
implements DoubleIndexedContainer,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new double[0];
    public double[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public DoubleArrayList() {
        this(5);
    }

    public DoubleArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public DoubleArrayList(DoubleContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(double e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(double e1, double e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(double[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(double ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(DoubleContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (DoubleCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        for (DoubleCursor doubleCursor : iterable) {
            this.add(doubleCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, double e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public double get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public double set(int index, double e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        double v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public double remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        double v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0.0;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0.0);
    }

    @Override
    public int removeFirstOccurrence(double e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLastOccurrence(double e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAllOccurrences(double e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (Double.doubleToLongBits(e1) == Double.doubleToLongBits(this.buffer[from])) {
                this.buffer[from] = 0.0;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0.0;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(double e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(double e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (Double.doubleToLongBits(e1) != Double.doubleToLongBits(this.buffer[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (Double.doubleToLongBits(e1) != Double.doubleToLongBits(this.buffer[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount >= bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            double[] newBuffer = new double[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0.0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0.0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = (double[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public DoubleArrayList clone() {
        try {
            DoubleArrayList cloned = (DoubleArrayList)super.clone();
            cloned.buffer = (double[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof DoubleArrayList) {
                DoubleArrayList other = (DoubleArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof DoubleIndexedContainer) {
                DoubleIndexedContainer other = (DoubleIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(double[] b1, double[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (Double.doubleToLongBits(b1[i]) == Double.doubleToLongBits(b2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(DoubleIndexedContainer b1, DoubleIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            double o1 = b1.get(i);
            double o2 = b2.get(i);
            if (Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends DoubleProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        double[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(DoublePredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0.0;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0.0;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends DoublePredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        double[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static DoubleArrayList newInstance() {
        return new DoubleArrayList();
    }

    public static DoubleArrayList newInstanceWithCapacity(int initialCapacity) {
        return new DoubleArrayList(initialCapacity);
    }

    public static DoubleArrayList from(double ... elements) {
        DoubleArrayList list = new DoubleArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static DoubleArrayList from(DoubleContainer container) {
        return new DoubleArrayList(container);
    }

    static final class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private final double[] buffer;
        private final int size;

        public ValueIterator(double[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (DoubleCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

