/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.collect.UpdateInPlaceMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;

public class FieldMappersLookup
implements Iterable<FieldMapper> {
    private volatile FieldMapper[] mappers = new FieldMapper[0];
    private volatile List<FieldMapper> mappersAsList = ImmutableList.of();
    private final UpdateInPlaceMap<String, FieldMappers> name;
    private final UpdateInPlaceMap<String, FieldMappers> indexName;
    private final UpdateInPlaceMap<String, FieldMappers> fullName;

    public FieldMappersLookup(Settings settings) {
        this.fullName = UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings));
        this.name = UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings));
        this.indexName = UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings));
    }

    public void addNewMappers(List<FieldMapper> newMappers) {
        UpdateInPlaceMap.Mutator mutatorName = this.name.mutator();
        UpdateInPlaceMap.Mutator mutatorIndexName = this.indexName.mutator();
        UpdateInPlaceMap.Mutator mutatorFullName = this.fullName.mutator();
        for (FieldMapper fieldMapper : newMappers) {
            FieldMappers mappers = (FieldMappers)mutatorName.get(fieldMapper.names().name());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            mutatorName.put(fieldMapper.names().name(), mappers);
            mappers = (FieldMappers)mutatorIndexName.get(fieldMapper.names().indexName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            mutatorIndexName.put(fieldMapper.names().indexName(), mappers);
            mappers = (FieldMappers)mutatorFullName.get(fieldMapper.names().fullName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            mutatorFullName.put(fieldMapper.names().fullName(), mappers);
        }
        FieldMapper[] tempMappers = new FieldMapper[this.mappers.length + newMappers.size()];
        System.arraycopy(this.mappers, 0, tempMappers, 0, this.mappers.length);
        int counter = 0;
        for (int i = this.mappers.length; i < tempMappers.length; ++i) {
            tempMappers[i] = newMappers.get(counter++);
        }
        this.mappers = tempMappers;
        this.mappersAsList = Arrays.asList(this.mappers);
        mutatorName.close();
        mutatorIndexName.close();
        mutatorFullName.close();
    }

    public void removeMappers(Iterable<FieldMapper> mappersToRemove) {
        ArrayList<FieldMapper> tempMappers = Lists.newArrayList(this.mappers);
        UpdateInPlaceMap.Mutator mutatorName = this.name.mutator();
        UpdateInPlaceMap.Mutator mutatorIndexName = this.indexName.mutator();
        UpdateInPlaceMap.Mutator mutatorFullName = this.fullName.mutator();
        for (FieldMapper mapper : mappersToRemove) {
            FieldMappers mappers = (FieldMappers)mutatorName.get(mapper.names().name());
            if (mappers != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    mutatorName.remove(mapper.names().name());
                } else {
                    mutatorName.put(mapper.names().name(), mappers);
                }
            }
            if ((mappers = (FieldMappers)mutatorIndexName.get(mapper.names().indexName())) != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    mutatorIndexName.remove(mapper.names().indexName());
                } else {
                    mutatorIndexName.put(mapper.names().indexName(), mappers);
                }
            }
            if ((mappers = (FieldMappers)mutatorFullName.get(mapper.names().fullName())) != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    mutatorFullName.remove(mapper.names().fullName());
                } else {
                    mutatorFullName.put(mapper.names().fullName(), mappers);
                }
            }
            tempMappers.remove(mapper);
        }
        this.mappers = tempMappers.toArray(new FieldMapper[tempMappers.size()]);
        this.mappersAsList = Arrays.asList(this.mappers);
        mutatorName.close();
        mutatorIndexName.close();
        mutatorFullName.close();
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return Iterators.unmodifiableIterator(this.mappersAsList.iterator());
    }

    public List<FieldMapper> mappers() {
        return this.mappersAsList;
    }

    public boolean hasMapper(FieldMapper fieldMapper) {
        return this.mappersAsList.contains(fieldMapper);
    }

    public FieldMappers name(String name) {
        return this.name.get(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.indexName.get(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fullName.get(fullName);
    }

    public List<String> simpleMatchToIndexNames(String pattern) {
        ArrayList<String> fields = Lists.newArrayList();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().indexName());
        }
        return fields;
    }

    public List<String> simpleMatchToFullName(String pattern) {
        ArrayList<String> fields = Lists.newArrayList();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().fullName());
        }
        return fields;
    }

    @Nullable
    public FieldMappers smartName(String name) {
        FieldMappers fieldMappers = this.fullName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        fieldMappers = this.indexName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        return this.name(name);
    }

    @Nullable
    public FieldMapper smartNameFieldMapper(String name) {
        FieldMappers fieldMappers = this.smartName(name);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }
}

