/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.suggest.stats;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.suggest.stats.SuggestStats;

public class ShardSuggestService
extends AbstractIndexShardComponent {
    private final MeanMetric suggestMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardSuggestService(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public void preSuggest() {
        this.currentMetric.inc();
    }

    public void postSuggest(long tookInNanos) {
        this.currentMetric.dec();
        this.suggestMetric.inc(tookInNanos);
    }

    public SuggestStats stats() {
        return new SuggestStats(this.suggestMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.suggestMetric.sum()), this.currentMetric.count());
    }
}

