/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.restart;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartRequest;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestNodesRestartAction
extends BaseRestHandler {
    @Inject
    public RestNodesRestartAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/nodes/_restart", this);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/nodes/{nodeId}/_restart", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesRestartRequest nodesRestartRequest = new NodesRestartRequest(nodesIds);
        nodesRestartRequest.listenerThreaded(false);
        nodesRestartRequest.delay(request.paramAsTime("delay", nodesRestartRequest.delay()));
        client.admin().cluster().nodesRestart(nodesRestartRequest, (ActionListener<NodesRestartResponse>)new RestBuilderListener<NodesRestartResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesRestartResponse result, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("cluster_name", result.getClusterName().value());
                builder.startObject("nodes");
                for (NodesRestartResponse.NodeRestartResponse nodeInfo : result) {
                    builder.startObject(nodeInfo.getNode().id());
                    builder.field("name", nodeInfo.getNode().name());
                    builder.endObject();
                }
                builder.endObject();
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

