/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.ThreadFilter;
import com.carrotsearch.randomizedtesting.ThreadLeakError;
import com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.randomizedtesting.UncaughtExceptionError;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakGroup;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import com.carrotsearch.randomizedtesting.annotations.Timeout;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

class ThreadLeakControl {
    private static final Logger logger = RandomizedRunner.logger;
    private final int killAttempts;
    private final int killWait;
    private final RunNotifier targetNotifier;
    private final Set<Thread> expectedSuiteState;
    private final Object notifierLock = new Object();
    private final SubNotifier subNotifier;
    private TimeoutValue testTimeout;
    private TimeoutValue suiteTimeout;
    private final List<ThreadFilter> builtinFilters;
    private ThreadFilter suiteFilters;
    private final RandomizedRunner runner;
    private AtomicBoolean suiteTimedOut = new AtomicBoolean();
    ThreadLeakGroup threadLeakGroup;

    private static ThreadFilter or(final ThreadFilter ... filters) {
        return new ThreadFilter(){

            @Override
            public boolean reject(Thread t) {
                boolean reject = false;
                for (ThreadFilter f : filters) {
                    if (reject |= f.reject(t)) break;
                }
                return reject;
            }
        };
    }

    ThreadLeakControl(RunNotifier notifier, RandomizedRunner runner) {
        this.targetNotifier = notifier;
        this.subNotifier = new SubNotifier();
        this.runner = runner;
        this.killAttempts = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_KILLATTEMPTS(), 5);
        this.killWait = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_KILLWAIT(), 500);
        this.testTimeout = new TimeoutValue(SysGlobals.SYSPROP_TIMEOUT(), 0);
        this.suiteTimeout = new TimeoutValue(SysGlobals.SYSPROP_TIMEOUT_SUITE(), 0);
        this.builtinFilters = Arrays.asList(new ThisThreadFilter(Thread.currentThread()), new KnownSystemThread());
        this.expectedSuiteState = Collections.unmodifiableSet(Threads.getAllThreads());
    }

    Statement forSuite(final Statement s, final Description suiteDescription) {
        final Class<?> suiteClass = RandomizedContext.current().getTargetClass();
        final int timeout = this.determineTimeout(suiteClass);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                RandomizedRunner.checkZombies();
                ThreadLeakControl.this.threadLeakGroup = (ThreadLeakGroup)ThreadLeakControl.firstAnnotated(ThreadLeakGroup.class, new AnnotatedElement[]{suiteClass, DefaultAnnotationValues.class});
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                ThreadLeakControl.this.suiteFilters = ThreadLeakControl.this.instantiateFilters(errors, suiteClass);
                MultipleFailureException.assertEmpty(errors);
                StatementRunner sr = new StatementRunner(s);
                boolean timedOut = ThreadLeakControl.this.forkTimeoutingTask(sr, timeout, errors);
                Object object = ThreadLeakControl.this.notifierLock;
                synchronized (object) {
                    if (timedOut) {
                        ThreadLeakControl.this.suiteTimedOut.set(true);
                        System.out.flush();
                        System.err.flush();
                        logger.warning("Suite execution timed out: " + suiteDescription + ThreadLeakControl.this.formatThreadStacksFull());
                        ThreadLeakControl.this.subNotifier.pleaseStop();
                    }
                }
                if (timedOut) {
                    if (((ThreadLeakControl)ThreadLeakControl.this).subNotifier.testInProgress != null) {
                        ThreadLeakControl.this.targetNotifier.fireTestFailure(new Failure(((ThreadLeakControl)ThreadLeakControl.this).subNotifier.testInProgress, RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new Exception("Test abandoned because suite timeout was reached.")), new Randomness[0])));
                        ThreadLeakControl.this.targetNotifier.fireTestFinished(((ThreadLeakControl)ThreadLeakControl.this).subNotifier.testInProgress);
                    }
                    errors.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new Exception("Suite timeout exceeded (>= " + timeout + " msec).")), new Randomness[0]));
                }
                AnnotatedElement[] chain = new AnnotatedElement[]{suiteClass, DefaultAnnotationValues.class};
                ArrayList<Throwable> threadLeakErrors = timedOut ? new ArrayList<Throwable>() : errors;
                ThreadLeakControl.this.checkThreadLeaks(ThreadLeakControl.this.refilter(ThreadLeakControl.this.expectedSuiteState, ThreadLeakControl.this.suiteFilters), threadLeakErrors, LifecycleScope.SUITE, suiteDescription, chain);
                ThreadLeakControl.this.processUncaught(errors, ((ThreadLeakControl)ThreadLeakControl.this).runner.handler.getUncaughtAndClear());
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    Statement forTest(final Statement s, final RandomizedRunner.TestCandidate c) {
        final int timeout = this.determineTimeout(c);
        return new Statement(){

            public void evaluate() throws Throwable {
                RandomizedRunner.checkZombies();
                StatementRunner sr = new StatementRunner(s);
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                HashSet beforeTestState = ThreadLeakControl.this.getThreads(new ThreadFilter[]{ThreadLeakControl.this.suiteFilters});
                boolean timedOut = ThreadLeakControl.this.forkTimeoutingTask(sr, timeout, errors);
                if (ThreadLeakControl.this.suiteTimedOut.get()) {
                    return;
                }
                if (timedOut) {
                    logger.warning("Test execution timed out: " + c.description + ThreadLeakControl.this.formatThreadStacksFull());
                }
                if (timedOut) {
                    errors.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new Exception("Test timeout exceeded (>= " + timeout + " msec).")), new Randomness[0]));
                }
                AnnotatedElement[] chain = new AnnotatedElement[]{c.method, c.instanceProvider.getTestClass(), DefaultAnnotationValues.class};
                ArrayList<Throwable> threadLeakErrors = timedOut ? new ArrayList<Throwable>() : errors;
                ThreadLeakControl.this.checkThreadLeaks(beforeTestState, threadLeakErrors, LifecycleScope.TEST, c.description, chain);
                ThreadLeakControl.this.processUncaught(errors, ((ThreadLeakControl)ThreadLeakControl.this).runner.handler.getUncaughtAndClear());
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    protected Set<Thread> refilter(Set<Thread> in, ThreadFilter f) {
        HashSet<Thread> t = new HashSet<Thread>(in);
        Iterator<Thread> i = t.iterator();
        while (i.hasNext()) {
            if (!f.reject(i.next())) continue;
            i.remove();
        }
        return t;
    }

    private ThreadFilter instantiateFilters(List<Throwable> errors, Class<?> suiteClass) {
        ThreadLeakFilters ann = ThreadLeakControl.firstAnnotated(ThreadLeakFilters.class, new AnnotatedElement[]{suiteClass, DefaultAnnotationValues.class});
        ArrayList<ThreadFilter> filters = new ArrayList<ThreadFilter>();
        for (Class<? extends ThreadFilter> c : ann.filters()) {
            try {
                filters.add(c.newInstance());
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        if (ann.defaultFilters()) {
            filters.addAll(this.builtinFilters);
        }
        return ThreadLeakControl.or(filters.toArray(new ThreadFilter[filters.size()]));
    }

    private static <T extends Throwable> T emptyStack(T t) {
        t.setStackTrace(new StackTraceElement[0]);
        return t;
    }

    protected void processUncaught(List<Throwable> errors, List<RandomizedRunner.UncaughtException> uncaughtList) {
        for (RandomizedRunner.UncaughtException e : uncaughtList) {
            errors.add(ThreadLeakControl.emptyStack(new UncaughtExceptionError("Captured an uncaught exception in thread: " + e.threadName, e.error)));
        }
    }

    protected void checkThreadLeaks(Set<Thread> expectedState, List<Throwable> errors, LifecycleScope scope, Description description, AnnotatedElement ... annotationChain) {
        ThreadLeakScope annScope = ThreadLeakControl.firstAnnotated(ThreadLeakScope.class, annotationChain);
        if (annScope.value() == ThreadLeakScope.Scope.NONE) {
            return;
        }
        if (annScope.value() == ThreadLeakScope.Scope.SUITE && scope == LifecycleScope.TEST) {
            return;
        }
        int lingerTime = ThreadLeakControl.firstAnnotated(ThreadLeakLingering.class, annotationChain).linger();
        HashSet<Thread> threads = this.getThreads(this.suiteFilters);
        threads.removeAll(expectedState);
        if (lingerTime > 0 && !threads.isEmpty()) {
            long deadline = System.currentTimeMillis() + (long)lingerTime;
            try {
                logger.warning("Will linger awaiting termination of " + threads.size() + " leaked thread(s).");
                do {
                    Thread.sleep(250L);
                    threads = this.getThreads(this.suiteFilters);
                    threads.removeAll(expectedState);
                } while (!threads.isEmpty() && System.currentTimeMillis() <= deadline);
            }
            catch (InterruptedException e) {
                logger.warning("Lingering interrupted.");
            }
        }
        if (threads.isEmpty()) {
            return;
        }
        HashMap<Thread, StackTraceElement[]> withTraces = this.getThreadsWithTraces(this.suiteFilters);
        withTraces.keySet().removeAll(expectedState);
        if (withTraces.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder(threads.size() + " thread" + (threads.size() == 1 ? "" : "s") + " leaked from " + (Object)((Object)scope) + " scope at " + description + ": ");
        message.append(this.formatThreadStacks(withTraces));
        errors.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new ThreadLeakError(message.toString())), new Randomness[0]));
        EnumSet<ThreadLeakAction.Action> actions = EnumSet.noneOf(ThreadLeakAction.Action.class);
        actions.addAll(Arrays.asList(ThreadLeakControl.firstAnnotated(ThreadLeakAction.class, annotationChain).value()));
        if (actions.contains((Object)ThreadLeakAction.Action.WARN)) {
            logger.severe(message.toString());
        }
        Set<Object> zombies = Collections.emptySet();
        if (actions.contains((Object)ThreadLeakAction.Action.INTERRUPT)) {
            zombies = this.tryToInterruptAll(errors, withTraces.keySet());
        }
        if (!zombies.isEmpty()) {
            switch (ThreadLeakControl.firstAnnotated(ThreadLeakZombies.class, annotationChain).value()) {
                case CONTINUE: {
                    break;
                }
                case IGNORE_REMAINING_TESTS: {
                    RandomizedRunner.zombieMarker.set(true);
                    break;
                }
                default: {
                    throw new RuntimeException("Missing case.");
                }
            }
        }
    }

    private String formatThreadStacks(Map<Thread, StackTraceElement[]> threads) {
        StringBuilder message = new StringBuilder();
        int cnt = 1;
        Formatter f = new Formatter(message);
        for (Map.Entry<Thread, StackTraceElement[]> e : threads.entrySet()) {
            f.format(Locale.ENGLISH, "\n  %2d) %s", cnt++, Threads.threadName(e.getKey())).flush();
            if (e.getValue().length == 0) {
                message.append("\n        at (empty stack)");
                continue;
            }
            for (StackTraceElement ste : e.getValue()) {
                message.append("\n        at ").append(ste);
            }
        }
        return message.toString();
    }

    private String threadNames(Collection<Thread> threads) {
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b);
        int cnt = 1;
        for (Thread t : threads) {
            f.format(Locale.ENGLISH, "\n  %2d) %s", cnt++, Threads.threadName(t));
        }
        return b.toString();
    }

    private String formatThreadStacksFull() {
        try {
            StringBuilder b = new StringBuilder();
            b.append("\n==== jstack at approximately timeout time ====\n");
            for (ThreadInfo ti : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                Threads.append(b, ti);
            }
            b.append("^^==============================================\n");
            return b.toString();
        }
        catch (Throwable throwable) {
            return this.formatThreadStacks(this.getThreadsWithTraces(new ThreadFilter[0]));
        }
    }

    private HashMap<Thread, StackTraceElement[]> getThreadsWithTraces(ThreadFilter ... filters) {
        HashSet<Thread> threads = this.getThreads(filters);
        HashMap<Thread, StackTraceElement[]> r = new HashMap<Thread, StackTraceElement[]>();
        for (Thread t : threads) {
            r.put(t, t.getStackTrace());
        }
        return r;
    }

    private HashSet<Thread> getThreads(ThreadFilter ... filters) {
        HashSet<Thread> threads;
        switch (this.threadLeakGroup.value()) {
            case ALL: {
                threads = Threads.getAllThreads();
                break;
            }
            case MAIN: {
                threads = Threads.getThreads(RandomizedRunner.mainThreadGroup);
                break;
            }
            case TESTGROUP: {
                threads = Threads.getThreads(this.runner.runnerThreadGroup);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        ThreadFilter filter = ThreadLeakControl.or(filters);
        Iterator<Thread> i = threads.iterator();
        while (i.hasNext()) {
            Thread t = i.next();
            if (t.isAlive() && !filter.reject(t)) continue;
            i.remove();
        }
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Thread> tryToInterruptAll(List<Throwable> errors, Set<Thread> threads) {
        logger.info("Starting to interrupt leaked threads:" + this.threadNames(threads));
        this.runner.handler.stopReporting();
        try {
            boolean allDead;
            HashSet<Thread> ordered = new HashSet<Thread>(threads);
            int interruptAttempts = this.killAttempts;
            int interruptWait = this.killWait;
            int restorePriority = Thread.currentThread().getPriority();
            do {
                allDead = true;
                try {
                    Thread.currentThread().setPriority(10);
                    for (Thread t : ordered) {
                        t.interrupt();
                    }
                    long waitDeadline = System.currentTimeMillis() + (long)interruptWait;
                    Iterator<Thread> i = ordered.iterator();
                    while (i.hasNext()) {
                        Thread t = i.next();
                        if (t.isAlive()) {
                            allDead = false;
                            t.join(Math.max(1L, waitDeadline - System.currentTimeMillis()));
                            continue;
                        }
                        i.remove();
                    }
                }
                catch (InterruptedException e) {
                    interruptAttempts = 0;
                }
            } while (!allDead && --interruptAttempts >= 0);
            Thread.currentThread().setPriority(restorePriority);
            HashMap<Thread, StackTraceElement[]> zombies = new HashMap<Thread, StackTraceElement[]>();
            for (Thread t : ordered) {
                if (!t.isAlive()) continue;
                zombies.put(t, t.getStackTrace());
            }
            if (zombies.isEmpty()) {
                logger.info("All leaked threads terminated.");
            } else {
                String message = "There are still zombie threads that couldn't be terminated:" + this.formatThreadStacks(zombies);
                logger.severe(message);
                errors.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new ThreadLeakError(message.toString())), new Randomness[0]));
            }
            Set<Thread> set = zombies.keySet();
            return set;
        }
        finally {
            this.runner.handler.resumeReporting();
        }
    }

    boolean forkTimeoutingTask(StatementRunner r, int timeout, List<Throwable> errors) throws InterruptedException {
        boolean timedOut;
        if (timeout == 0) {
            r.run();
        } else {
            Thread t = new Thread((Runnable)r, Thread.currentThread().getName() + "-worker");
            RandomizedContext.cloneFor(t);
            t.start();
            t.join(timeout);
        }
        boolean bl = timedOut = !r.completed;
        if (r.error != null) {
            errors.add(r.error);
        }
        return timedOut;
    }

    RunNotifier notifier() {
        return this.subNotifier;
    }

    private int determineTimeout(Class<?> suiteClass) {
        TimeoutSuite timeoutAnn = suiteClass.getAnnotation(TimeoutSuite.class);
        return this.suiteTimeout.getTimeout(timeoutAnn == null ? null : Integer.valueOf(timeoutAnn.millis()));
    }

    private int determineTimeout(RandomizedRunner.TestCandidate c) {
        Test testAnn;
        Integer timeout = null;
        Timeout timeoutAnn = c.instanceProvider.getTestClass().getAnnotation(Timeout.class);
        if (timeoutAnn != null) {
            timeout = Math.min(Integer.MAX_VALUE, timeoutAnn.millis());
        }
        if ((testAnn = c.method.getAnnotation(Test.class)) != null && testAnn.timeout() > 0L) {
            timeout = (int)Math.min(Integer.MAX_VALUE, testAnn.timeout());
        }
        if ((timeoutAnn = c.method.getAnnotation(Timeout.class)) != null) {
            timeout = timeoutAnn.millis();
        }
        return this.testTimeout.getTimeout(timeout);
    }

    private static <T extends Annotation> T firstAnnotated(Class<T> clazz, AnnotatedElement ... elements) {
        for (AnnotatedElement element : elements) {
            T ann = element.getAnnotation(clazz);
            if (ann == null) continue;
            return ann;
        }
        throw new RuntimeException("default annotation value must be within elements.");
    }

    private static class StatementRunner
    implements Runnable {
        private final Statement s;
        volatile Throwable error;
        volatile boolean completed;

        StatementRunner(Statement s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.s.evaluate();
            }
            catch (Throwable t) {
                this.error = t;
            }
            finally {
                this.completed = true;
            }
        }
    }

    private static class KnownSystemThread
    implements ThreadFilter {
        private KnownSystemThread() {
        }

        @Override
        public boolean reject(Thread t) {
            ThreadGroup tgroup = t.getThreadGroup();
            if (tgroup != null && "system".equals(tgroup.getName()) && tgroup.getParent() == null) {
                return true;
            }
            if (t.getName().equals("JFR request timer")) {
                return true;
            }
            if (t.getName().equals("MemoryPoolMXBean notification dispatcher")) {
                return true;
            }
            if (t.getName().equals("AWT-AppKit")) {
                return true;
            }
            if (t.getName().contains("Poller SunPKCS11")) {
                return true;
            }
            if (t.getName().equals("process reaper")) {
                return true;
            }
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(t.getStackTrace()));
            Collections.reverse(stack);
            return stack.size() >= 1 && ((StackTraceElement)stack.get(0)).getClassName().startsWith("sun.misc.GC$Daemon");
        }
    }

    private static class ThisThreadFilter
    implements ThreadFilter {
        private final Thread t;

        public ThisThreadFilter(Thread t) {
            this.t = t;
        }

        @Override
        public boolean reject(Thread t) {
            return this.t == t;
        }
    }

    private static class TimeoutValue {
        private final int timeoutOverride;
        private final boolean globalTimeoutFirst;

        TimeoutValue(String sysprop, int defaultValue) {
            String timeoutValue = System.getProperty(sysprop);
            boolean globalTimeoutFirst = false;
            if (timeoutValue == null || timeoutValue.trim().length() == 0) {
                timeoutValue = null;
            }
            if (timeoutValue != null) {
                globalTimeoutFirst = timeoutValue.matches("[0-9]+\\!");
                timeoutValue = timeoutValue.replaceAll("\\!", "");
            } else {
                timeoutValue = Integer.toString(defaultValue);
            }
            this.timeoutOverride = Integer.parseInt(timeoutValue);
            this.globalTimeoutFirst = globalTimeoutFirst;
        }

        int getTimeout(Integer value) {
            if (this.globalTimeoutFirst) {
                return this.timeoutOverride;
            }
            return value != null ? value : this.timeoutOverride;
        }
    }

    private class SubNotifier
    extends RunNotifier {
        private boolean stopRequested = false;
        Description testInProgress;

        private SubNotifier() {
        }

        public void addListener(RunListener listener) {
            throw new UnsupportedOperationException();
        }

        public void addFirstListener(RunListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeListener(RunListener listener) {
            throw new UnsupportedOperationException();
        }

        public void fireTestRunFinished(Result result) {
            throw new UnsupportedOperationException();
        }

        public void fireTestRunStarted(Description description) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestStarted(Description description) throws StoppedByUserException {
            Object object = ThreadLeakControl.this.notifierLock;
            synchronized (object) {
                if (this.stopRequested) {
                    return;
                }
                ThreadLeakControl.this.targetNotifier.fireTestStarted(description);
                this.testInProgress = description;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestAssumptionFailed(Failure failure) {
            Object object = ThreadLeakControl.this.notifierLock;
            synchronized (object) {
                if (this.stopRequested) {
                    return;
                }
                ThreadLeakControl.this.targetNotifier.fireTestAssumptionFailed(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestFailure(Failure failure) {
            Object object = ThreadLeakControl.this.notifierLock;
            synchronized (object) {
                if (this.stopRequested) {
                    return;
                }
                ThreadLeakControl.this.targetNotifier.fireTestFailure(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestIgnored(Description description) {
            Object object = ThreadLeakControl.this.notifierLock;
            synchronized (object) {
                if (this.stopRequested) {
                    return;
                }
                this.testInProgress = null;
                ThreadLeakControl.this.targetNotifier.fireTestIgnored(description);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestFinished(Description description) {
            Object object = ThreadLeakControl.this.notifierLock;
            synchronized (object) {
                if (this.stopRequested) {
                    return;
                }
                this.testInProgress = null;
                ThreadLeakControl.this.targetNotifier.fireTestFinished(description);
            }
        }

        public void pleaseStop() {
            this.stopRequested = true;
        }
    }

    @ThreadLeakScope
    @ThreadLeakAction
    @ThreadLeakLingering
    @ThreadLeakZombies
    @ThreadLeakFilters
    @ThreadLeakGroup
    private static class DefaultAnnotationValues {
        private DefaultAnnotationValues() {
        }
    }
}

