/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util.structures;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tree<T>
extends HashMap<T, Tree<T>> {
    public Tree() {
    }

    public Tree(T ... children) {
        this();
        for (T t : children) {
            this.put(t, new Tree<T>());
        }
    }

    public Tree(Map.Entry<T, Tree<T>> ... children) {
        this();
        for (Map.Entry<T, Tree<T>> entry : children) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<Tree<T>> getTreesAtDepth(int depth) {
        ArrayList<Tree<T>> branches = new ArrayList<Tree<T>>();
        List<Tree<T>> currentDepth = Arrays.asList(this);
        for (int i = 0; i < depth; ++i) {
            if (i == depth - 1) {
                return currentDepth;
            }
            ArrayList<Tree<T>> temp = new ArrayList<Tree<T>>();
            for (Tree<T> t : currentDepth) {
                temp.addAll(t.values());
            }
            currentDepth = temp;
        }
        return branches;
    }

    public List<T> getObjectsAtDepth(int depth) {
        ArrayList list = new ArrayList();
        for (Tree<T> t : this.getTreesAtDepth(depth)) {
            list.addAll(t.keySet());
        }
        return list;
    }

    public List<Tree<T>> getLeafTrees() {
        ArrayList<Tree<T>> leaves = new ArrayList<Tree<T>>();
        List<Tree> currentDepth = Arrays.asList(this);
        boolean allLeaves = false;
        while (!allLeaves) {
            allLeaves = true;
            ArrayList<Tree> temp = new ArrayList<Tree>();
            for (Tree t : currentDepth) {
                if (t.isLeaf()) {
                    for (Map.Entry t2 : t.entrySet()) {
                        leaves.add(new Tree<T>(t2));
                    }
                    continue;
                }
                allLeaves = false;
                temp.addAll(t.values());
            }
            currentDepth = temp;
        }
        return leaves;
    }

    public List<T> getLeafObjects() {
        ArrayList leaves = new ArrayList();
        for (Tree<T> t : this.getLeafTrees()) {
            leaves.addAll(t.keySet());
        }
        return leaves;
    }

    public boolean isLeaf() {
        Collection values = this.values();
        return ((Tree)values.iterator().next()).isEmpty();
    }

    public static <T> Map.Entry<T, Tree<T>> createTree(T key, Tree<T> tree) {
        return new AbstractMap.SimpleEntry<T, Tree<T>>(key, tree);
    }
}

