/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusSerializer;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFaunusEdge
extends StandardFaunusRelation
implements FaunusEdge {
    protected long outVertex;
    protected long inVertex;
    private static final Logger log = LoggerFactory.getLogger(StandardFaunusEdge.class);

    public StandardFaunusEdge() {
        this((Configuration)ModifiableHadoopConfiguration.immutableWithResources());
    }

    public StandardFaunusEdge(Configuration configuration) {
        super(configuration, -1L, FaunusEdgeLabel.LINK);
    }

    public StandardFaunusEdge(Configuration configuration, long outVertex, long inVertex, String label) {
        this(configuration, -1L, outVertex, inVertex, label);
    }

    public StandardFaunusEdge(Configuration configuration, long id, long outVertex, long inVertex, String label) {
        this(configuration, id, outVertex, inVertex, FaunusSchemaManager.getTypeManager(configuration).getOrCreateEdgeLabel(label));
    }

    public StandardFaunusEdge(Configuration configuration, long outVertex, long inVertex, FaunusEdgeLabel label) {
        this(configuration, -1L, outVertex, inVertex, label);
    }

    public StandardFaunusEdge(Configuration configuration, long id, long outVertex, long inVertex, FaunusEdgeLabel label) {
        super(configuration, id, label);
        this.outVertex = outVertex;
        this.inVertex = inVertex;
    }

    public StandardFaunusEdge(Configuration configuration, DataInput in) throws IOException {
        super(configuration, -1L, FaunusEdgeLabel.LINK);
        this.readFields(in);
    }

    public EdgeLabel getEdgeLabel() {
        return (EdgeLabel)this.getType();
    }

    @Override
    public TitanVertex getVertex(int pos) {
        if (pos == 0) {
            return new FaunusVertex(this.configuration, this.outVertex);
        }
        if (pos == 1) {
            return new FaunusVertex(this.configuration, this.inVertex);
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public TitanVertex getVertex(Direction direction) {
        return this.getVertex(EdgeDirection.position((Direction)direction));
    }

    public String getLabel() {
        return this.getTypeName();
    }

    public TitanVertex getOtherVertex(TitanVertex vertex) {
        for (int i = 0; i < 2; ++i) {
            if (!this.getVertex(i).equals(vertex)) continue;
            return this.getVertex((i + 1) % 2);
        }
        throw new IllegalArgumentException("Edge is not incident on vertex: " + vertex);
    }

    public boolean isDirected() {
        return this.getEdgeLabel().isDirected();
    }

    public boolean isUnidirected() {
        return this.getEdgeLabel().isUnidirected();
    }

    @Override
    public long getVertexId(Direction direction) {
        if (Direction.OUT.equals((Object)direction)) {
            return this.outVertex;
        }
        if (Direction.IN.equals((Object)direction)) {
            return this.inVertex;
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    final void setLabel(FaunusEdgeLabel label) {
        Preconditions.checkNotNull((Object)((Object)label));
        this.setType(label);
    }

    public void write(DataOutput out) throws IOException {
        new FaunusSerializer(this.configuration).writeEdge(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        new FaunusSerializer(this.configuration).readEdge(this, in);
    }

    public String toString() {
        try {
            return StringFactory.edgeString((Edge)this);
        }
        catch (NullPointerException e) {
            return "StandardFaunusEdge[null]";
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.outVertex).append(this.inVertex).append(this.getLongId()).append((Object)this.getType()).toHashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !(oth instanceof TitanEdge)) {
            return false;
        }
        TitanEdge e = (TitanEdge)oth;
        if (this.hasId() || e.hasId()) {
            return this.getLongId() == e.getLongId();
        }
        return this.getType().equals(e.getEdgeLabel()) && this.outVertex == e.getVertex(Direction.OUT).getLongId() && this.inVertex == e.getVertex(Direction.IN).getLongId();
    }

    public static class MicroEdge
    extends FaunusPathElement.MicroElement {
        private static final String E1 = "e[";
        private static final String E2 = "]";

        public MicroEdge(long id) {
            super(id);
        }

        public String toString() {
            return E1 + this.id + E2;
        }
    }
}

