/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.exceptions;

import com.netflix.astyanax.connectionpool.Host;
import java.util.concurrent.TimeUnit;

public abstract class ConnectionException
extends Exception {
    private static final long serialVersionUID = -3476496346094715988L;
    private Host host = Host.NO_HOST;
    private long latency = 0L;
    private long latencyWithPool = 0L;
    private int attemptCount = 0;

    public ConnectionException(String message) {
        super(message);
    }

    public ConnectionException(Throwable t) {
        super(t);
    }

    public ConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConnectionException setHost(Host host) {
        this.host = host;
        return this;
    }

    public Host getHost() {
        return this.host;
    }

    public ConnectionException setLatency(long latency) {
        this.latency = latency;
        return this;
    }

    public long getLatency() {
        return this.latency;
    }

    public long getLatency(TimeUnit units) {
        return units.convert(this.latency, TimeUnit.NANOSECONDS);
    }

    public ConnectionException setLatencyWithPool(long latency) {
        this.latencyWithPool = latency;
        return this;
    }

    public long getLatencyWithPool() {
        return this.latencyWithPool;
    }

    @Override
    public String getMessage() {
        return this.getClass().getSimpleName() + ": [" + "host=" + this.host.toString() + ", latency=" + this.latency + "(" + this.latencyWithPool + ")" + ", attempts=" + this.attemptCount + "]" + super.getMessage();
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    public ConnectionException setAttempt(int attemptCount) {
        this.attemptCount = attemptCount;
        return this;
    }
}

