/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.WritableComparable;

public class HServerInfo
extends VersionedWritable
implements WritableComparable<HServerInfo> {
    private static final byte VERSION = 1;
    private HServerAddress serverAddress = new HServerAddress();
    private long startCode;
    private int webuiport;

    public HServerInfo() {
    }

    public HServerInfo(HServerAddress serverAddress, int webuiport) {
        this(serverAddress, System.currentTimeMillis(), webuiport);
    }

    public HServerInfo(HServerAddress serverAddress, long startCode, int webuiport) {
        this.serverAddress = serverAddress;
        this.startCode = startCode;
        this.webuiport = webuiport;
    }

    public HServerInfo(HServerInfo other) {
        this.serverAddress = new HServerAddress(other.getServerAddress());
        this.startCode = other.getStartCode();
        this.webuiport = other.getInfoPort();
    }

    public byte getVersion() {
        return 1;
    }

    public synchronized HServerAddress getServerAddress() {
        return new HServerAddress(this.serverAddress);
    }

    public synchronized long getStartCode() {
        return this.startCode;
    }

    public int getInfoPort() {
        return this.getWebuiPort();
    }

    public int getWebuiPort() {
        return this.webuiport;
    }

    public String getHostname() {
        return this.serverAddress.getHostname();
    }

    public synchronized String toString() {
        return ServerName.getServerName(this.serverAddress.getHostnameAndPort(), this.startCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HServerInfo)((Object)obj)) == 0;
    }

    public int hashCode() {
        int code = this.serverAddress.hashCode();
        code ^= this.webuiport;
        code = (int)((long)code ^ this.startCode);
        return code;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.serverAddress.readFields(in);
        this.startCode = in.readLong();
        this.webuiport = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.serverAddress.write(out);
        out.writeLong(this.startCode);
        out.writeInt(this.webuiport);
    }

    public int compareTo(HServerInfo o) {
        int compare = this.serverAddress.compareTo(o.getServerAddress());
        if (compare != 0) {
            return compare;
        }
        if (this.webuiport != o.getInfoPort()) {
            return this.webuiport - o.getInfoPort();
        }
        if (this.startCode != o.getStartCode()) {
            return (int)(this.startCode - o.getStartCode());
        }
        return 0;
    }
}

