/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PoolMap;

public class HTablePool
implements Closeable {
    private final PoolMap<String, HTableInterface> tables;
    private final int maxSize;
    private final PoolMap.PoolType poolType;
    private final Configuration config;
    private final HTableInterfaceFactory tableFactory;

    public HTablePool() {
        this(HBaseConfiguration.create(), Integer.MAX_VALUE);
    }

    public HTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null, null);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory) {
        this(config, maxSize, tableFactory, PoolMap.PoolType.Reusable);
    }

    public HTablePool(Configuration config, int maxSize, PoolMap.PoolType poolType) {
        this(config, maxSize, null, poolType);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory, PoolMap.PoolType poolType) {
        this.config = config == null ? HBaseConfiguration.create() : config;
        this.maxSize = maxSize;
        HTableInterfaceFactory hTableInterfaceFactory = this.tableFactory = tableFactory == null ? new HTableFactory() : tableFactory;
        if (poolType == null) {
            this.poolType = PoolMap.PoolType.Reusable;
        } else {
            switch (poolType) {
                case Reusable: 
                case ThreadLocal: {
                    this.poolType = poolType;
                    break;
                }
                default: {
                    this.poolType = PoolMap.PoolType.Reusable;
                }
            }
        }
        this.tables = new PoolMap(this.poolType, this.maxSize);
    }

    public HTableInterface getTable(String tableName) {
        HTableInterface table = this.findOrCreateTable(tableName);
        return new PooledHTable(table);
    }

    private HTableInterface findOrCreateTable(String tableName) {
        HTableInterface table = this.tables.get(tableName);
        if (table == null) {
            table = this.createHTable(tableName);
        }
        return table;
    }

    public HTableInterface getTable(byte[] tableName) {
        return this.getTable(Bytes.toString(tableName));
    }

    public void putTable(HTableInterface table) throws IOException {
        if (!(table instanceof PooledHTable)) {
            throw new IllegalArgumentException("not a pooled table: " + table);
        }
        this.returnTable(((PooledHTable)table).getWrappedTable());
    }

    private void returnTable(HTableInterface table) throws IOException {
        String tableName = Bytes.toString(table.getTableName());
        if (this.tables.size(tableName) >= this.maxSize) {
            this.tables.remove(tableName, table);
            this.tableFactory.releaseHTableInterface(table);
            return;
        }
        this.tables.put(tableName, table);
    }

    protected HTableInterface createHTable(String tableName) {
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes(tableName));
    }

    public void closeTablePool(String tableName) throws IOException {
        Collection<HTableInterface> tables = this.tables.values(tableName);
        if (tables != null) {
            for (HTableInterface table : tables) {
                this.tableFactory.releaseHTableInterface(table);
            }
        }
        this.tables.remove(tableName);
    }

    public void closeTablePool(byte[] tableName) throws IOException {
        this.closeTablePool(Bytes.toString(tableName));
    }

    @Override
    public void close() throws IOException {
        for (String tableName : this.tables.keySet()) {
            this.closeTablePool(tableName);
        }
        this.tables.clear();
    }

    public int getCurrentPoolSize(String tableName) {
        return this.tables.size(tableName);
    }

    class PooledHTable
    implements HTableInterface {
        private HTableInterface table;

        public PooledHTable(HTableInterface table) {
            this.table = table;
        }

        @Override
        public byte[] getTableName() {
            return this.table.getTableName();
        }

        @Override
        public Configuration getConfiguration() {
            return this.table.getConfiguration();
        }

        @Override
        public HTableDescriptor getTableDescriptor() throws IOException {
            return this.table.getTableDescriptor();
        }

        @Override
        public boolean exists(Get get2) throws IOException {
            return this.table.exists(get2);
        }

        @Override
        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
            this.table.batch(actions, results);
        }

        @Override
        public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
            return this.table.batch(actions);
        }

        @Override
        public Result get(Get get2) throws IOException {
            return this.table.get(get2);
        }

        @Override
        public Result[] get(List<Get> gets) throws IOException {
            return this.table.get(gets);
        }

        @Override
        public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
            return this.table.getRowOrBefore(row, family);
        }

        @Override
        public ResultScanner getScanner(Scan scan) throws IOException {
            return this.table.getScanner(scan);
        }

        @Override
        public ResultScanner getScanner(byte[] family) throws IOException {
            return this.table.getScanner(family);
        }

        @Override
        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
            return this.table.getScanner(family, qualifier);
        }

        @Override
        public void put(Put put2) throws IOException {
            this.table.put(put2);
        }

        @Override
        public void put(List<Put> puts) throws IOException {
            this.table.put(puts);
        }

        @Override
        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
            return this.table.checkAndPut(row, family, qualifier, value, put2);
        }

        @Override
        public void delete(Delete delete) throws IOException {
            this.table.delete(delete);
        }

        @Override
        public void delete(List<Delete> deletes) throws IOException {
            this.table.delete(deletes);
        }

        @Override
        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
            return this.table.checkAndDelete(row, family, qualifier, value, delete);
        }

        @Override
        public Result increment(Increment increment2) throws IOException {
            return this.table.increment(increment2);
        }

        @Override
        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount);
        }

        @Override
        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }

        @Override
        public boolean isAutoFlush() {
            return this.table.isAutoFlush();
        }

        @Override
        public void flushCommits() throws IOException {
            this.table.flushCommits();
        }

        @Override
        public void close() throws IOException {
            HTablePool.this.returnTable(this.table);
        }

        @Override
        public RowLock lockRow(byte[] row) throws IOException {
            return this.table.lockRow(row);
        }

        @Override
        public void unlockRow(RowLock rl) throws IOException {
            this.table.unlockRow(rl);
        }

        @Override
        public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
            return this.table.coprocessorProxy(protocol, row);
        }

        @Override
        public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
            return this.table.coprocessorExec(protocol, startKey, endKey, callable);
        }

        @Override
        public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
            this.table.coprocessorExec(protocol, startKey, endKey, callable, callback);
        }

        public String toString() {
            return "PooledHTable{, table=" + this.table + '}';
        }

        HTableInterface getWrappedTable() {
            return this.table;
        }

        @Override
        public void mutateRow(RowMutations rm) throws IOException {
            this.table.mutateRow(rm);
        }

        @Override
        public Result append(Append append) throws IOException {
            return this.table.append(append);
        }

        @Override
        public void setAutoFlush(boolean autoFlush) {
            this.table.setAutoFlush(autoFlush);
        }

        @Override
        public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
            this.table.setAutoFlush(autoFlush, clearBufferOnFail);
        }

        @Override
        public long getWriteBufferSize() {
            return this.table.getWriteBufferSize();
        }

        @Override
        public void setWriteBufferSize(long writeBufferSize) throws IOException {
            this.table.setWriteBufferSize(writeBufferSize);
        }
    }
}

