/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.get;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersRequest;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetWarmersAction
extends TransportClusterInfoAction<GetWarmersRequest, GetWarmersResponse> {
    @Inject
    public TransportGetWarmersAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "indices:admin/warmers/get", transportService, clusterService, threadPool, actionFilters);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(GetWarmersRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, state.metaData().concreteIndices(request.indicesOptions(), request.indices()));
    }

    @Override
    protected GetWarmersRequest newRequest() {
        return new GetWarmersRequest();
    }

    @Override
    protected GetWarmersResponse newResponse() {
        return new GetWarmersResponse();
    }

    @Override
    protected void doMasterOperation(GetWarmersRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetWarmersResponse> listener) throws ElasticsearchException {
        ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> result = state.metaData().findWarmers(concreteIndices, request.types(), request.warmers());
        listener.onResponse(new GetWarmersResponse(result));
    }
}

