/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParserMapper;

public class SignificantTermsHeuristicModule
extends AbstractModule {
    private List<Class<? extends SignificanceHeuristicParser>> parsers = Lists.newArrayList();

    public SignificantTermsHeuristicModule() {
        this.registerParser(JLHScore.JLHScoreParser.class);
        this.registerParser(MutualInformation.MutualInformationParser.class);
        this.registerParser(GND.GNDParser.class);
        this.registerParser(ChiSquare.ChiSquareParser.class);
    }

    public void registerParser(Class<? extends SignificanceHeuristicParser> parser) {
        this.parsers.add(parser);
    }

    @Override
    protected void configure() {
        Multibinder<SignificanceHeuristicParser> parserMapBinder = Multibinder.newSetBinder(this.binder(), SignificanceHeuristicParser.class);
        for (Class<? extends SignificanceHeuristicParser> clazz : this.parsers) {
            parserMapBinder.addBinding().to(clazz);
        }
        this.bind(SignificanceHeuristicParserMapper.class);
    }
}

