/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.util.HashMap;
import java.util.Map;
import org.vertexium.Metadata;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.Visibility;
import org.vertexium.id.NameSubstitutionStrategy;

public class LazyPropertyMetadata {
    private Map<String, Entry> entries = new HashMap<String, Entry>();

    public Metadata toMetadata(VertexiumSerializer vertexiumSerializer, NameSubstitutionStrategy nameSubstitutionStrategy) {
        Metadata metadata = new Metadata();
        for (Map.Entry<String, Entry> metadataItem : this.entries.entrySet()) {
            String metadataKey = nameSubstitutionStrategy.inflate(metadataItem.getValue().getMetadataKey());
            Visibility metadataVisibility = metadataItem.getValue().getMetadataVisibility();
            Object metadataValue = vertexiumSerializer.bytesToObject(metadataItem.getValue().getValue());
            if (metadataValue == null) {
                throw new VertexiumException("Invalid metadata found.");
            }
            metadata.add(metadataKey, metadataValue, metadataVisibility);
        }
        return metadata;
    }

    public void add(String metadataKey, Visibility metadataVisibility, byte[] value) {
        this.entries.put(metadataKey.concat(metadataVisibility.getVisibilityString()), new Entry(metadataKey, metadataVisibility, value));
    }

    private static class Entry {
        private final String metadataKey;
        private final Visibility metadataVisibility;
        private final byte[] value;

        public Entry(String metadataKey, Visibility metadataVisibility, byte[] value) {
            this.metadataKey = metadataKey;
            this.metadataVisibility = metadataVisibility;
            this.value = value;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }

        public Visibility getMetadataVisibility() {
            return this.metadataVisibility;
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

