/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.UnsynchronizedBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Mutation
implements Writable {
    static final int VALUE_SIZE_COPY_CUTOFF = 32768;
    private boolean useOldDeserialize = false;
    private byte[] row;
    private byte[] data;
    private int entries;
    private List<byte[]> values;
    private UnsynchronizedBuffer.Writer buffer;
    private List<ColumnUpdate> updates;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int cachedValLens = -1;

    private void serialize() {
        if (this.buffer != null) {
            this.data = this.buffer.toArray();
            this.buffer = null;
        }
    }

    public Mutation(byte[] row) {
        this(row, 0, row.length);
    }

    public Mutation(byte[] row, int start, int length) {
        this.row = new byte[length];
        System.arraycopy(row, start, this.row, 0, length);
        this.buffer = new UnsynchronizedBuffer.Writer();
    }

    public Mutation(Text row) {
        this(row.getBytes(), 0, row.getLength());
    }

    public Mutation(CharSequence row) {
        this(new Text(row.toString()));
    }

    public Mutation() {
    }

    public Mutation(TMutation tmutation) {
        this.row = ByteBufferUtil.toBytes(tmutation.row);
        this.data = ByteBufferUtil.toBytes(tmutation.data);
        this.entries = tmutation.entries;
        this.values = ByteBufferUtil.toBytesList(tmutation.values);
        if (this.row == null) {
            throw new IllegalArgumentException("null row");
        }
        if (this.data == null) {
            throw new IllegalArgumentException("null serialized data");
        }
    }

    public Mutation(Mutation m) {
        m.serialize();
        this.row = m.row;
        this.data = m.data;
        this.entries = m.entries;
        this.values = m.values;
    }

    public byte[] getRow() {
        return this.row;
    }

    private void put(byte[] b) {
        this.put(b, b.length);
    }

    private void put(byte[] b, int length) {
        this.buffer.writeVLong(length);
        this.buffer.add(b, 0, length);
    }

    private void put(boolean b) {
        this.buffer.add(b);
    }

    private void put(int i) {
        this.buffer.writeVLong(i);
    }

    private void put(long l) {
        this.buffer.writeVLong(l);
    }

    private void put(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(cf, cf.length, cq, cq.length, cv, hasts, ts, deleted, val, val.length);
    }

    private void put(Text cf, Text cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(cf.getBytes(), cf.getLength(), cq.getBytes(), cq.getLength(), cv, hasts, ts, deleted, val, val.length);
    }

    private void put(byte[] cf, int cfLength, byte[] cq, int cqLength, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val, int valLength) {
        if (this.buffer == null) {
            throw new IllegalStateException("Can not add to mutation after serializing it");
        }
        this.put(cf, cfLength);
        this.put(cq, cqLength);
        this.put(cv);
        this.put(hasts);
        if (hasts) {
            this.put(ts);
        }
        this.put(deleted);
        if (valLength < 32768) {
            this.put(val, valLength);
        } else {
            if (this.values == null) {
                this.values = new ArrayList<byte[]>();
            }
            byte[] copy = new byte[valLength];
            System.arraycopy(val, 0, copy, 0, valLength);
            this.values.add(copy);
            this.put(-1 * this.values.size());
        }
        ++this.entries;
    }

    private void put(CharSequence cf, CharSequence cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        this.put(new Text(cf.toString()), new Text(cq.toString()), cv, hasts, ts, deleted, val);
    }

    private void put(Text cf, Text cq, byte[] cv, boolean hasts, long ts, boolean deleted, Text val) {
        this.put(cf.getBytes(), cf.getLength(), cq.getBytes(), cq.getLength(), cv, hasts, ts, deleted, val.getBytes(), val.getLength());
    }

    private void put(CharSequence cf, CharSequence cq, byte[] cv, boolean hasts, long ts, boolean deleted, CharSequence val) {
        this.put(new Text(cf.toString()), new Text(cq.toString()), cv, hasts, ts, deleted, new Text(val.toString()));
    }

    public void put(Text columnFamily, Text columnQualifier, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value.get());
    }

    public void put(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value.get());
    }

    public void putDelete(Text columnFamily, Text columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(Text columnFamily, Text columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value.get());
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp, Value value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value.get());
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, CharSequence value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, CharSequence value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, long timestamp, CharSequence value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value);
    }

    public void put(CharSequence columnFamily, CharSequence columnQualifier, ColumnVisibility columnVisibility, long timestamp, CharSequence value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, false, value);
    }

    public void put(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, long timestamp, byte[] value) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, false, value);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), false, 0L, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, long timestamp) {
        this.put(columnFamily, columnQualifier, EMPTY_BYTES, true, timestamp, true, EMPTY_BYTES);
    }

    public void putDelete(byte[] columnFamily, byte[] columnQualifier, ColumnVisibility columnVisibility, long timestamp) {
        this.put(columnFamily, columnQualifier, columnVisibility.getExpression(), true, timestamp, true, EMPTY_BYTES);
    }

    private byte[] oldReadBytes(UnsynchronizedBuffer.Reader in) {
        int len = in.readInt();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    private byte[] readBytes(UnsynchronizedBuffer.Reader in) {
        int len = (int)in.readVLong();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    public List<ColumnUpdate> getUpdates() {
        this.serialize();
        UnsynchronizedBuffer.Reader in = new UnsynchronizedBuffer.Reader(this.data);
        if (this.updates == null) {
            if (this.entries == 1) {
                this.updates = Collections.singletonList(this.deserializeColumnUpdate(in));
            } else {
                ColumnUpdate[] tmpUpdates = new ColumnUpdate[this.entries];
                for (int i = 0; i < this.entries; ++i) {
                    tmpUpdates[i] = this.deserializeColumnUpdate(in);
                }
                this.updates = Arrays.asList(tmpUpdates);
            }
        }
        return this.updates;
    }

    protected ColumnUpdate newColumnUpdate(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        return new ColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    private ColumnUpdate deserializeColumnUpdate(UnsynchronizedBuffer.Reader in) {
        byte[] val;
        byte[] cf = this.readBytes(in);
        byte[] cq = this.readBytes(in);
        byte[] cv = this.readBytes(in);
        boolean hasts = in.readBoolean();
        long ts = 0L;
        if (hasts) {
            ts = in.readVLong();
        }
        boolean deleted = in.readBoolean();
        int valLen = (int)in.readVLong();
        if (valLen < 0) {
            val = this.values.get(-1 * valLen - 1);
        } else if (valLen == 0) {
            val = EMPTY_BYTES;
        } else {
            val = new byte[valLen];
            in.readBytes(val);
        }
        return this.newColumnUpdate(cf, cq, cv, hasts, ts, deleted, val);
    }

    long getValueLengths() {
        if (this.values == null) {
            return 0L;
        }
        if (this.cachedValLens == -1) {
            int tmpCVL = 0;
            for (byte[] val : this.values) {
                tmpCVL += val.length;
            }
            this.cachedValLens = tmpCVL;
        }
        return this.cachedValLens;
    }

    public long numBytes() {
        this.serialize();
        return (long)(this.row.length + this.data.length) + this.getValueLengths();
    }

    public long estimatedMemoryUsed() {
        return this.numBytes() + 238L;
    }

    public int size() {
        return this.entries;
    }

    public void readFields(DataInput in) throws IOException {
        boolean valuesPresent;
        this.updates = null;
        this.cachedValLens = -1;
        this.buffer = null;
        this.useOldDeserialize = false;
        byte first = in.readByte();
        if ((first & 0x80) != 128) {
            this.oldReadFields(first, in);
            this.useOldDeserialize = true;
            return;
        }
        int len = WritableUtils.readVInt((DataInput)in);
        this.row = new byte[len];
        in.readFully(this.row);
        len = WritableUtils.readVInt((DataInput)in);
        this.data = new byte[len];
        in.readFully(this.data);
        this.entries = WritableUtils.readVInt((DataInput)in);
        boolean bl = valuesPresent = (first & 1) == 1;
        if (!valuesPresent) {
            this.values = null;
        } else {
            this.values = new ArrayList<byte[]>();
            int numValues = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < numValues; ++i) {
                len = WritableUtils.readVInt((DataInput)in);
                byte[] val = new byte[len];
                in.readFully(val);
                this.values.add(val);
            }
        }
    }

    protected void droppingOldTimestamp(long ts) {
    }

    private void oldReadFields(byte first, DataInput in) throws IOException {
        int i;
        ArrayList<byte[]> localValues;
        byte b = in.readByte();
        byte c = in.readByte();
        byte d = in.readByte();
        int len = (first & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
        this.row = new byte[len];
        in.readFully(this.row);
        len = in.readInt();
        byte[] localData = new byte[len];
        in.readFully(localData);
        int localEntries = in.readInt();
        boolean valuesPresent = in.readBoolean();
        if (!valuesPresent) {
            localValues = null;
        } else {
            localValues = new ArrayList<byte[]>();
            int numValues = in.readInt();
            for (i = 0; i < numValues; ++i) {
                len = in.readInt();
                byte[] val = new byte[len];
                in.readFully(val);
                localValues.add(val);
            }
        }
        UnsynchronizedBuffer.Reader din = new UnsynchronizedBuffer.Reader(localData);
        this.buffer = new UnsynchronizedBuffer.Writer();
        for (i = 0; i < localEntries; ++i) {
            byte[] val;
            byte[] cf = this.oldReadBytes(din);
            byte[] cq = this.oldReadBytes(din);
            byte[] cv = this.oldReadBytes(din);
            boolean hasts = din.readBoolean();
            long ts = din.readLong();
            boolean deleted = din.readBoolean();
            int valLen = din.readInt();
            if (valLen < 0) {
                val = (byte[])localValues.get(-1 * valLen - 1);
            } else if (valLen == 0) {
                val = EMPTY_BYTES;
            } else {
                val = new byte[valLen];
                din.readBytes(val);
            }
            this.put(cf, cq, cv, hasts, ts, deleted, val);
            if (hasts) continue;
            this.droppingOldTimestamp(ts);
        }
        this.serialize();
    }

    public void write(DataOutput out) throws IOException {
        this.serialize();
        int hasValues = this.values == null ? 0 : 1;
        out.write((byte)(0x80 | hasValues));
        WritableUtils.writeVInt((DataOutput)out, (int)this.row.length);
        out.write(this.row);
        WritableUtils.writeVInt((DataOutput)out, (int)this.data.length);
        out.write(this.data);
        WritableUtils.writeVInt((DataOutput)out, (int)this.entries);
        if (hasValues > 0) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                byte[] val = this.values.get(i);
                WritableUtils.writeVInt((DataOutput)out, (int)val.length);
                out.write(val);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass().equals(this.getClass())) {
            return this.equalMutation((Mutation)o);
        }
        return false;
    }

    public int hashCode() {
        return this.toThrift().hashCode();
    }

    public boolean equals(Mutation m) {
        return this.equals((Object)m);
    }

    private boolean equalMutation(Mutation m) {
        this.serialize();
        m.serialize();
        if (Arrays.equals(this.row, m.row) && this.entries == m.entries && Arrays.equals(this.data, m.data)) {
            if (this.values == null && m.values == null) {
                return true;
            }
            if (this.values != null && m.values != null && this.values.size() == m.values.size()) {
                for (int i = 0; i < this.values.size(); ++i) {
                    if (Arrays.equals(this.values.get(i), m.values.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public TMutation toThrift() {
        this.serialize();
        return new TMutation(ByteBuffer.wrap(this.row), ByteBuffer.wrap(this.data), ByteBufferUtil.toByteBuffers(this.values), this.entries);
    }

    protected SERIALIZED_FORMAT getSerializedFormat() {
        return this.useOldDeserialize ? SERIALIZED_FORMAT.VERSION1 : SERIALIZED_FORMAT.VERSION2;
    }

    public static enum SERIALIZED_FORMAT {
        VERSION1,
        VERSION2;

    }
}

