/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.ScanState;
import org.apache.accumulo.core.tabletserver.thrift.ScanType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ActiveScan
implements TBase<ActiveScan, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ActiveScan");
    private static final TField CLIENT_FIELD_DESC = new TField("client", 11, 2);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 3);
    private static final TField TABLE_ID_FIELD_DESC = new TField("tableId", 11, 4);
    private static final TField AGE_FIELD_DESC = new TField("age", 10, 5);
    private static final TField IDLE_TIME_FIELD_DESC = new TField("idleTime", 10, 6);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 7);
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 8);
    private static final TField EXTENT_FIELD_DESC = new TField("extent", 12, 9);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 10);
    private static final TField SSI_LIST_FIELD_DESC = new TField("ssiList", 15, 11);
    private static final TField SSIO_FIELD_DESC = new TField("ssio", 13, 12);
    private static final TField AUTHORIZATIONS_FIELD_DESC = new TField("authorizations", 15, 13);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String client;
    public String user;
    public String tableId;
    public long age;
    public long idleTime;
    public ScanType type;
    public ScanState state;
    public TKeyExtent extent;
    public List<TColumn> columns;
    public List<IterInfo> ssiList;
    public Map<String, Map<String, String>> ssio;
    public List<ByteBuffer> authorizations;
    private static final int __AGE_ISSET_ID = 0;
    private static final int __IDLETIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ActiveScan() {
    }

    public ActiveScan(String client, String user, String tableId, long age, long idleTime, ScanType type, ScanState state, TKeyExtent extent, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) {
        this();
        this.client = client;
        this.user = user;
        this.tableId = tableId;
        this.age = age;
        this.setAgeIsSet(true);
        this.idleTime = idleTime;
        this.setIdleTimeIsSet(true);
        this.type = type;
        this.state = state;
        this.extent = extent;
        this.columns = columns;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.authorizations = authorizations;
    }

    public ActiveScan(ActiveScan other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetClient()) {
            this.client = other.client;
        }
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetTableId()) {
            this.tableId = other.tableId;
        }
        this.age = other.age;
        this.idleTime = other.idleTime;
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetState()) {
            this.state = other.state;
        }
        if (other.isSetExtent()) {
            this.extent = new TKeyExtent(other.extent);
        }
        if (other.isSetColumns()) {
            ArrayList<TColumn> __this__columns = new ArrayList<TColumn>();
            for (TColumn tColumn : other.columns) {
                __this__columns.add(new TColumn(tColumn));
            }
            this.columns = __this__columns;
        }
        if (other.isSetSsiList()) {
            ArrayList<IterInfo> __this__ssiList = new ArrayList<IterInfo>();
            for (IterInfo iterInfo : other.ssiList) {
                __this__ssiList.add(new IterInfo(iterInfo));
            }
            this.ssiList = __this__ssiList;
        }
        if (other.isSetSsio()) {
            HashMap<String, Map<String, String>> __this__ssio = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : other.ssio.entrySet()) {
                String other_element_key = (String)entry.getKey();
                Map other_element_value = (Map)entry.getValue();
                String __this__ssio_copy_key = other_element_key;
                HashMap<String, String> __this__ssio_copy_value = new HashMap<String, String>();
                for (Map.Entry other_element_value_element : other_element_value.entrySet()) {
                    String other_element_value_element_key = (String)other_element_value_element.getKey();
                    String other_element_value_element_value = (String)other_element_value_element.getValue();
                    String __this__ssio_copy_value_copy_key = other_element_value_element_key;
                    String __this__ssio_copy_value_copy_value = other_element_value_element_value;
                    __this__ssio_copy_value.put(__this__ssio_copy_value_copy_key, __this__ssio_copy_value_copy_value);
                }
                __this__ssio.put(__this__ssio_copy_key, __this__ssio_copy_value);
            }
            this.ssio = __this__ssio;
        }
        if (other.isSetAuthorizations()) {
            ArrayList<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>();
            for (ByteBuffer byteBuffer : other.authorizations) {
                ByteBuffer temp_binary_element = TBaseHelper.copyBinary((ByteBuffer)byteBuffer);
                __this__authorizations.add(temp_binary_element);
            }
            this.authorizations = __this__authorizations;
        }
    }

    public ActiveScan deepCopy() {
        return new ActiveScan(this);
    }

    public void clear() {
        this.client = null;
        this.user = null;
        this.tableId = null;
        this.setAgeIsSet(false);
        this.age = 0L;
        this.setIdleTimeIsSet(false);
        this.idleTime = 0L;
        this.type = null;
        this.state = null;
        this.extent = null;
        this.columns = null;
        this.ssiList = null;
        this.ssio = null;
        this.authorizations = null;
    }

    public String getClient() {
        return this.client;
    }

    public ActiveScan setClient(String client) {
        this.client = client;
        return this;
    }

    public void unsetClient() {
        this.client = null;
    }

    public boolean isSetClient() {
        return this.client != null;
    }

    public void setClientIsSet(boolean value) {
        if (!value) {
            this.client = null;
        }
    }

    public String getUser() {
        return this.user;
    }

    public ActiveScan setUser(String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public ActiveScan setTableId(String tableId) {
        this.tableId = tableId;
        return this;
    }

    public void unsetTableId() {
        this.tableId = null;
    }

    public boolean isSetTableId() {
        return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
        if (!value) {
            this.tableId = null;
        }
    }

    public long getAge() {
        return this.age;
    }

    public ActiveScan setAge(long age) {
        this.age = age;
        this.setAgeIsSet(true);
        return this;
    }

    public void unsetAge() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetAge() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setAgeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public ActiveScan setIdleTime(long idleTime) {
        this.idleTime = idleTime;
        this.setIdleTimeIsSet(true);
        return this;
    }

    public void unsetIdleTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetIdleTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIdleTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public ScanType getType() {
        return this.type;
    }

    public ActiveScan setType(ScanType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public ScanState getState() {
        return this.state;
    }

    public ActiveScan setState(ScanState state) {
        this.state = state;
        return this;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    public TKeyExtent getExtent() {
        return this.extent;
    }

    public ActiveScan setExtent(TKeyExtent extent) {
        this.extent = extent;
        return this;
    }

    public void unsetExtent() {
        this.extent = null;
    }

    public boolean isSetExtent() {
        return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
        if (!value) {
            this.extent = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<TColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumn>();
        }
        this.columns.add(elem);
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public ActiveScan setColumns(List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getSsiListSize() {
        return this.ssiList == null ? 0 : this.ssiList.size();
    }

    public Iterator<IterInfo> getSsiListIterator() {
        return this.ssiList == null ? null : this.ssiList.iterator();
    }

    public void addToSsiList(IterInfo elem) {
        if (this.ssiList == null) {
            this.ssiList = new ArrayList<IterInfo>();
        }
        this.ssiList.add(elem);
    }

    public List<IterInfo> getSsiList() {
        return this.ssiList;
    }

    public ActiveScan setSsiList(List<IterInfo> ssiList) {
        this.ssiList = ssiList;
        return this;
    }

    public void unsetSsiList() {
        this.ssiList = null;
    }

    public boolean isSetSsiList() {
        return this.ssiList != null;
    }

    public void setSsiListIsSet(boolean value) {
        if (!value) {
            this.ssiList = null;
        }
    }

    public int getSsioSize() {
        return this.ssio == null ? 0 : this.ssio.size();
    }

    public void putToSsio(String key, Map<String, String> val) {
        if (this.ssio == null) {
            this.ssio = new HashMap<String, Map<String, String>>();
        }
        this.ssio.put(key, val);
    }

    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    public ActiveScan setSsio(Map<String, Map<String, String>> ssio) {
        this.ssio = ssio;
        return this;
    }

    public void unsetSsio() {
        this.ssio = null;
    }

    public boolean isSetSsio() {
        return this.ssio != null;
    }

    public void setSsioIsSet(boolean value) {
        if (!value) {
            this.ssio = null;
        }
    }

    public int getAuthorizationsSize() {
        return this.authorizations == null ? 0 : this.authorizations.size();
    }

    public Iterator<ByteBuffer> getAuthorizationsIterator() {
        return this.authorizations == null ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ByteBuffer>();
        }
        this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
        return this.authorizations;
    }

    public ActiveScan setAuthorizations(List<ByteBuffer> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public void unsetAuthorizations() {
        this.authorizations = null;
    }

    public boolean isSetAuthorizations() {
        return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
        if (!value) {
            this.authorizations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CLIENT: {
                if (value == null) {
                    this.unsetClient();
                    break;
                }
                this.setClient((String)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case TABLE_ID: {
                if (value == null) {
                    this.unsetTableId();
                    break;
                }
                this.setTableId((String)value);
                break;
            }
            case AGE: {
                if (value == null) {
                    this.unsetAge();
                    break;
                }
                this.setAge((Long)value);
                break;
            }
            case IDLE_TIME: {
                if (value == null) {
                    this.unsetIdleTime();
                    break;
                }
                this.setIdleTime((Long)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((ScanType)((Object)value));
                break;
            }
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((ScanState)((Object)value));
                break;
            }
            case EXTENT: {
                if (value == null) {
                    this.unsetExtent();
                    break;
                }
                this.setExtent((TKeyExtent)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case SSI_LIST: {
                if (value == null) {
                    this.unsetSsiList();
                    break;
                }
                this.setSsiList((List)value);
                break;
            }
            case SSIO: {
                if (value == null) {
                    this.unsetSsio();
                    break;
                }
                this.setSsio((Map)value);
                break;
            }
            case AUTHORIZATIONS: {
                if (value == null) {
                    this.unsetAuthorizations();
                    break;
                }
                this.setAuthorizations((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CLIENT: {
                return this.getClient();
            }
            case USER: {
                return this.getUser();
            }
            case TABLE_ID: {
                return this.getTableId();
            }
            case AGE: {
                return this.getAge();
            }
            case IDLE_TIME: {
                return this.getIdleTime();
            }
            case TYPE: {
                return this.getType();
            }
            case STATE: {
                return this.getState();
            }
            case EXTENT: {
                return this.getExtent();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case SSI_LIST: {
                return this.getSsiList();
            }
            case SSIO: {
                return this.getSsio();
            }
            case AUTHORIZATIONS: {
                return this.getAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CLIENT: {
                return this.isSetClient();
            }
            case USER: {
                return this.isSetUser();
            }
            case TABLE_ID: {
                return this.isSetTableId();
            }
            case AGE: {
                return this.isSetAge();
            }
            case IDLE_TIME: {
                return this.isSetIdleTime();
            }
            case TYPE: {
                return this.isSetType();
            }
            case STATE: {
                return this.isSetState();
            }
            case EXTENT: {
                return this.isSetExtent();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case SSI_LIST: {
                return this.isSetSsiList();
            }
            case SSIO: {
                return this.isSetSsio();
            }
            case AUTHORIZATIONS: {
                return this.isSetAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ActiveScan) {
            return this.equals((ActiveScan)that);
        }
        return false;
    }

    public boolean equals(ActiveScan that) {
        if (that == null) {
            return false;
        }
        boolean this_present_client = this.isSetClient();
        boolean that_present_client = that.isSetClient();
        if (this_present_client || that_present_client) {
            if (!this_present_client || !that_present_client) {
                return false;
            }
            if (!this.client.equals(that.client)) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_tableId = this.isSetTableId();
        boolean that_present_tableId = that.isSetTableId();
        if (this_present_tableId || that_present_tableId) {
            if (!this_present_tableId || !that_present_tableId) {
                return false;
            }
            if (!this.tableId.equals(that.tableId)) {
                return false;
            }
        }
        boolean this_present_age = true;
        boolean that_present_age = true;
        if (this_present_age || that_present_age) {
            if (!this_present_age || !that_present_age) {
                return false;
            }
            if (this.age != that.age) {
                return false;
            }
        }
        boolean this_present_idleTime = true;
        boolean that_present_idleTime = true;
        if (this_present_idleTime || that_present_idleTime) {
            if (!this_present_idleTime || !that_present_idleTime) {
                return false;
            }
            if (this.idleTime != that.idleTime) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals((Object)that.state)) {
                return false;
            }
        }
        boolean this_present_extent = this.isSetExtent();
        boolean that_present_extent = that.isSetExtent();
        if (this_present_extent || that_present_extent) {
            if (!this_present_extent || !that_present_extent) {
                return false;
            }
            if (!this.extent.equals(that.extent)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_ssiList = this.isSetSsiList();
        boolean that_present_ssiList = that.isSetSsiList();
        if (this_present_ssiList || that_present_ssiList) {
            if (!this_present_ssiList || !that_present_ssiList) {
                return false;
            }
            if (!this.ssiList.equals(that.ssiList)) {
                return false;
            }
        }
        boolean this_present_ssio = this.isSetSsio();
        boolean that_present_ssio = that.isSetSsio();
        if (this_present_ssio || that_present_ssio) {
            if (!this_present_ssio || !that_present_ssio) {
                return false;
            }
            if (!this.ssio.equals(that.ssio)) {
                return false;
            }
        }
        boolean this_present_authorizations = this.isSetAuthorizations();
        boolean that_present_authorizations = that.isSetAuthorizations();
        if (this_present_authorizations || that_present_authorizations) {
            if (!this_present_authorizations || !that_present_authorizations) {
                return false;
            }
            if (!this.authorizations.equals(that.authorizations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(ActiveScan other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        ActiveScan typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetClient()).compareTo(typedOther.isSetClient());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetClient() && (lastComparison = TBaseHelper.compareTo((String)this.client, (String)typedOther.client)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUser()).compareTo(typedOther.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)typedOther.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableId()).compareTo(typedOther.isSetTableId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableId() && (lastComparison = TBaseHelper.compareTo((String)this.tableId, (String)typedOther.tableId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAge()).compareTo(typedOther.isSetAge());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAge() && (lastComparison = TBaseHelper.compareTo((long)this.age, (long)typedOther.age)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIdleTime()).compareTo(typedOther.isSetIdleTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIdleTime() && (lastComparison = TBaseHelper.compareTo((long)this.idleTime, (long)typedOther.idleTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(typedOther.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)typedOther.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(typedOther.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)typedOther.state))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExtent()).compareTo(typedOther.isSetExtent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExtent() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.extent), (Comparable)((Object)typedOther.extent))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSsiList()).compareTo(typedOther.isSetSsiList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSsiList() && (lastComparison = TBaseHelper.compareTo(this.ssiList, typedOther.ssiList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSsio()).compareTo(typedOther.isSetSsio());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSsio() && (lastComparison = TBaseHelper.compareTo(this.ssio, typedOther.ssio)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAuthorizations()).compareTo(typedOther.isSetAuthorizations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizations() && (lastComparison = TBaseHelper.compareTo(this.authorizations, typedOther.authorizations)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActiveScan(");
        boolean first = true;
        sb.append("client:");
        if (this.client == null) {
            sb.append("null");
        } else {
            sb.append(this.client);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("user:");
        if (this.user == null) {
            sb.append("null");
        } else {
            sb.append(this.user);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableId:");
        if (this.tableId == null) {
            sb.append("null");
        } else {
            sb.append(this.tableId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("age:");
        sb.append(this.age);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("idleTime:");
        sb.append(this.idleTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("state:");
        if (this.state == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.state);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("extent:");
        if (this.extent == null) {
            sb.append("null");
        } else {
            sb.append(this.extent);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ssiList:");
        if (this.ssiList == null) {
            sb.append("null");
        } else {
            sb.append(this.ssiList);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ssio:");
        if (this.ssio == null) {
            sb.append("null");
        } else {
            sb.append(this.ssio);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("authorizations:");
        if (this.authorizations == null) {
            sb.append("null");
        } else {
            sb.append(this.authorizations);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.extent != null) {
            this.extent.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ActiveScanStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ActiveScanTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CLIENT, new FieldMetaData("client", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_ID, new FieldMetaData("tableId", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.AGE, new FieldMetaData("age", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IDLE_TIME, new FieldMetaData("idleTime", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 3, (FieldValueMetaData)new EnumMetaData(16, ScanType.class)));
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 3, (FieldValueMetaData)new EnumMetaData(16, ScanState.class)));
        tmpMap.put(_Fields.EXTENT, new FieldMetaData("extent", 3, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumn.class))));
        tmpMap.put(_Fields.SSI_LIST, new FieldMetaData("ssiList", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IterInfo.class))));
        tmpMap.put(_Fields.SSIO, new FieldMetaData("ssio", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11)))));
        tmpMap.put(_Fields.AUTHORIZATIONS, new FieldMetaData("authorizations", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, true))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ActiveScan.class, metaDataMap);
    }

    private static class ActiveScanTupleScheme
    extends TupleScheme<ActiveScan> {
        private ActiveScanTupleScheme() {
        }

        public void write(TProtocol prot, ActiveScan struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetClient()) {
                optionals.set(0);
            }
            if (struct.isSetUser()) {
                optionals.set(1);
            }
            if (struct.isSetTableId()) {
                optionals.set(2);
            }
            if (struct.isSetAge()) {
                optionals.set(3);
            }
            if (struct.isSetIdleTime()) {
                optionals.set(4);
            }
            if (struct.isSetType()) {
                optionals.set(5);
            }
            if (struct.isSetState()) {
                optionals.set(6);
            }
            if (struct.isSetExtent()) {
                optionals.set(7);
            }
            if (struct.isSetColumns()) {
                optionals.set(8);
            }
            if (struct.isSetSsiList()) {
                optionals.set(9);
            }
            if (struct.isSetSsio()) {
                optionals.set(10);
            }
            if (struct.isSetAuthorizations()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetClient()) {
                oprot.writeString(struct.client);
            }
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetTableId()) {
                oprot.writeString(struct.tableId);
            }
            if (struct.isSetAge()) {
                oprot.writeI64(struct.age);
            }
            if (struct.isSetIdleTime()) {
                oprot.writeI64(struct.idleTime);
            }
            if (struct.isSetType()) {
                oprot.writeI32(struct.type.getValue());
            }
            if (struct.isSetState()) {
                oprot.writeI32(struct.state.getValue());
            }
            if (struct.isSetExtent()) {
                struct.extent.write((TProtocol)oprot);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (TColumn tColumn : struct.columns) {
                    tColumn.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSsiList()) {
                oprot.writeI32(struct.ssiList.size());
                for (IterInfo iterInfo : struct.ssiList) {
                    iterInfo.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSsio()) {
                oprot.writeI32(struct.ssio.size());
                for (Map.Entry entry : struct.ssio.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeI32(((Map)entry.getValue()).size());
                    for (Map.Entry _iter33 : ((Map)entry.getValue()).entrySet()) {
                        oprot.writeString((String)_iter33.getKey());
                        oprot.writeString((String)_iter33.getValue());
                    }
                }
            }
            if (struct.isSetAuthorizations()) {
                oprot.writeI32(struct.authorizations.size());
                for (ByteBuffer byteBuffer : struct.authorizations) {
                    oprot.writeBinary(byteBuffer);
                }
            }
        }

        public void read(TProtocol prot, ActiveScan struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.client = iprot.readString();
                struct.setClientIsSet(true);
            }
            if (incoming.get(1)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(2)) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
            }
            if (incoming.get(3)) {
                struct.age = iprot.readI64();
                struct.setAgeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.idleTime = iprot.readI64();
                struct.setIdleTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.type = ScanType.findByValue(iprot.readI32());
                struct.setTypeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.state = ScanState.findByValue(iprot.readI32());
                struct.setStateIsSet(true);
            }
            if (incoming.get(7)) {
                struct.extent = new TKeyExtent();
                struct.extent.read((TProtocol)iprot);
                struct.setExtentIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list35 = new TList(12, iprot.readI32());
                struct.columns = new ArrayList<TColumn>(_list35.size);
                for (int _i36 = 0; _i36 < _list35.size; ++_i36) {
                    TColumn _elem37 = new TColumn();
                    _elem37.read((TProtocol)iprot);
                    struct.columns.add(_elem37);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(9)) {
                TList _list38 = new TList(12, iprot.readI32());
                struct.ssiList = new ArrayList<IterInfo>(_list38.size);
                for (int _i39 = 0; _i39 < _list38.size; ++_i39) {
                    IterInfo _elem40 = new IterInfo();
                    _elem40.read((TProtocol)iprot);
                    struct.ssiList.add(_elem40);
                }
                struct.setSsiListIsSet(true);
            }
            if (incoming.get(10)) {
                TMap _map41 = new TMap(11, 13, iprot.readI32());
                struct.ssio = new HashMap<String, Map<String, String>>(2 * _map41.size);
                for (int _i42 = 0; _i42 < _map41.size; ++_i42) {
                    String _key43 = iprot.readString();
                    TMap _map45 = new TMap(11, 11, iprot.readI32());
                    HashMap<String, String> _val44 = new HashMap<String, String>(2 * _map45.size);
                    for (int _i46 = 0; _i46 < _map45.size; ++_i46) {
                        String _key47 = iprot.readString();
                        String _val48 = iprot.readString();
                        _val44.put(_key47, _val48);
                    }
                    struct.ssio.put(_key43, _val44);
                }
                struct.setSsioIsSet(true);
            }
            if (incoming.get(11)) {
                TList _list49 = new TList(11, iprot.readI32());
                struct.authorizations = new ArrayList<ByteBuffer>(_list49.size);
                for (int _i50 = 0; _i50 < _list49.size; ++_i50) {
                    ByteBuffer _elem51 = iprot.readBinary();
                    struct.authorizations.add(_elem51);
                }
                struct.setAuthorizationsIsSet(true);
            }
        }
    }

    private static class ActiveScanTupleSchemeFactory
    implements SchemeFactory {
        private ActiveScanTupleSchemeFactory() {
        }

        public ActiveScanTupleScheme getScheme() {
            return new ActiveScanTupleScheme();
        }
    }

    private static class ActiveScanStandardScheme
    extends StandardScheme<ActiveScan> {
        private ActiveScanStandardScheme() {
        }

        public void read(TProtocol iprot, ActiveScan struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.client = iprot.readString();
                            struct.setClientIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.tableId = iprot.readString();
                            struct.setTableIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.age = iprot.readI64();
                            struct.setAgeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.idleTime = iprot.readI64();
                            struct.setIdleTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.type = ScanType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.state = ScanState.findByValue(iprot.readI32());
                            struct.setStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.extent = new TKeyExtent();
                            struct.extent.read(iprot);
                            struct.setExtentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list8 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumn>(_list8.size);
                            for (int _i9 = 0; _i9 < _list8.size; ++_i9) {
                                TColumn _elem10 = new TColumn();
                                _elem10.read(iprot);
                                struct.columns.add(_elem10);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 15) {
                            TList _list11 = iprot.readListBegin();
                            struct.ssiList = new ArrayList<IterInfo>(_list11.size);
                            for (int _i12 = 0; _i12 < _list11.size; ++_i12) {
                                IterInfo _elem13 = new IterInfo();
                                _elem13.read(iprot);
                                struct.ssiList.add(_elem13);
                            }
                            iprot.readListEnd();
                            struct.setSsiListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 13) {
                            TMap _map14 = iprot.readMapBegin();
                            struct.ssio = new HashMap<String, Map<String, String>>(2 * _map14.size);
                            for (int _i15 = 0; _i15 < _map14.size; ++_i15) {
                                String _key16 = iprot.readString();
                                TMap _map18 = iprot.readMapBegin();
                                HashMap<String, String> _val17 = new HashMap<String, String>(2 * _map18.size);
                                for (int _i19 = 0; _i19 < _map18.size; ++_i19) {
                                    String _key20 = iprot.readString();
                                    String _val21 = iprot.readString();
                                    _val17.put(_key20, _val21);
                                }
                                iprot.readMapEnd();
                                struct.ssio.put(_key16, _val17);
                            }
                            iprot.readMapEnd();
                            struct.setSsioIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 15) {
                            TList _list22 = iprot.readListBegin();
                            struct.authorizations = new ArrayList<ByteBuffer>(_list22.size);
                            for (int _i23 = 0; _i23 < _list22.size; ++_i23) {
                                ByteBuffer _elem24 = iprot.readBinary();
                                struct.authorizations.add(_elem24);
                            }
                            iprot.readListEnd();
                            struct.setAuthorizationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ActiveScan struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.client != null) {
                oprot.writeFieldBegin(CLIENT_FIELD_DESC);
                oprot.writeString(struct.client);
                oprot.writeFieldEnd();
            }
            if (struct.user != null) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.tableId != null) {
                oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
                oprot.writeString(struct.tableId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AGE_FIELD_DESC);
            oprot.writeI64(struct.age);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(IDLE_TIME_FIELD_DESC);
            oprot.writeI64(struct.idleTime);
            oprot.writeFieldEnd();
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.state != null) {
                oprot.writeFieldBegin(STATE_FIELD_DESC);
                oprot.writeI32(struct.state.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.extent != null) {
                oprot.writeFieldBegin(EXTENT_FIELD_DESC);
                struct.extent.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumn tColumn : struct.columns) {
                    tColumn.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.ssiList != null) {
                oprot.writeFieldBegin(SSI_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.ssiList.size()));
                for (IterInfo iterInfo : struct.ssiList) {
                    iterInfo.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.ssio != null) {
                oprot.writeFieldBegin(SSIO_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 13, struct.ssio.size()));
                for (Map.Entry entry : struct.ssio.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeMapBegin(new TMap(11, 11, ((Map)entry.getValue()).size()));
                    for (Map.Entry _iter28 : ((Map)entry.getValue()).entrySet()) {
                        oprot.writeString((String)_iter28.getKey());
                        oprot.writeString((String)_iter28.getValue());
                    }
                    oprot.writeMapEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.authorizations != null) {
                oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.authorizations.size()));
                for (ByteBuffer byteBuffer : struct.authorizations) {
                    oprot.writeBinary(byteBuffer);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ActiveScanStandardSchemeFactory
    implements SchemeFactory {
        private ActiveScanStandardSchemeFactory() {
        }

        public ActiveScanStandardScheme getScheme() {
            return new ActiveScanStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CLIENT(2, "client"),
        USER(3, "user"),
        TABLE_ID(4, "tableId"),
        AGE(5, "age"),
        IDLE_TIME(6, "idleTime"),
        TYPE(7, "type"),
        STATE(8, "state"),
        EXTENT(9, "extent"),
        COLUMNS(10, "columns"),
        SSI_LIST(11, "ssiList"),
        SSIO(12, "ssio"),
        AUTHORIZATIONS(13, "authorizations");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 2: {
                    return CLIENT;
                }
                case 3: {
                    return USER;
                }
                case 4: {
                    return TABLE_ID;
                }
                case 5: {
                    return AGE;
                }
                case 6: {
                    return IDLE_TIME;
                }
                case 7: {
                    return TYPE;
                }
                case 8: {
                    return STATE;
                }
                case 9: {
                    return EXTENT;
                }
                case 10: {
                    return COLUMNS;
                }
                case 11: {
                    return SSI_LIST;
                }
                case 12: {
                    return SSIO;
                }
                case 13: {
                    return AUTHORIZATIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

