/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mrunit.MapDriverBase;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.mapred.MockReporter;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.ReflectionUtils;

public class MapDriver<K1, V1, K2, V2>
extends MapDriverBase<K1, V1, K2, V2, MapDriver<K1, V1, K2, V2>> {
    public static final Log LOG = LogFactory.getLog(MapDriver.class);
    private Mapper<K1, V1, K2, V2> myMapper;
    private Counters counters;
    private final MockOutputCreator<K2, V2> mockOutputCreator = new MockOutputCreator();

    public MapDriver(Mapper<K1, V1, K2, V2> m) {
        this();
        this.setMapper(m);
    }

    public MapDriver() {
        this.setCounters(new Counters());
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(this.counters);
    }

    public MapDriver<K1, V1, K2, V2> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public void setMapper(Mapper<K1, V1, K2, V2> m) {
        this.myMapper = ArgumentChecker.returnNonNull(m);
    }

    public MapDriver<K1, V1, K2, V2> withMapper(Mapper<K1, V1, K2, V2> m) {
        this.setMapper(m);
        return this;
    }

    public Mapper<K1, V1, K2, V2> getMapper() {
        return this.myMapper;
    }

    public MapDriver<K1, V1, K2, V2> withOutputFormat(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.mockOutputCreator.setMapredFormats(outputFormatClass, inputFormatClass);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        try {
            this.preRunChecks(this.myMapper);
            this.initDistributedCache();
            OutputCollectable<K2, V2> outputCollectable = this.mockOutputCreator.createMapredOutputCollectable(this.getConfiguration(), this.getOutputSerializationConfiguration());
            MockReporter reporter = new MockReporter(MockReporter.ReporterType.Mapper, this.getCounters(), this.getMapInputPath());
            ReflectionUtils.setConf(this.myMapper, (Configuration)new JobConf(this.getConfiguration()));
            for (Pair kv : this.inputs) {
                this.myMapper.map(kv.getFirst(), kv.getSecond(), outputCollectable, (Reporter)reporter);
            }
            this.myMapper.close();
            List<Pair<K2, V2>> list = outputCollectable.getOutputs();
            return list;
        }
        finally {
            this.cleanupDistributedCache();
        }
    }

    public String toString() {
        return "MapDriver (" + this.myMapper + ")";
    }

    public static <K1, V1, K2, V2> MapDriver<K1, V1, K2, V2> newMapDriver() {
        return new MapDriver<K1, V1, K2, V2>();
    }

    public static <K1, V1, K2, V2> MapDriver<K1, V1, K2, V2> newMapDriver(Mapper<K1, V1, K2, V2> mapper) {
        return new MapDriver<K1, V1, K2, V2>(mapper);
    }
}

