/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mrunit.MapDriver;
import org.apache.hadoop.mrunit.MapOutputShuffler;
import org.apache.hadoop.mrunit.ReducePhaseRunner;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.driver.MultipleInputsMapReduceDriverBase;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;

public class MultipleInputsMapReduceDriver<K1, V1, K2, V2>
extends MultipleInputsMapReduceDriverBase<Mapper, K1, V1, K2, V2, MultipleInputsMapReduceDriver<K1, V1, K2, V2>> {
    public static final Log LOG = LogFactory.getLog(MultipleInputsMapReduceDriver.class);
    private Set<Mapper> mappers = new HashSet<Mapper>();
    private Reducer<K1, V1, K1, V1> combiner;
    private Reducer<K1, V1, K2, V2> reducer;
    private Counters counters;
    private Class<? extends OutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;

    public <K, V> void addMapper(Mapper<K, V, K1, V1> mapper) {
        this.mappers.add(ArgumentChecker.returnNonNull(mapper));
    }

    public <K, V> MultipleInputsMapReduceDriver<K1, V1, K2, V2> withMapper(Mapper<K, V, K1, V1> mapper) {
        this.addMapper(mapper);
        return this;
    }

    public Collection<Mapper> getMappers() {
        return this.mappers;
    }

    public void setCombiner(Reducer<K1, V1, K1, V1> combiner) {
        this.combiner = ArgumentChecker.returnNonNull(combiner);
    }

    public MultipleInputsMapReduceDriver<K1, V1, K2, V2> withCombiner(Reducer<K1, V1, K1, V1> combiner) {
        this.setCombiner(combiner);
        return this;
    }

    public Reducer<K1, V1, K1, V1> getCombiner() {
        return this.combiner;
    }

    public void setReducer(Reducer<K1, V1, K2, V2> reducer) {
        this.reducer = ArgumentChecker.returnNonNull(reducer);
    }

    public MultipleInputsMapReduceDriver<K1, V1, K2, V2> withReducer(Reducer<K1, V1, K2, V2> reducer) {
        this.setReducer(reducer);
        return this;
    }

    public Reducer<K1, V1, K2, V2> getReducer() {
        return this.reducer;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters counters) {
        this.counters = counters;
        this.counterWrapper = new CounterWrapper(counters);
    }

    public MultipleInputsMapReduceDriver<K1, V1, K2, V2> withCounter(Counters counters) {
        this.setCounters(counters);
        return this;
    }

    public MultipleInputsMapReduceDriver<K1, V1, K2, V2> withOutputFormat(Class<? extends OutputFormat> outputFormatClass) {
        this.outputFormatClass = ArgumentChecker.returnNonNull(outputFormatClass);
        return this;
    }

    public MultipleInputsMapReduceDriver<K1, V1, K2, V2> withInputFormat(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = ArgumentChecker.returnNonNull(inputFormatClass);
        return this;
    }

    public MultipleInputsMapReduceDriver(Reducer<K1, V1, K2, V2> reducer) {
        this();
        this.reducer = reducer;
    }

    public MultipleInputsMapReduceDriver(Reducer<K1, V1, K1, V1> combiner, Reducer<K1, V1, K2, V2> reducer) {
        this(reducer);
        this.combiner = combiner;
    }

    public MultipleInputsMapReduceDriver() {
        this.setCounters(new Counters());
    }

    public static <K1, V1, K2, V2> MultipleInputsMapReduceDriver<K1, V1, K2, V2> newMultipleInputMapReduceDriver(Reducer<K1, V1, K1, V1> combiner, Reducer<K1, V1, K2, V2> reducer) {
        return new MultipleInputsMapReduceDriver<K1, V1, K2, V2>(combiner, reducer);
    }

    public static <K1, V1, K2, V2> MultipleInputsMapReduceDriver<K1, V1, K2, V2> newMultipleInputMapReduceDriver(Reducer<K1, V1, K2, V2> reducer) {
        return new MultipleInputsMapReduceDriver<K1, V1, K2, V2>(reducer);
    }

    public static <K1, V1, K2, V2> MultipleInputsMapReduceDriver<K1, V1, K2, V2> newMultipleInputMapReduceDriver() {
        return new MultipleInputsMapReduceDriver<K1, V1, K2, V2>();
    }

    @Override
    public <K, V> void addInput(Mapper<K, V, K1, V1> mapper, K key, V val) {
        super.addInput(mapper, key, val);
    }

    @Override
    public <K, V> void addInput(Mapper<K, V, K1, V1> mapper, Pair<K, V> input) {
        super.addInput(mapper, input);
    }

    @Override
    public <K, V> void addAll(Mapper<K, V, K1, V1> mapper, List<Pair<K, V>> inputs) {
        super.addAll(mapper, inputs);
    }

    @Override
    public <K, V> MultipleInputsMapReduceDriver<K1, V1, K2, V2> withInput(Mapper<K, V, K1, V1> mapper, K key, V val) {
        return (MultipleInputsMapReduceDriver)super.withInput(mapper, key, val);
    }

    @Override
    public <K, V> MultipleInputsMapReduceDriver<K1, V1, K2, V2> withInput(Mapper<K, V, K1, V1> mapper, Pair<K, V> input) {
        return (MultipleInputsMapReduceDriver)super.withInput(mapper, input);
    }

    @Override
    public <K, V> MultipleInputsMapReduceDriver<K1, V1, K2, V2> withAll(Mapper<K, V, K1, V1> mapper, List<Pair<K, V>> inputs) {
        return (MultipleInputsMapReduceDriver)super.withAll(mapper, inputs);
    }

    @Override
    protected void preRunChecks(Set<Mapper> mappers, Object reducer) {
        if (mappers.isEmpty()) {
            throw new IllegalStateException("No mappers were provided");
        }
        super.preRunChecks(mappers, reducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        try {
            this.preRunChecks(this.mappers, (Object)this.reducer);
            this.initDistributedCache();
            List<Pair<Object, Object>> outputs = new ArrayList();
            MapOutputShuffler shuffler = new MapOutputShuffler(this.getConfiguration(), this.keyValueOrderComparator, this.keyGroupComparator);
            for (Mapper mapper : this.mappers) {
                MapDriver mapDriver = MapDriver.newMapDriver(mapper);
                mapDriver.setCounters(this.counters);
                mapDriver.setConfiguration(this.getConfiguration());
                mapDriver.addAll((List)this.inputs.get(mapper));
                mapDriver.withMapInputPath(this.getMapInputPath(mapper));
                outputs.addAll(mapDriver.run());
            }
            if (this.combiner != null) {
                LOG.debug((Object)("Starting combine phase with combiner: " + this.combiner));
                outputs = new ReducePhaseRunner(this.inputFormatClass, this.getConfiguration(), this.counters, this.getOutputSerializationConfiguration(), this.outputFormatClass).runReduce(shuffler.shuffle(outputs), this.combiner);
            }
            LOG.debug((Object)("Starting reduce phase with reducer: " + this.reducer));
            List<Pair<K2, V2>> list = new ReducePhaseRunner(this.inputFormatClass, this.getConfiguration(), this.counters, this.getOutputSerializationConfiguration(), this.outputFormatClass).runReduce(shuffler.shuffle(outputs), this.reducer);
            return list;
        }
        finally {
            this.cleanupDistributedCache();
        }
    }
}

