/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.h2;

import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.jdbcx.JdbcDataSource;

public final class H2Consumer
extends DbConsumer {
    private File dbFileName;

    public H2Consumer() {
        this(H2Consumer.getDefaultDbName());
    }

    public H2Consumer(File dbFileName) {
        this(dbFileName, H2Consumer.getDefaultChartsDir(), H2Consumer.getDefaultCustomKey());
    }

    public H2Consumer(File dbFileName, File chartsDir, String customKeyValue) {
        super(chartsDir, customKeyValue);
        this.dbFileName = dbFileName;
        try {
            this.checkSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot initialize H2 database.", e);
        }
    }

    private static File getDefaultDbName() {
        String dbPath = System.getProperty("jub.db.file");
        if (dbPath != null && !dbPath.trim().equals("")) {
            return new File(dbPath);
        }
        throw new IllegalArgumentException("Missing global property: jub.db.file");
    }

    @Override
    protected Connection createConnection() throws SQLException {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:" + this.dbFileName.getAbsolutePath() + ";DB_CLOSE_ON_EXIT=FALSE");
        ds.setUser("sa");
        Connection results = ds.getConnection();
        results.setAutoCommit(false);
        return results;
    }

    @Override
    public String getMethodChartResultsQuery() {
        return H2Consumer.getResource(H2Consumer.class, "method-chart-results.sql");
    }

    @Override
    public String getMethodChartPropertiesQuery() {
        return H2Consumer.getResource(H2Consumer.class, "method-chart-properties.sql");
    }

    @Override
    protected String getCreateRunsSql() {
        return H2Consumer.getResource(H2Consumer.class, "000-create-runs.sql");
    }

    @Override
    protected String getCreateTestsSql() {
        return H2Consumer.getResource(H2Consumer.class, "001-create-tests.sql");
    }

    @Override
    protected String getNewRunSql() {
        return H2Consumer.getResource(H2Consumer.class, "002-new-run.sql");
    }

    @Override
    protected String getTestInsertSql() {
        return H2Consumer.getResource(H2Consumer.class, "003-new-result.sql");
    }

    @Override
    protected String getCreateDbVersionSql() {
        return H2Consumer.getResource(H2Consumer.class, "004-create-dbversion.sql");
    }

    @Override
    protected String getAddCustomKeySql() {
        return H2Consumer.getResource(H2Consumer.class, "005-add-custom-key.sql");
    }
}

